/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyFullJavaVisitor;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InterfaceBodyFullJavaVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ArrayType;
import edu.rice.cs.javalanglevels.tree.BodyItemI;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConditionalExpression;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.InstanceofExpression;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.LabeledBreakStatement;
import edu.rice.cs.javalanglevels.tree.LabeledContinueStatement;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.SynchronizedStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclarator;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullJavaVisitor
extends LanguageLevelVisitor {
    public FullJavaVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classNamesInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classNamesInThisFile, continuations);
    }

    public FullJavaVisitor(File file) {
        this(file, new LinkedList<Pair<String, JExpressionIF>>(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>());
    }

    public FullJavaVisitor(File file, LinkedList<Pair<String, JExpressionIF>> errors, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles) {
        super(file, "", new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), continuations);
        FullJavaVisitor.errors = errors;
        FullJavaVisitor.visitedFiles = visitedFiles;
        _hierarchy = new Hashtable();
    }

    @Override
    public void createConstructor(SymbolData sd) {
        SymbolData superSd = sd.getSuperClass();
        if (sd.isContinuation()) {
            return;
        }
        String name = FullJavaVisitor.getUnqualifiedClassName(sd.getName());
        boolean hasOtherConstructor = sd.hasMethod(name);
        if (hasOtherConstructor) {
            LanguageLevelConverter._newSDs.remove(sd);
            System.err.println(sd + " removed from _newSDs.  _newSDs = " + LanguageLevelConverter._newSDs);
            return;
        }
        MethodData md = MethodData.make(name, new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[]{"public"}), new TypeParameter[0], sd, new VariableData[0], new String[0], sd, null);
        FullJavaVisitor.addGeneratedMethod(sd, md);
        LanguageLevelConverter._newSDs.remove(sd);
    }

    protected void handleInnerClassDef(InnerClassDef that, Data data, String name) {
        int i;
        this.forInnerClassDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        that.getSuperclass().visit(this);
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.defineInnerSymbolData(that, name, data);
        if (sd != null) {
            that.getBody().visit(new ClassBodyFullJavaVisitor(sd, "", this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
        }
        this.forInnerClassDefOnly(that);
    }

    protected void handleInnerInterfaceDef(InnerInterfaceDef that, Data data, String name) {
        this.forInnerInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        assert (that.getTypeParameters().length == 0);
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.defineInnerSymbolData(that, name, data);
        if (sd != null) {
            that.getBody().visit(new InterfaceBodyFullJavaVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        }
        this.forInnerInterfaceDefOnly(that);
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String[] modifiersAndVisibility = that.getModifiers();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (int i = 0; i < modifiersAndVisibility.length; ++i) {
            String temp = modifiersAndVisibility[i];
            if (temp.equals("abstract") || temp.equals("public") || temp.equals("private") || temp.equals("protected") || temp.equals("static") || temp.equals("final")) continue;
            sb.append(" \"" + temp + "\"");
            ++count;
        }
        return super.forModifiersAndVisibilityDoFirst(that);
    }

    @Override
    public Void forSwitchStatementDoFirst(SwitchStatement that) {
        return super.forSwitchStatementDoFirst(that);
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        return null;
    }

    @Override
    public Void forStaticInitializerDoFirst(StaticInitializer that) {
        return null;
    }

    @Override
    public Void forLabeledStatementDoFirst(LabeledStatement that) {
        return null;
    }

    @Override
    public Void forLabeledBreakStatementDoFirst(LabeledBreakStatement that) {
        return null;
    }

    @Override
    public Void forLabeledContinueStatementDoFirst(LabeledContinueStatement that) {
        return null;
    }

    @Override
    public Void forSynchronizedStatementDoFirst(SynchronizedStatement that) {
        return null;
    }

    @Override
    public Void forTypeParameterDoFirst(TypeParameter that) {
        return null;
    }

    @Override
    public Void forConditionalExpressionDoFirst(ConditionalExpression that) {
        return null;
    }

    @Override
    public Void forInstanceofExpressionDoFirst(InstanceofExpression that) {
        return null;
    }

    @Override
    public Void forPrimitiveTypeDoFirst(PrimitiveType that) {
        return super.forPrimitiveTypeDoFirst(that);
    }

    @Override
    public Void forTryCatchStatementDoFirst(TryCatchStatement that) {
        return super.forTryCatchStatementDoFirst(that);
    }

    private boolean _isClassInCurrentFile(String className) {
        for (String s : this._classNamesInThisFile) {
            if (!s.equals(className) && !s.endsWith("." + className)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected VariableData[] formalParameters2VariableData(FormalParameter[] fps, Data d) {
        VariableData[] varData = new VariableData[fps.length];
        String[] mav = d instanceof MethodData && d.hasModifier("static") ? new String[]{"final", "static"} : new String[]{"final"};
        for (int i = 0; i < varData.length; ++i) {
            VariableDeclarator vd = fps[i].getDeclarator();
            String name = vd.getName().getText();
            SymbolData type = this.getSymbolData(vd.getType().getName(), vd.getType().getSourceInfo());
            if (type == null) {
                type = d.getInnerClassOrInterface(vd.getType().getName());
            }
            if (type == null) {
                String typeName = d.getSymbolData().getName() + "." + vd.getType().getName();
                type = new SymbolData(typeName);
                d.getSymbolData().addInnerClass(type);
                type.setOuterData(d.getSymbolData());
                continuations.put(typeName, new Pair<SourceInfo, FullJavaVisitor>(vd.getType().getSourceInfo(), this));
            }
            varData[i] = new VariableData(name, new ModifiersAndVisibility(SourceInfo.NO_INFO, mav), type, true, d);
            varData[i].gotValue();
        }
        return varData;
    }

    @Override
    public Void forClassDef(ClassDef that) {
        int i;
        this.forClassDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.defineSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        that.getSuperclass().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            that.getBody().visit(new ClassBodyFullJavaVisitor(sd, className, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
        }
        this.forClassDefOnly(that);
        this._classesToBeParsed.remove(className);
        return null;
    }

    @Override
    public Void forBracedBodyDoFirst(BracedBody that) {
        for (BodyItemI bi : that.getStatements()) {
            if (!(bi instanceof TypeDefBase)) continue;
            TypeDefBase type = (TypeDefBase)((Object)bi);
            String rawClassName = type.getName().getText();
            _log.log("Adding " + rawClassName + " to _innerClassesToBeParsed inside " + that + "\n");
            this._innerClassesToBeParsed.add(this._enclosingClassName + "." + rawClassName);
        }
        return super.forBracedBodyDoFirst(that);
    }

    @Override
    protected void createToString(SymbolData sd) {
    }

    @Override
    protected void createHashCode(SymbolData sd) {
    }

    @Override
    protected void createEquals(SymbolData sd) {
    }

    @Override
    public Void forInterfaceDef(InterfaceDef that) {
        this.forInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.defineSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        assert (that.getTypeParameters().length == 0);
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            sd.setInterface(true);
            that.getBody().visit(new InterfaceBodyFullJavaVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        }
        this.forInterfaceDefOnly(that);
        this._classesToBeParsed.remove(className);
        return null;
    }

    public void anonymousClassInstantiationHelper(AnonymousClassInstantiation that, Data enclosing, SymbolData superC) {
        that.getArguments().visit(this);
        String anonName = this.getQualifiedClassName(enclosing.getSymbolData().getName()) + "$" + enclosing.getSymbolData().preincrementAnonymousInnerClassNum();
        SymbolData sd = new SymbolData(anonName);
        enclosing.addInnerClass(sd);
        sd.setOuterData(enclosing);
        if (superC != null && !superC.isInterface()) {
            sd.setSuperClass(superC);
        }
        sd.setPackage(this._package);
        that.getBody().visit(new ClassBodyFullJavaVisitor(sd, anonName, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
    }

    public void simpleAnonymousClassInstantiationHelper(SimpleAnonymousClassInstantiation that, Data data) {
        this.forSimpleAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        SymbolData superC = this.getSymbolData(that.getType().getName(), that.getSourceInfo());
        this.anonymousClassInstantiationHelper(that, data, superC);
        this.forSimpleAnonymousClassInstantiationOnly(that);
    }

    public void complexAnonymousClassInstantiationHelper(ComplexAnonymousClassInstantiation that, Data data) {
        this.forComplexAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getEnclosing().visit(this);
        this.anonymousClassInstantiationHelper(that, data, null);
        this.forComplexAnonymousClassInstantiationOnly(that);
    }

    @Override
    public Void forArrayType(ArrayType that) {
        this.forArrayTypeDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        this.getSymbolData(that.getName(), that.getSourceInfo());
        return null;
    }
}

