/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import java.io.PrintWriter;
import java.util.ArrayList;
import koala.dynamicjava.tree.SourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeException
extends InterpreterException {
    private final SizedIterable<InterpreterException> _exceptions;

    public CompositeException(Iterable<? extends InterpreterException> exceptions) {
        super(CompositeException.extractCause(exceptions));
        this._exceptions = IterUtil.snapshot(exceptions);
    }

    private static InterpreterException extractCause(Iterable<? extends InterpreterException> exceptions) {
        return IterUtil.isEmpty(exceptions) ? null : IterUtil.first(exceptions);
    }

    @Override
    public void printUserMessage(PrintWriter out) {
        out.println(this._exceptions.size() + " errors:");
        for (InterpreterException e : this._exceptions) {
            out.println();
            if (e instanceof SourceInfo.Wrapper) {
                out.println(((SourceInfo.Wrapper)((Object)e)).getSourceInfo());
            } else {
                out.println("[Unknown location]");
            }
            e.printUserMessage(out);
        }
    }

    public SizedIterable<InterpreterException> exceptions() {
        return this._exceptions;
    }

    public static InterpreterException make(Iterable<? extends InterpreterException> errors) {
        ArrayList<InterpreterException> normalized = new ArrayList<InterpreterException>();
        for (InterpreterException interpreterException : errors) {
            if (interpreterException instanceof CompositeException) {
                CollectUtil.addAll(normalized, ((CompositeException)interpreterException).exceptions());
                continue;
            }
            normalized.add(interpreterException);
        }
        return new CompositeException(normalized);
    }
}

