/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOptionComponent
extends OptionComponent<File, FileSelectorComponent>
implements OptionConstants {
    private volatile FileSelectorComponent _component;

    public FileOptionComponent(FileOption opt, String text, SwingFrame parent, JFileChooser jfc) {
        super(opt, text, parent);
        this._component = new FileSelectorComponent(parent, jfc, 30, 10.0f);
        File setting = (File)DrJava.getConfig().getSetting(this._option);
        if (setting != this._option.getDefault()) {
            this._component.setFileField(setting);
        }
        this._component.getFileField().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }

            public void removeUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }

            public void changedUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }
        });
        this.setComponent(this._component);
    }

    public FileOptionComponent(FileOption opt, String text, SwingFrame parent, String description, JFileChooser jfc) {
        this(opt, text, parent, jfc);
        this.setDescription(description);
    }

    public FileOptionComponent(FileOption opt, String text, SwingFrame parent, FileSelectorComponent fsc) {
        super(opt, text, parent);
        this._component = fsc;
        File setting = (File)DrJava.getConfig().getSetting(this._option);
        if (setting != this._option.getDefault()) {
            this._component.setFileField(setting);
        }
        this._component.getFileField().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }

            public void removeUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }

            public void changedUpdate(DocumentEvent e) {
                FileOptionComponent.this.notifyChangeListeners();
            }
        });
        this.setComponent(this._component);
    }

    public FileOptionComponent(FileOption opt, String text, SwingFrame parent, String description, FileSelectorComponent fsc) {
        this(opt, text, parent, fsc);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._component.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        File componentFile = this._component.getFileFromField();
        File currentFile = (File)DrJava.getConfig().getSetting(this._option);
        if (componentFile != null && !componentFile.equals(currentFile)) {
            DrJava.getConfig().setSetting(this._option, componentFile);
        } else if (componentFile == null) {
            DrJava.getConfig().setSetting(this._option, this._option.getDefault());
        }
        return true;
    }

    @Override
    public void setValue(File value) {
        this._component.setFileField(value);
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._component.setFileFilter(fileFilter);
    }
}

