/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.io.File;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryOptionComponent
extends OptionComponent<File, DirectorySelectorComponent>
implements OptionConstants {
    private DirectorySelectorComponent _component;

    public DirectoryOptionComponent(FileOption opt, String text, SwingFrame parent, DirectoryChooser dc) {
        super(opt, text, parent);
        this._component = new DirectorySelectorComponent(parent, dc, 30, 10.0f);
        this._component.setFileField((File)DrJava.getConfig().getSetting(this._option));
        this._component.getFileField().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                DirectoryOptionComponent.this.notifyChangeListeners();
            }

            public void removeUpdate(DocumentEvent e) {
                DirectoryOptionComponent.this.notifyChangeListeners();
            }

            public void changedUpdate(DocumentEvent e) {
                DirectoryOptionComponent.this.notifyChangeListeners();
            }
        });
        this.setComponent(this._component);
    }

    public DirectoryOptionComponent(FileOption opt, String text, SwingFrame parent, String desc, DirectoryChooser dc) {
        this(opt, text, parent, dc);
        this.setDescription(desc);
    }

    @Override
    public void setDescription(String description) {
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        File componentFile = this._component.getFileFromField();
        File currentFile = (File)DrJava.getConfig().getSetting(this._option);
        if (componentFile != null && !componentFile.equals(currentFile)) {
            DrJava.getConfig().setSetting(this._option, componentFile);
        } else if (componentFile == null) {
            DrJava.getConfig().setSetting(this._option, this._option.getDefault());
        }
        return true;
    }

    @Override
    public void setValue(File value) {
        this._component.setFileField(value);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this._component.addChoosableFileFilter(filter);
    }
}

