/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class JavaSourceFilter
extends FileFilter {
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = JavaSourceFilter.getExtension(f);
        if (extension != null) {
            switch (DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL)) {
                case 0: {
                    return extension.equals(".java");
                }
                case 1: {
                    return extension.equals(".dj0");
                }
                case 2: {
                    return extension.equals(".dj1");
                }
                case 3: {
                    return extension.equals(".dj2");
                }
                case 4: {
                    return extension.equals(".dj");
                }
            }
        }
        return false;
    }

    public String getDescription() {
        switch (DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL)) {
            case 0: {
                return "Java source files (*.java)";
            }
            case 1: {
                return "Elementary source files (*.dj0)";
            }
            case 2: {
                return "Intermediate source files (*.dj1)";
            }
            case 3: {
                return "Advanced source files (*.dj2)";
            }
            case 4: {
                return "Functional Java source files (*.dj)";
            }
        }
        return "Java source files";
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i).toLowerCase();
        }
        return ext;
    }
}

