/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class AbstractConsoleController {
    protected final InteractionsDJDocument _interactionsDJDocument;
    protected final InteractionsPane _pane;
    protected final SimpleAttributeSet _defaultStyle;
    protected final SimpleAttributeSet _systemOutStyle;
    protected final SimpleAttributeSet _systemErrStyle;
    volatile Action switchToPrevPaneAction;
    volatile Action switchToNextPaneAction;
    Action cutAction = new DefaultEditorKit.CutAction(){

        public void actionPerformed(ActionEvent e) {
            if (AbstractConsoleController.this._pane.getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(AbstractConsoleController.this._pane);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };
    Action copyAction = new DefaultEditorKit.CopyAction(){

        public void actionPerformed(ActionEvent e) {
            if (AbstractConsoleController.this._pane.getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(AbstractConsoleController.this._pane);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };
    AbstractAction newLineAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ConsoleDocument doc = AbstractConsoleController.this.getConsoleDoc();
            doc.insertNewline(AbstractConsoleController.this._pane.getCaretPosition());
        }
    };
    AbstractAction clearCurrentAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractConsoleController.this.getConsoleDoc().clearCurrentInput();
        }
    };
    AbstractAction gotoEndAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractConsoleController.this.moveToEnd();
        }
    };
    AbstractAction selectToEndAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ConsoleDocument doc = AbstractConsoleController.this.getConsoleDoc();
            AbstractConsoleController.this._pane.moveCaretPosition(doc.getLength());
        }
    };
    AbstractAction gotoPromptPosAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractConsoleController.this.moveToPrompt();
        }
    };
    AbstractAction selectToPromptPosAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            assert (EventQueue.isDispatchThread());
            ConsoleDocument doc = AbstractConsoleController.this.getConsoleDoc();
            AbstractConsoleController.this._pane.moveCaretPosition(doc.getPromptPos());
        }
    };

    protected AbstractConsoleController(InteractionsDJDocument doc, InteractionsPane pane) {
        this._interactionsDJDocument = doc;
        this._pane = pane;
        this._defaultStyle = new SimpleAttributeSet();
        this._systemOutStyle = new SimpleAttributeSet();
        this._systemErrStyle = new SimpleAttributeSet();
    }

    public abstract ConsoleDocument getConsoleDoc();

    protected void _init() {
        this._addDocumentStyles();
        this._setupModel();
        this._setupView();
    }

    protected void _addDocumentStyles() {
        this._interactionsDJDocument.setDocStyle("default", this._defaultStyle);
        this._systemOutStyle.addAttributes(this._defaultStyle);
        this._systemOutStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.SYSTEM_OUT_COLOR));
        this._interactionsDJDocument.setDocStyle("System.out", this._systemOutStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_OUT_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                AbstractConsoleController.this._systemOutStyle.addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
        this._systemErrStyle.addAttributes(this._defaultStyle);
        this._systemErrStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.SYSTEM_ERR_COLOR));
        this._interactionsDJDocument.setDocStyle("System.err", this._systemErrStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_ERR_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                AbstractConsoleController.this._systemErrStyle.addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
    }

    protected abstract void _setupModel();

    protected void _setupView() {
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_BEGIN_LINE)), (Action)this.gotoPromptPosAction);
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_BEGIN_LINE_SELECT)), (Action)this.selectToPromptPosAction);
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_END_LINE)), (Action)this.gotoEndAction);
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_END_LINE_SELECT)), (Action)this.selectToEndAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_BEGIN_LINE, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)oe.value, (Action)AbstractConsoleController.this.gotoPromptPosAction);
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_BEGIN_LINE_SELECT, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)oe.value, (Action)AbstractConsoleController.this.selectToPromptPosAction);
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_END_LINE, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)oe.value, (Action)AbstractConsoleController.this.gotoEndAction);
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_END_LINE_SELECT, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)oe.value, (Action)AbstractConsoleController.this.selectToEndAction);
            }
        });
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_CUT)), this.cutAction);
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_COPY)), this.copyAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_CUT, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_CUT)), AbstractConsoleController.this.cutAction);
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_COPY, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_COPY)), AbstractConsoleController.this.copyAction);
            }
        });
    }

    public void resetView() {
    }

    public InteractionsDJDocument getDocumentAdapter() {
        return this._interactionsDJDocument;
    }

    public InteractionsPane getPane() {
        return this._pane;
    }

    protected boolean _busy() {
        return !this.getConsoleDoc().hasPrompt();
    }

    void moveToEnd() {
        assert (EventQueue.isDispatchThread());
        int len = this.getConsoleDoc().getLength();
        this._pane.setCaretPosition(len);
    }

    void moveToPrompt() {
        assert (EventQueue.isDispatchThread());
        int pos = this.getConsoleDoc().getPromptPos();
        this._pane.setCaretPosition(pos);
    }

    public void setPrevPaneAction(Action a) {
        this.switchToPrevPaneAction = a;
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_PANE)), this.switchToPrevPaneAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_PREVIOUS_PANE, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_PANE)), AbstractConsoleController.this.switchToPrevPaneAction);
            }
        });
    }

    public void setNextPaneAction(Action a) {
        this.switchToNextPaneAction = a;
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_PANE)), this.switchToNextPaneAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_NEXT_PANE, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                AbstractConsoleController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_PANE)), AbstractConsoleController.this.switchToNextPaneAction);
            }
        });
    }
}

