/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.reflect.PathClassLoader;
import java.io.File;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathManager
implements Lambda<ClassLoader, ClassLoader> {
    private final LinkedList<File> _projectCP;
    private final LinkedList<File> _buildCP;
    private final LinkedList<File> _projectFilesCP;
    private final LinkedList<File> _externalFilesCP;
    private final LinkedList<File> _extraCP;
    private final Iterable<File> _fullPath;
    public static final String INTERACTIONS_CLASS_PATH_PROPERTY = "edu.rice.cs.drjava.interactions.class.path";
    private final Lambda<Iterable<File>, Iterable<File>> _makeSafeSnapshot = new Lambda<Iterable<File>, Iterable<File>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<File> value(Iterable<File> arg) {
            ClassPathManager classPathManager = ClassPathManager.this;
            synchronized (classPathManager) {
                return IterUtil.snapshot(arg);
            }
        }
    };

    public ClassPathManager(Iterable<File> builtInCP) {
        this._projectCP = new LinkedList();
        this._buildCP = new LinkedList();
        this._projectFilesCP = new LinkedList();
        this._externalFilesCP = new LinkedList();
        this._extraCP = new LinkedList();
        SizedIterable<SnapshotIterable<File>> allPaths = IterUtil.make(IterUtil.asSizedIterable(this._projectCP), IterUtil.asSizedIterable(this._buildCP), IterUtil.asSizedIterable(this._projectFilesCP), IterUtil.asSizedIterable(this._externalFilesCP), IterUtil.asSizedIterable(this._extraCP), IterUtil.snapshot(builtInCP));
        this._fullPath = IterUtil.collapse(IterUtil.map(allPaths, this._makeSafeSnapshot));
        this.updateProperty();
    }

    protected void updateProperty() {
        System.setProperty(INTERACTIONS_CLASS_PATH_PROPERTY, IOUtil.pathToString(this._fullPath));
    }

    public synchronized void addProjectCP(File f) {
        this._projectCP.addFirst(f);
        this.updateProperty();
    }

    public synchronized Iterable<File> getProjectCP() {
        return IterUtil.snapshot(this._projectCP);
    }

    public synchronized void addBuildDirectoryCP(File f) {
        this._buildCP.remove(f);
        this._buildCP.addFirst(f);
        this.updateProperty();
    }

    public synchronized Iterable<File> getBuildDirectoryCP() {
        return IterUtil.snapshot(this._buildCP);
    }

    public synchronized void addProjectFilesCP(File f) {
        this._projectFilesCP.remove(f);
        this._projectFilesCP.addFirst(f);
        this.updateProperty();
    }

    public synchronized Iterable<File> getProjectFilesCP() {
        return IterUtil.snapshot(this._projectFilesCP);
    }

    public synchronized void addExternalFilesCP(File f) {
        this._externalFilesCP.remove(f);
        this._externalFilesCP.addFirst(f);
        this.updateProperty();
    }

    public synchronized Iterable<File> getExternalFilesCP() {
        return IterUtil.snapshot(this._externalFilesCP);
    }

    public synchronized void addExtraCP(File f) {
        this._extraCP.remove(f);
        this._extraCP.addFirst(f);
        this.updateProperty();
    }

    public Iterable<File> getExtraCP() {
        return IterUtil.snapshot(this._extraCP);
    }

    public synchronized ClassLoader makeClassLoader(ClassLoader parent) {
        this.updateProperty();
        return new PathClassLoader(parent, this._fullPath);
    }

    @Override
    public ClassLoader value(ClassLoader parent) {
        return this.makeClassLoader(parent);
    }

    public synchronized Iterable<File> getClassPath() {
        this.updateProperty();
        return this._fullPath;
    }
}

