/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DefaultGlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.LanguageLevelStackTraceMapper;
import edu.rice.cs.drjava.model.repl.RMIInteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInteractionsModel
extends RMIInteractionsModel {
    protected final DefaultGlobalModel _model;

    public DefaultInteractionsModel(DefaultGlobalModel model, MainJVM jvm, ConsoleDocumentInterface cDoc, File wd) {
        super(jvm, cDoc, wd, DrJava.getConfig().getSetting(OptionConstants.HISTORY_MAX_SIZE), 50);
        this._model = model;
        Boolean allow = DrJava.getConfig().getSetting(OptionConstants.RUN_WITH_ASSERT);
        this._jvm.setAllowAssertions(allow);
        DrJava.getConfig().addOptionListener(OptionConstants.HISTORY_MAX_SIZE, this._document.getHistoryOptionListener());
        DrJava.getConfig().addOptionListener(OptionConstants.RUN_WITH_ASSERT, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                DefaultInteractionsModel.this._jvm.setAllowAssertions((Boolean)oce.value);
            }
        });
    }

    @Override
    public void replSystemOutPrint(String s) {
        super.replSystemOutPrint(s);
        this._model.systemOutPrint(s);
    }

    @Override
    public void replSystemErrPrint(String s) {
        super.replSystemErrPrint(s);
        this._model.systemErrPrint(s);
    }

    @Override
    public String getConsoleInput() {
        String s = super.getConsoleInput();
        this._model.systemInEcho(s);
        return s;
    }

    @Override
    protected void _interpreterResetFailed(final Throwable t) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._document.insertBeforeLastPrompt("Reset Failed! See the console tab for details.\n", "error");
                DefaultInteractionsModel.this._model.systemErrPrint(StringOps.getStackTrace(t));
            }
        });
    }

    @Override
    protected void _interpreterWontStart(final Exception e) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._document.insertBeforeLastPrompt("JVM failed to start.  Make sure a firewall is not blocking \ninter-process communication.  See the console tab for details.\n", "error");
                DefaultInteractionsModel.this._model.systemErrPrint(StringOps.getStackTrace(e));
            }
        });
    }

    @Override
    public void interpreterReady(File wd) {
        this._model.resetInteractionsClassPath();
        super.interpreterReady(wd);
    }

    @Override
    public void _notifyInteractionStarted() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionStarted();
            }
        });
    }

    @Override
    protected void _notifyInteractionEnded() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionEnded();
            }
        });
    }

    @Override
    protected void _notifySyntaxErrorOccurred(final int offset, final int length) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionErrorOccurred(offset, length);
            }
        });
    }

    @Override
    protected void _notifyInterpreterChanged(final boolean inProgress) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterChanged(inProgress);
            }
        });
    }

    @Override
    protected void _notifyInterpreterResetting() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterResetting();
            }
        });
    }

    @Override
    public void _notifyInterpreterReady(final File wd) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterReady(wd);
            }
        });
    }

    @Override
    protected void _notifyInterpreterExited(final int status) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterExited(status);
            }
        });
    }

    @Override
    protected void _notifyInterpreterResetFailed(final Throwable t) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interpreterResetFailed(t);
            }
        });
    }

    @Override
    protected void _notifyInteractionIncomplete() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultInteractionsModel.this._notifier.interactionIncomplete();
            }
        });
    }

    @Override
    public ConsoleDocument getConsoleDocument() {
        return this._model.getConsoleDocument();
    }

    @Override
    public StackTraceElement[] replaceLLException(StackTraceElement[] stackTrace) {
        LanguageLevelStackTraceMapper LLSTM = this._model.getCompilerModel().getLLSTM();
        ArrayList<File> files = new ArrayList<File>();
        for (OpenDefinitionsDocument odd : this._model.getLLOpenDefinitionsDocuments()) {
            files.add(odd.getRawFile());
        }
        return LLSTM.replaceStackTrace(stackTrace, files);
    }

    @Override
    public List<File> getCompilerBootClassPath() {
        return this._model.getCompilerModel().getActiveCompiler().additionalBootClassPathForInteractions();
    }

    @Override
    public String transformCommands(String interactionsString) {
        return this._model.getCompilerModel().getActiveCompiler().transformCommands(interactionsString);
    }
}

