/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.LineNotExecutableException;
import edu.rice.cs.drjava.model.debug.jpda.DebugAction;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentDebugAction<T extends EventRequest>
extends DebugAction<T> {
    protected volatile String _className;
    protected volatile String _exactClassName = null;
    protected volatile File _file;
    protected volatile OpenDefinitionsDocument _doc;
    protected int _offset;
    public final int SHORT_DOC_MAX_LENGTH = 20000;

    public DocumentDebugAction(JPDADebugger manager, OpenDefinitionsDocument doc, int offset) throws DebugException {
        super(manager);
        try {
            if (offset >= 0 && doc.getLength() < 20000) {
                this._exactClassName = doc.getEnclosingClassName(offset, true);
            }
        }
        catch (ClassNameNotFoundException cnnfe) {
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        try {
            if (offset >= 0) {
                this._className = doc.getQualifiedClassName(offset);
            }
        }
        catch (ClassNameNotFoundException cnnfe) {
            this._className = "";
        }
        try {
            this._file = doc.getFile();
            if (this._file == null) {
                throw new DebugException("This document has no source file.");
            }
        }
        catch (FileMovedException fme) {
            throw new DebugException("This document's file no longer exists: " + fme.getMessage());
        }
        this._doc = doc;
        this._offset = offset;
    }

    public String getClassName() {
        return this._className;
    }

    public File getFile() {
        return this._file;
    }

    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public int getOffset() {
        return this._offset;
    }

    public String getExactClassName() {
        return this._exactClassName;
    }

    public boolean createRequests(Vector<ReferenceType> refTypes) throws DebugException {
        this._createRequests(refTypes);
        if (this._requests.size() > 0) {
            this._prepareRequests(this._requests);
            return true;
        }
        return false;
    }

    protected void _initializeRequests(Vector<ReferenceType> refTypes) throws DebugException {
        List<ReferenceType> referenceTypes;
        if (refTypes.size() > 0) {
            this.createRequests(refTypes);
        } else if (this._exactClassName != null && (referenceTypes = this._manager.getVM().classesByName(this._exactClassName)).size() > 0) {
            throw new LineNotExecutableException("Cannot set breakpoint, line " + this.getLineNumber() + " is not an executable line.\nYou may have to recompile.");
        }
        this._manager.getPendingRequestManager().addPendingRequest(this);
    }

    protected abstract void _createRequests(Vector<ReferenceType> var1) throws DebugException;

    @Override
    protected void _prepareRequest(T request) {
        super._prepareRequest(request);
        request.putProperty("document", this._doc);
    }
}

