/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavacCompiler
implements CompilerInterface {
    protected final JavaVersion.FullVersion _version;
    protected final String _location;
    protected List<? extends File> _defaultBootClassPath;

    protected JavacCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        this._version = version;
        this._location = location;
        this._defaultBootClassPath = defaultBootClassPath;
    }

    @Override
    public abstract boolean isAvailable();

    @Override
    public abstract List<? extends DJError> compile(List<? extends File> var1, List<? extends File> var2, List<? extends File> var3, File var4, List<? extends File> var5, String var6, boolean var7);

    @Override
    public JavaVersion version() {
        return this._version.majorVersion();
    }

    @Override
    public String getName() {
        return "JDK " + this._version.versionString();
    }

    @Override
    public String getDescription() {
        return this.getName() + " from " + this._location;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        return new ArrayList<File>();
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("java ")) {
            interactionsString = JavacCompiler.transformJavaCommand(interactionsString);
        } else if (interactionsString.startsWith("applet ")) {
            interactionsString = JavacCompiler.transformAppletCommand(interactionsString);
        } else if (interactionsString.startsWith("run ")) {
            interactionsString = JavacCompiler.transformRunCommand(interactionsString);
        }
        return interactionsString;
    }

    public static String transformJavaCommand(String s) {
        String command = "try '{'\n  java.lang.reflect.Method m = {0}.class.getMethod(\"main\", java.lang.String[].class);\n  if (!m.getReturnType().equals(void.class)) throw new java.lang.NoSuchMethodException();\n'}'\ncatch (java.lang.NoSuchMethodException e) '{'\n  throw new java.lang.NoSuchMethodError(\"main\");\n'}'\n{0}.main(new String[]'{'{1}'}');";
        return JavacCompiler._transformCommand(s, command);
    }

    public static String transformAppletCommand(String s) {
        return JavacCompiler._transformCommand(s, "edu.rice.cs.plt.swing.SwingUtil.showApplet(new {0}({1}), 400, 300);");
    }

    public static String transformRunCommand(String s) {
        String command = "'{' boolean isProgram = false; boolean isApplet = false; Class c = {0}.class;\nwhile(c != null) '{'\n  if (\"acm.program.Program\".equals(c.getName())) '{' isProgram = true; break; '}'\n  c = c.getSuperclass();\n'}'\nif (!isProgram) '{'\n  try '{'\n    {0}.class.asSubclass(java.applet.Applet.class);\n    isApplet = true;\n  '}' catch(ClassCastException cce) '{' '}'\n'}'\nif (isApplet) '{'\n  edu.rice.cs.plt.swing.SwingUtil.showApplet(java.applet.Applet.class.cast(new {0}({1})), 400, 300);\n'}'\nelse '{'  java.lang.reflect.Method m = null;\n  try '{'\n    m = {0}.class.getMethod(\"main\", java.lang.String[].class);\n    if (!m.getReturnType().equals(void.class)) throw new java.lang.NoSuchMethodException();\n  '}'\n  catch (java.lang.NoSuchMethodException e) '{'\n    throw new java.lang.NoSuchMethodError(\"main\");\n  '}'\n  String[] args = new String[]'{'{1}'}';\n  if (isProgram) '{'\n    String[] newArgs = new String[args.length+1];\n    newArgs[0] = \"code={0}\";\n    System.arraycopy(args, 0, newArgs, 1, args.length);\n    args = newArgs;\n  '}'\n  try '{'    m.setAccessible(true);\n    m.invoke(null, new Object[] '{' args '}');\n  '}' catch(SecurityException se) '{'\n    System.err.println(\"Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.\");\n  '}' catch(IllegalAccessException iae) '{'\n    System.err.println(\"Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.\");\n  '}' catch(java.lang.reflect.InvocationTargetException ite) '{'\n    if (ite.getCause()!=null) throw ite.getCause(); else\n    System.err.println(\"Error: Please turn off 'Smart Run' or use 'java' command instead of 'run'.\");\n'}' '}' '}'";
        return JavacCompiler._transformCommand(s, command);
    }

    protected static String _transformCommand(String s, String command) {
        if (s.endsWith(";")) {
            s = JavacCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        StringBuilder argsString = new StringBuilder();
        boolean seenArg = false;
        for (int i = 2; i < args.size(); ++i) {
            if (seenArg) {
                argsString.append(",");
            } else {
                seenArg = true;
            }
            argsString.append(args.get(i));
        }
        return MessageFormat.format(command, className, argsString.toString());
    }

    protected static String _deleteSemiColon(String s) {
        return s.substring(0, s.length() - 1);
    }
}

