/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.plt.io.IOUtil;
import java.io.File;

public class DrJavaFileUtils {
    public static boolean isSourceFile(String fileName) {
        return fileName.endsWith(".java") || fileName.endsWith(".dj") || fileName.endsWith(".dj0") || fileName.endsWith(".dj1") || fileName.endsWith(".dj2");
    }

    public static boolean isSourceFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return DrJavaFileUtils.isSourceFile(fileName);
    }

    public static boolean isLLFile(String fileName) {
        return fileName.endsWith(".dj") || fileName.endsWith(".dj0") || fileName.endsWith(".dj1") || fileName.endsWith(".dj2");
    }

    public static boolean isLLFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return DrJavaFileUtils.isLLFile(fileName);
    }

    public static boolean isOldLLFile(String fileName) {
        return fileName.endsWith(".dj0") || fileName.endsWith(".dj1") || fileName.endsWith(".dj2");
    }

    public static boolean isOldLLFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return DrJavaFileUtils.isOldLLFile(fileName);
    }

    public static boolean isOldProjectFile(String fileName) {
        return fileName.endsWith(".pjt");
    }

    public static boolean isOldProjectFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return DrJavaFileUtils.isOldProjectFile(fileName);
    }

    public static boolean isProjectFile(String fileName) {
        return fileName.endsWith(".drjava") || fileName.endsWith(".xml") || fileName.endsWith(".pjt");
    }

    public static boolean isProjectFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return DrJavaFileUtils.isProjectFile(fileName);
    }

    public static String getJavaForLLFile(String fileName) {
        if (fileName.endsWith(".dj")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj")) + ".java";
        }
        if (fileName.endsWith(".dj0")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj0")) + ".java";
        }
        if (fileName.endsWith(".dj1")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj1")) + ".java";
        }
        if (fileName.endsWith(".dj2")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj2")) + ".java";
        }
        return fileName;
    }

    public static File getJavaForLLFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return new File(DrJavaFileUtils.getJavaForLLFile(fileName));
    }

    public static File getDJForJavaFile(File f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj");
    }

    public static File getDJ0ForJavaFile(File f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj0");
    }

    public static File getDJ1ForJavaFile(File f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj1");
    }

    public static File getDJ2ForJavaFile(File f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj2");
    }

    public static String getDJForJavaFile(String f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj");
    }

    public static String getDJ0ForJavaFile(String f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj0");
    }

    public static String getDJ1ForJavaFile(String f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj1");
    }

    public static String getDJ2ForJavaFile(String f) {
        return DrJavaFileUtils.getFileWithDifferentExt(f, ".java", ".dj2");
    }

    public static String getNewLLForOldLLFile(String fileName) {
        if (fileName.endsWith(".dj0")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj0")) + ".dj";
        }
        if (fileName.endsWith(".dj1")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj1")) + ".dj";
        }
        if (fileName.endsWith(".dj2")) {
            return fileName.substring(0, fileName.lastIndexOf(".dj2")) + ".java";
        }
        return fileName;
    }

    public static File getNewLLForOldLLFile(File f) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return new File(DrJavaFileUtils.getNewLLForOldLLFile(fileName));
    }

    public static String getFileWithDifferentExt(String fileName, String source, String dest) {
        if (fileName.endsWith(source)) {
            return fileName.substring(0, fileName.lastIndexOf(source)) + dest;
        }
        return fileName;
    }

    public static File getFileWithDifferentExt(File f, String source, String dest) {
        File canonicalFile = IOUtil.attemptCanonicalFile(f);
        String fileName = canonicalFile.getPath();
        return new File(DrJavaFileUtils.getFileWithDifferentExt(fileName, source, dest));
    }

    public static String getPackageDir(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, lastDotIndex);
        packageName = packageName.replace('.', File.separatorChar);
        return packageName + File.separatorChar;
    }

    public static String removeExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, lastDotIndex);
    }

    public static String getExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return fileName.substring(lastDotIndex);
    }
}

