/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.DummyDocumentRegion;
import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteRegionManager<R extends OrderedDocumentRegion>
extends EventNotifier<RegionManagerListener<R>>
implements RegionManager<R> {
    private volatile HashMap<OpenDefinitionsDocument, SortedSet<R>> _regions = new HashMap();
    private volatile Set<OpenDefinitionsDocument> _documents = new HashSet<OpenDefinitionsDocument>();
    private static final SortedSet<Object> EMPTY_SET = new TreeSet<Object>();

    @Override
    public Set<OpenDefinitionsDocument> getDocuments() {
        return this._documents;
    }

    private <T> T emptySet() {
        return (T)EMPTY_SET;
    }

    private <T> T newDocumentRegion(OpenDefinitionsDocument odd, int start, int end) {
        return (T)new DocumentRegion(odd, start, end);
    }

    @Override
    public SortedSet<R> getHeadSet(R r) {
        SortedSet<R> oddRegions = this._regions.get(r.getDocument());
        if (oddRegions == null || oddRegions.isEmpty()) {
            return (SortedSet)this.emptySet();
        }
        return oddRegions.headSet(r);
    }

    @Override
    public SortedSet<R> getTailSet(R r) {
        SortedSet<R> oddRegions = this._regions.get(r.getDocument());
        if (oddRegions == null || oddRegions.isEmpty()) {
            return (SortedSet)this.emptySet();
        }
        return oddRegions.tailSet(r);
    }

    @Override
    public R getRegionAt(OpenDefinitionsDocument odd, int offset) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        SortedSet<OrderedDocumentRegion> tail = this.getTailSet((R)((OrderedDocumentRegion)this.newDocumentRegion(odd, 0, offset + 1)));
        if (tail.size() == 0) {
            return null;
        }
        OrderedDocumentRegion r = tail.first();
        if (r.getStartOffset() <= offset) {
            return (R)r;
        }
        return null;
    }

    @Override
    public Pair<R, R> getRegionInterval(OpenDefinitionsDocument odd, int offset) {
        int lineEnd;
        OrderedDocumentRegion r;
        int lineStart;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        SortedSet<DocumentRegion> tail = this.getTailSet((R)new DocumentRegion(odd, 0, offset - 119));
        if (tail.size() == 0) {
            return null;
        }
        Iterator it = tail.iterator();
        OrderedDocumentRegion first = null;
        OrderedDocumentRegion last = null;
        while (it.hasNext() && (lineStart = (r = (OrderedDocumentRegion)it.next()).getLineStartOffset()) <= offset) {
            lineEnd = r.getLineEndOffset();
            if (lineStart - 1 > offset || lineEnd < offset) continue;
            first = r;
            break;
        }
        if (first == null) {
            return null;
        }
        last = first;
        while (it.hasNext() && (lineStart = (r = (OrderedDocumentRegion)it.next()).getLineStartOffset()) <= offset) {
            lineEnd = r.getLineEndOffset();
            if (lineStart > offset || lineEnd < offset) continue;
            last = r;
        }
        return new Pair<Object, Object>(first, last);
    }

    @Override
    public Collection<R> getRegionsOverlapping(OpenDefinitionsDocument odd, int startOffset, int endOffset) {
        OrderedDocumentRegion r;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        LinkedList<OrderedDocumentRegion> result = new LinkedList<OrderedDocumentRegion>();
        if (startOffset == endOffset) {
            return result;
        }
        SortedSet<OrderedDocumentRegion> tail = this.getTailSet((R)((OrderedDocumentRegion)this.newDocumentRegion(odd, 0, startOffset + 1)));
        Iterator i$ = tail.iterator();
        while (i$.hasNext() && (r = (OrderedDocumentRegion)i$.next()).getStartOffset() < endOffset) {
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(R region) {
        boolean alreadyPresent;
        OpenDefinitionsDocument odd = region.getDocument();
        SortedSet<R> docRegions = this._regions.get(odd);
        if (docRegions == null) {
            this._documents.add(odd);
            docRegions = new TreeSet<R>();
            this._regions.put(odd, docRegions);
        }
        if (!(alreadyPresent = docRegions.contains(region))) {
            docRegions.add(region);
        }
        assert (this._documents.contains(odd));
        if (!alreadyPresent) {
            this._lock.startRead();
            try {
                for (RegionManagerListener l : this._listeners) {
                    l.regionAdded(region);
                }
            }
            finally {
                this._lock.endRead();
            }
        }
    }

    @Override
    public void removeRegion(R region) {
        OpenDefinitionsDocument doc = region.getDocument();
        SortedSet<R> docRegions = this._regions.get(doc);
        if (docRegions == null) {
            return;
        }
        boolean wasRemoved = docRegions.remove(region);
        if (docRegions.isEmpty()) {
            this._documents.remove(doc);
            this._regions.remove(doc);
        }
        if (wasRemoved) {
            this._notifyRegionRemoved(region);
        }
    }

    @Override
    public void removeRegions(Iterable<? extends R> regions) {
        for (OrderedDocumentRegion r : regions) {
            this.removeRegion((R)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyRegionRemoved(R region) {
        this._lock.startRead();
        try {
            for (RegionManagerListener l : this._listeners) {
                l.regionRemoved(region);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void removeRegions(OpenDefinitionsDocument doc) {
        assert (doc != null);
        boolean found = this._documents.remove(doc);
        if (found) {
            SortedSet<R> regions = this._regions.get(doc);
            while (!regions.isEmpty()) {
                OrderedDocumentRegion r = (OrderedDocumentRegion)regions.first();
                regions.remove(r);
                this._notifyRegionRemoved(r);
            }
        }
    }

    @Override
    public SortedSet<R> getRegions(OpenDefinitionsDocument odd) {
        return this._regions.get(odd);
    }

    @Override
    public int getRegionCount() {
        int regions = 0;
        for (OpenDefinitionsDocument odd : this._documents) {
            regions += this._regions.get(odd).size();
        }
        return regions;
    }

    @Override
    public ArrayList<R> getRegions() {
        ArrayList regions = new ArrayList();
        for (OpenDefinitionsDocument odd : this._documents) {
            regions.addAll(this._regions.get(odd));
        }
        return regions;
    }

    public ArrayList<FileRegion> getFileRegions() {
        ArrayList<FileRegion> regions = new ArrayList<FileRegion>();
        for (OpenDefinitionsDocument odd : this._documents) {
            File f = odd.getRawFile();
            for (OrderedDocumentRegion r : this._regions.get(odd)) {
                regions.add(new DummyDocumentRegion(f, r.getStartOffset(), r.getEndOffset()));
            }
        }
        return regions;
    }

    @Override
    public boolean contains(R region) {
        for (OpenDefinitionsDocument doc : this._documents) {
            if (!this._regions.get(doc).contains(region)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearRegions() {
        for (OrderedDocumentRegion r : this.getRegions()) {
            this.removeRegion((R)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRegion(R region, Lambda<R, Object> cmd) {
        cmd.value(region);
        this._lock.startRead();
        try {
            for (RegionManagerListener l : this._listeners) {
                l.regionChanged(region);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void updateLines(R firstRegion, R lastRegion) {
        OrderedDocumentRegion region;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        SortedSet<R> tail = this.getTailSet(firstRegion);
        if (tail.size() == 0) {
            return;
        }
        ArrayList<OrderedDocumentRegion> toBeRemoved = new ArrayList<OrderedDocumentRegion>();
        Iterator i$ = tail.iterator();
        while (i$.hasNext() && (region = (OrderedDocumentRegion)i$.next()).compareTo(lastRegion) <= 0) {
            region.update();
            if (region.getStartOffset() != region.getEndOffset()) continue;
            toBeRemoved.add(region);
        }
        this.removeRegions(toBeRemoved);
    }
}

