/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import edu.rice.cs.cunit.util.ILambda;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IPredicate<P>
extends ILambda<Boolean, P> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Nary<P>
    extends ILambda.Nary<Boolean, P> {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Xor
        implements Nary<Boolean> {
            public static final Xor ONLY = new Xor();

            private Xor() {
            }

            public Boolean apply(Boolean ... param) {
                int trueCount = 0;
                for (Boolean b : param) {
                    if (!b.booleanValue()) continue;
                    ++trueCount;
                }
                return trueCount == 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Or
        implements Nary<Boolean> {
            public static final Or ONLY = new Or();

            private Or() {
            }

            public Boolean apply(Boolean ... param) {
                boolean accum = false;
                for (Boolean b : param) {
                    accum |= b.booleanValue();
                }
                return accum;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class And
        implements Nary<Boolean> {
            public static final And ONLY = new And();

            private And() {
            }

            public Boolean apply(Boolean ... param) {
                boolean accum = true;
                for (Boolean b : param) {
                    accum &= b.booleanValue();
                }
                return accum;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class False
        implements Nary<Boolean> {
            public static final False ONLY = new False();

            private False() {
            }

            public Boolean apply(Boolean ... param) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class True
        implements Nary<Boolean> {
            public static final True ONLY = new True();

            private True() {
            }

            public Boolean apply(Boolean ... param) {
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BindK<P>
        extends ILambda.Nary.BindK<Boolean, P> {
            public BindK(ILambda.Nary<Boolean, P> decoree, int[] indices, P ... constants) {
                super(decoree, indices, constants);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind<P>
        extends ILambda.Nary.Bind<Boolean, P> {
            public Bind(ILambda.Nary<Boolean, P> decoree, int index, P constant) {
                super(decoree, index, constant);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Ternary<P, Q, S>
    extends ILambda.Ternary<Boolean, P, Q, S> {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Between<T extends Comparable<T>>
        implements Ternary<T, T, T> {
            @Override
            public Boolean apply(T param1, T param2, T param3) {
                return param1.compareTo(param2) >= 0 && param1.compareTo(param3) <= 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Xor
        implements Ternary<Boolean, Boolean, Boolean> {
            public static final Xor ONLY = new Xor();

            private Xor() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2, Boolean param3) {
                return param1 ^ param2 && param3 == false || param1 ^ param3 && param2 == false || param2 ^ param3 && param1 == false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Or
        implements Ternary<Boolean, Boolean, Boolean> {
            public static final Or ONLY = new Or();

            private Or() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2, Boolean param3) {
                return param1 != false || param2 != false || param3 != false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class And
        implements Ternary<Boolean, Boolean, Boolean> {
            public static final And ONLY = new And();

            private And() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2, Boolean param3) {
                return param1 != false && param2 != false && param3 != false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class False
        implements Ternary<Boolean, Boolean, Boolean> {
            public static final False ONLY = new False();

            private False() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2, Boolean param3) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class True
        implements Ternary<Boolean, Boolean, Boolean> {
            public static final True ONLY = new True();

            private True() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2, Boolean param3) {
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd3rd<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind2nd3rd<Boolean, P, Q, S> {
            public Bind2nd3rd(ILambda.Ternary<Boolean, P, Q, S> decoree, Q constant2, S constant3) {
                super(decoree, constant2, constant3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st3rd<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind1st3rd<Boolean, P, Q, S> {
            public Bind1st3rd(ILambda.Ternary<Boolean, P, Q, S> decoree, P constant1, S constant3) {
                super(decoree, constant1, constant3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st2nd<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind1st2nd<Boolean, P, Q, S> {
            public Bind1st2nd(ILambda.Ternary<Boolean, P, Q, S> decoree, P constant1, Q constant2) {
                super(decoree, constant1, constant2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind3rd<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind3rd<Boolean, P, Q, S> {
            public Bind3rd(ILambda.Ternary<Boolean, P, Q, S> decoree, S constant) {
                super(decoree, constant);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind2nd<Boolean, P, Q, S> {
            public Bind2nd(ILambda.Ternary<Boolean, P, Q, S> decoree, Q constant) {
                super(decoree, constant);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st<Boolean, P, Q, S>
        extends ILambda.Ternary.Bind1st<Boolean, P, Q, S> {
            public Bind1st(ILambda.Ternary<Boolean, P, Q, S> decoree, P constant) {
                super(decoree, constant);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Binary<P, Q>
    extends ILambda.Binary<Boolean, P, Q> {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Equals
        implements Binary<Object, Object> {
            public static final Equals ONLY = new Equals();

            private Equals() {
            }

            @Override
            public Boolean apply(Object param1, Object param2) {
                return param1.equals(param2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GreaterEq<T extends Comparable<T>>
        implements Binary<T, T> {
            @Override
            public Boolean apply(T param1, T param2) {
                return param1.compareTo(param2) >= 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class LessEq<T extends Comparable<T>>
        implements Binary<T, T> {
            @Override
            public Boolean apply(T param1, T param2) {
                return param1.compareTo(param2) <= 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Greater<T extends Comparable<T>>
        implements Binary<T, T> {
            @Override
            public Boolean apply(T param1, T param2) {
                return param1.compareTo(param2) > 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Less<T extends Comparable<T>>
        implements Binary<T, T> {
            @Override
            public Boolean apply(T param1, T param2) {
                return param1.compareTo(param2) < 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Xor
        implements Binary<Boolean, Boolean> {
            public static final Xor ONLY = new Xor();

            private Xor() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2) {
                return param1 ^ param2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Or
        implements Binary<Boolean, Boolean> {
            public static final Or ONLY = new Or();

            private Or() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2) {
                return param1 != false || param2 != false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class And
        implements Binary<Boolean, Boolean> {
            public static final And ONLY = new And();

            private And() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2) {
                return param1 != false && param2 != false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class False
        implements Binary<Boolean, Boolean> {
            public static final False ONLY = new False();

            private False() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class True
        implements Binary<Boolean, Boolean> {
            public static final True ONLY = new True();

            private True() {
            }

            @Override
            public Boolean apply(Boolean param1, Boolean param2) {
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd<Boolean, P, Q>
        extends ILambda.Binary.Bind2nd<Boolean, P, Q> {
            public Bind2nd(ILambda.Binary<Boolean, P, Q> decoree, Q constant) {
                super(decoree, constant);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st<Boolean, P, Q>
        extends ILambda.Binary.Bind1st<Boolean, P, Q> {
            public Bind1st(ILambda.Binary<Boolean, P, Q> decoree, P constant) {
                super(decoree, constant);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class False
    implements IPredicate<Boolean> {
        public static final False ONLY = new False();

        private False() {
        }

        @Override
        public Boolean apply(Boolean param) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class True
    implements IPredicate<Boolean> {
        public static final True ONLY = new True();

        private True() {
        }

        @Override
        public Boolean apply(Boolean param) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Not
    implements IPredicate<Boolean> {
        public static final Not ONLY = new Not();

        private Not() {
        }

        @Override
        public Boolean apply(Boolean param) {
            return param == false;
        }
    }
}

