/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOps {
    public static File makeRelativeTo(File f, File b) throws IOException {
        int i;
        File[] roots;
        File base = b.getCanonicalFile();
        File abs = f.getCanonicalFile();
        if (!base.isDirectory()) {
            base = base.getParentFile();
        }
        for (File r : roots = File.listRoots()) {
            if (!abs.getAbsolutePath().startsWith(r.toString())) continue;
            if (base.getAbsolutePath().startsWith(r.toString())) break;
            return abs;
        }
        String last = "";
        if (!abs.isDirectory()) {
            String tmp = abs.getPath();
            last = tmp.substring(tmp.lastIndexOf(File.separator) + 1);
            abs = abs.getParentFile();
        }
        String[] basParts = FileOps.splitFile(base);
        String[] absParts = FileOps.splitFile(abs);
        StringBuffer result = new StringBuffer();
        int diffIndex = -1;
        boolean different = false;
        for (i = 0; i < basParts.length; ++i) {
            if (!(different || i < absParts.length && basParts[i].equals(absParts[i]))) {
                different = true;
                diffIndex = i;
            }
            if (!different) continue;
            result.append("..").append(File.separator);
        }
        if (diffIndex < 0) {
            diffIndex = basParts.length;
        }
        for (i = diffIndex; i < absParts.length; ++i) {
            result.append(absParts[i]).append(File.separator);
        }
        result.append(last);
        return new File(result.toString());
    }

    public static boolean isContainedIn(File f, File dir) {
        try {
            return FileOps.isContainedInCanonical(f.getCanonicalFile(), dir.getCanonicalFile());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean isContainedInCanonical(File f, File dir) {
        if (dir == null || f == null) {
            return false;
        }
        if (f.equals(dir)) {
            return true;
        }
        File parent = f.getParentFile();
        return FileOps.isContainedInCanonical(parent, dir);
    }

    public static String[] splitFile(File fileToSplit) {
        String path = fileToSplit.getPath();
        ArrayList<String> list = new ArrayList<String>();
        while (!path.equals("")) {
            int idx = path.indexOf(File.separator);
            if (idx < 0) {
                list.add(path);
                path = "";
                continue;
            }
            list.add(path.substring(0, idx));
            path = path.substring(idx + 1);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitPaths(String pathString, char pathSeparator) {
        return FileOps.splitPaths(pathString, pathSeparator, true);
    }

    public static String[] splitPaths(String pathString, char pathSeparator, boolean winDriveLetters) {
        boolean checkDriveLetters = pathSeparator == ':' && winDriveLetters;
        ArrayList<String> list = new ArrayList<String>();
        int idx = 0;
        while ((idx = pathString.indexOf(pathSeparator, idx)) >= 0) {
            String path = pathString.substring(0, idx);
            if (checkDriveLetters && path.length() == 1 && pathString.charAt(idx + 1) == File.separatorChar) {
                ++idx;
                continue;
            }
            list.add(path);
            pathString = pathString.substring(idx + 1);
            idx = 0;
        }
        list.add(pathString);
        return list.toArray(new String[list.size()]);
    }

    public static void exit(final int status) {
        Thread terminator = new Thread(new Runnable(){

            public void run() {
                System.exit(status);
            }
        }, "Attempt System.exit");
        terminator.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().halt(status);
    }

    public static File createTempDirectory(String name) throws IOException {
        return FileOps.createTempDirectory(name, null);
    }

    public static File createTempDirectory(String name, File parent) throws IOException {
        File file = File.createTempFile(name, "", parent);
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        return file;
    }

    public static boolean deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            boolean res = dir.delete();
            if (!res) {
                System.err.println("Could not delete " + dir);
            }
            return res;
        }
        boolean ret = true;
        File[] childFiles = dir.listFiles();
        if (childFiles != null) {
            for (File f : childFiles) {
                ret = ret && FileOps.deleteDirectory(f);
            }
        }
        ret = ret && dir.delete();
        return ret;
    }

    public static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                FileOps.deleteDirectoryOnExit(f);
            }
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        if (src.isFile()) {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        } else if (src.isDirectory()) {
            dst.mkdirs();
            for (File f : src.listFiles()) {
                FileOps.copyFile(f, new File(dst, f.getName()));
            }
        }
    }

    public static Set<File> enumFiles(File src) throws IOException {
        HashSet<File> l = new HashSet<File>();
        if (src.isFile()) {
            l.add(src);
        } else if (src.isDirectory()) {
            for (File f : src.listFiles()) {
                Set<File> recur = FileOps.enumFiles(f);
                l.addAll(recur);
            }
        }
        return l;
    }

    public static String convertToAbsolutePathEntries(String path) {
        String pathSep = System.getProperty("path.separator");
        path = path + pathSep + "x";
        String[] pathEntries = path.split(pathSep);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pathEntries.length - 1; ++i) {
            File f = new File(pathEntries[i]);
            sb.append(f.getAbsolutePath());
            sb.append(pathSep);
        }
        String reconstructedPath = sb.toString();
        if (reconstructedPath.length() != 0) {
            reconstructedPath = reconstructedPath.substring(0, reconstructedPath.length() - 1);
        }
        return reconstructedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long unpackJar(File inJar, File outDir) throws IOException {
        JarFile jf = null;
        long count = 0L;
        try {
            jf = new JarFile(inJar);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.isDirectory()) continue;
                InputStream is = null;
                try {
                    is = jf.getInputStream(e);
                    FileOutputStream fos = null;
                    try {
                        int bytesRead;
                        String name = e.getName().replace('/', File.separatorChar);
                        int pos = name.lastIndexOf(File.separatorChar);
                        if (pos >= 0) {
                            String dir = name.substring(0, pos);
                            new File(outDir, dir).mkdirs();
                        }
                        fos = new FileOutputStream(new File(outDir, name));
                        byte[] buffer = new byte[1024];
                        while (-1 != (bytesRead = is.read(buffer))) {
                            fos.write(buffer, 0, bytesRead);
                        }
                        ++count;
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                        fos = null;
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                    is = null;
                }
            }
        }
        finally {
            if (jf != null) {
                jf.close();
                jf = null;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long packJar(File inDir, File outJar) throws IOException {
        FileOutputStream fos = new FileOutputStream(outJar);
        JarOutputStream jos = new JarOutputStream(fos);
        long count = 0L;
        Set<File> files = FileOps.enumFiles(inDir);
        for (File f : files) {
            File fRel = FileOps.makeRelativeTo(f, inDir);
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream(f);
                jos.putNextEntry(new ZipEntry(fRel.getPath().replace(File.separatorChar, '/')));
                byte[] buffer = new byte[1024];
                while (-1 != (bytesRead = fis.read(buffer))) {
                    jos.write(buffer, 0, bytesRead);
                }
                ++count;
            }
            finally {
                if (fis == null) continue;
                fis.close();
                fis = null;
            }
        }
        jos.close();
        fos.close();
        return count;
    }

    public static class FileOpsTest
    extends TestCase {
        public void testSplitPaths() {
            String fs = File.separator;
            String[] p = FileOps.splitPaths("C:" + fs + "foo:C:" + fs + "bar::C:" + fs + "foo" + fs + "bar:", ':', true);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:" + fs + "foo", p[0]);
            FileOpsTest.assertEquals("C:" + fs + "bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:" + fs + "foo" + fs + "bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("C:foo:C:bar::C:foo" + fs + "bar:", ':', true);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("foo" + fs + "bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("", ':', true);
            FileOpsTest.assertEquals(1, p.length);
            FileOpsTest.assertEquals("", p[0]);
            p = FileOps.splitPaths("C:" + fs + "foo;C:" + fs + "bar;;C:" + fs + "foo" + fs + "bar;", ';', true);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:" + fs + "foo", p[0]);
            FileOpsTest.assertEquals("C:" + fs + "bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:" + fs + "foo" + fs + "bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("C:foo;C:bar;;C:foo" + fs + "bar;", ';', true);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:foo", p[0]);
            FileOpsTest.assertEquals("C:bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:foo" + fs + "bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("", ':', true);
            FileOpsTest.assertEquals(1, p.length);
            FileOpsTest.assertEquals("", p[0]);
            p = FileOps.splitPaths("C;foo;C;bar;;C;foo/bar;", ';', true);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("foo/bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("C:\\foo:C:\\bar::C:\\foo\\bar:", ':', false);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("\\foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("\\bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("\\foo\\bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("C:foo:C:bar::C:foo\\bar:", ':', false);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("foo\\bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("", ':', true);
            FileOpsTest.assertEquals(1, p.length);
            FileOpsTest.assertEquals("", p[0]);
            p = FileOps.splitPaths("C:/foo:C:/bar::C:/foo/bar:", ':', false);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("/foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("/bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("/foo/bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("C:foo:C:bar::C:foo/bar:", ':', false);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("foo/bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
            p = FileOps.splitPaths("C:\\foo;C:\\bar;;C:\\foo\\bar;", ';', false);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:\\foo", p[0]);
            FileOpsTest.assertEquals("C:\\bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:\\foo\\bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("C:foo;C:bar;;C:foo\\bar;", ';', false);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:foo", p[0]);
            FileOpsTest.assertEquals("C:bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:foo\\bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("", ':', true);
            FileOpsTest.assertEquals(1, p.length);
            FileOpsTest.assertEquals("", p[0]);
            p = FileOps.splitPaths("C:/foo;C:/bar;;C:/foo/bar;", ';', false);
            FileOpsTest.assertEquals(5, p.length);
            FileOpsTest.assertEquals("C:/foo", p[0]);
            FileOpsTest.assertEquals("C:/bar", p[1]);
            FileOpsTest.assertEquals("", p[2]);
            FileOpsTest.assertEquals("C:/foo/bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            p = FileOps.splitPaths("C;foo;C;bar;;C;foo/bar;", ';', false);
            FileOpsTest.assertEquals(8, p.length);
            FileOpsTest.assertEquals("C", p[0]);
            FileOpsTest.assertEquals("foo", p[1]);
            FileOpsTest.assertEquals("C", p[2]);
            FileOpsTest.assertEquals("bar", p[3]);
            FileOpsTest.assertEquals("", p[4]);
            FileOpsTest.assertEquals("C", p[5]);
            FileOpsTest.assertEquals("foo/bar", p[6]);
            FileOpsTest.assertEquals("", p[7]);
        }
    }
}

