/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.record.graph;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;

public class StackFrameInfo {
    long _threadId;
    Long _thisId;
    String _sourcePath;
    int _lineNumber;
    long _codeIndex;

    public StackFrameInfo(long threadId, Long thisId, String sourcePath, int lineNumber, long codeIndex) {
        this._threadId = threadId;
        this._thisId = thisId;
        this._sourcePath = sourcePath;
        this._lineNumber = lineNumber;
        this._codeIndex = codeIndex;
    }

    public StackFrameInfo(StackFrame sf) {
        this._threadId = sf.thread().uniqueID();
        ObjectReference objectReference = sf.thisObject();
        this._thisId = objectReference != null ? Long.valueOf(objectReference.uniqueID()) : null;
        this._lineNumber = sf.location().lineNumber();
        this._codeIndex = sf.location().codeIndex();
        try {
            this._sourcePath = sf.location().sourcePath();
        }
        catch (AbsentInformationException e) {
            this._sourcePath = "?";
        }
    }

    public long getThreadId() {
        return this._threadId;
    }

    public Long getThisId() {
        return this._thisId;
    }

    public String getSourcePath() {
        return this._sourcePath;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public long getCodeIndex() {
        return this._codeIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._sourcePath);
        sb.append(":");
        sb.append(this._lineNumber);
        sb.append(" (thread id=");
        sb.append(this._threadId);
        sb.append(", this id=");
        if (this._thisId != null) {
            sb.append(this._thisId);
        } else {
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }
}

