/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AClassNameTypePoolInfo
extends APoolInfo {
    protected ClassPoolInfo _classInfo;
    protected NameAndTypePoolInfo _nameAndType;
    protected int _classInfoIndex;
    protected int _nameAndTypeIndex;

    public AClassNameTypePoolInfo(int type, ClassPoolInfo clas, NameAndTypePoolInfo nameAndType, ConstantPool cp) {
        super(type, cp);
        this._classInfo = clas;
        this._nameAndType = nameAndType;
        this.reindex();
    }

    public AClassNameTypePoolInfo(int type, DataInputStream dis, ConstantPool cp) throws IOException {
        super(type, cp);
        this._classInfoIndex = dis.readShort();
        this._nameAndTypeIndex = dis.readShort();
    }

    public ClassPoolInfo getClassInfo() {
        return this._classInfo;
    }

    public void setClassInfo(ClassPoolInfo classInfo) {
        this._classInfo = classInfo;
    }

    public NameAndTypePoolInfo getNameAndType() {
        return this._nameAndType;
    }

    public void setNameAndType(NameAndTypePoolInfo nameAndType) {
        this._nameAndType = nameAndType;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.reindex();
        dos.writeByte(this._type);
        dos.writeShort(this._classInfoIndex);
        dos.writeShort(this._nameAndTypeIndex);
    }

    public void resolve() {
        this._classInfo = ((APoolInfo)this._constantPool.get(this._classInfoIndex)).execute(CheckClassVisitor.singleton(), null);
        this._nameAndType = ((APoolInfo)this._constantPool.get(this._nameAndTypeIndex)).execute(new ADefaultPoolInfoVisitor<NameAndTypePoolInfo, Object>(){

            @Override
            public NameAndTypePoolInfo defaultCase(APoolInfo host, Object o) {
                throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be NameAndTypePoolInfo");
            }

            @Override
            public NameAndTypePoolInfo nameAndTypeCase(NameAndTypePoolInfo host, Object o) {
                return host;
            }
        }, null);
    }

    public void reindex() {
        this._classInfoIndex = this._constantPool.indexOf(this._classInfo);
        this._nameAndTypeIndex = this._constantPool.indexOf(this._nameAndType);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this._classInfo.getName().toString());
        s.append('.');
        s.append(this._nameAndType.getName().toString());
        s.append(this._nameAndType.getDescriptor().toString());
        return s.toString();
    }

    public int hashCode() {
        return this._classInfoIndex + 6101 * this._nameAndTypeIndex;
    }
}

