/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTypeTableAttributeInfo
extends AAttributeInfo {
    public LocalVariableTypeTableAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public int getLocalVariableTypeCount() {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public LocalVariableTypeRecord[] getLocalVariableTypes() throws ClassFormatError {
        int count = this.getLocalVariableTypeCount();
        LocalVariableTypeRecord[] lvr = new LocalVariableTypeRecord[count];
        for (int i = 0; i < count; ++i) {
            lvr[i] = new LocalVariableTypeRecord((short)(0xFFFF & Types.ushortFromBytes(this._data, 2 + 10 * i)), (short)(0xFFFF & Types.ushortFromBytes(this._data, 4 + 10 * i)), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 6 + 10 * i))).execute(CheckUTFVisitor.singleton(), null), ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 8 + 10 * i))).execute(CheckUTFVisitor.singleton(), null), (short)(0xFFFF & Types.ushortFromBytes(this._data, 10 + 10 * i)));
        }
        return lvr;
    }

    public void setLocalVariableTypes(LocalVariableTypeRecord[] lnr) {
        byte[] newData = new byte[2 + 10 * lnr.length];
        Types.bytesFromShort((short)lnr.length, newData, 0);
        for (int i = 0; i < lnr.length; ++i) {
            Types.bytesFromShort((short)(0xFFFF & lnr[i].startPC), newData, 2 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & lnr[i].length), newData, 4 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & this._constantPool.indexOf(lnr[i].name)), newData, 6 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & this._constantPool.indexOf(lnr[i].signature)), newData, 8 + 10 * i);
            Types.bytesFromShort((short)(0xFFFF & lnr[i].index), newData, 10 + 10 * i);
        }
        this.setData(newData);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.localVariableTypeTableCase(this, param);
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getLocalVariableTypeCount() + " local variable types{ ");
        boolean first = true;
        for (LocalVariableTypeRecord lvrs : this.getLocalVariableTypes()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append("(PC=" + lvrs.startPC + ".." + (lvrs.startPC + lvrs.length) + ", " + lvrs.name.toString() + ", signature = " + lvrs.signature.toString() + ", index " + lvrs.index + ")");
        }
        x.append(" } >");
        return x.toString();
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
        LocalVariableTypeRecord[] lvrs;
        for (LocalVariableTypeRecord l : lvrs = this.getLocalVariableTypes()) {
            if (l.startPC >= startPC) {
                l.startPC += deltaPC;
            }
            if (l.startPC > startPC || l.startPC + l.length < startPC) continue;
            l.length += deltaPC;
        }
        this.setLocalVariableTypes(lvrs);
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
        LocalVariableTypeRecord[] lvrs;
        for (LocalVariableTypeRecord l : lvrs = this.getLocalVariableTypes()) {
            int oldEndLineNo;
            int oldLineNo = oldLnt.getLineNumber(l.startPC);
            l.startPC = newLnt.getPC(oldLineNo += oldLineNo > index ? deltaIndex : 0);
            l.length = newLnt.getPC(oldEndLineNo += (oldEndLineNo = oldLnt.getLineNumber(l.startPC + l.length)) > index ? deltaIndex : 0) - l.startPC;
        }
        this.setLocalVariableTypes(lvrs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "LocalVariableTypeTable";
    }

    public static class LocalVariableTypeRecord {
        public int startPC;
        public int length;
        public AUTFPoolInfo name;
        public AUTFPoolInfo signature;
        public int index;

        public LocalVariableTypeRecord(int startPC, int length, AUTFPoolInfo name, AUTFPoolInfo signature, int index) {
            this.startPC = startPC;
            this.length = length;
            this.name = name;
            this.signature = signature;
            this.index = index;
        }
    }
}

