/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit;

import edu.rice.cs.cunit.FileInstrumentor;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.util.BooleanComponentProperty;
import edu.rice.cs.cunit.util.ButtonGroupComponentProperty;
import edu.rice.cs.cunit.util.Debug;
import edu.rice.cs.cunit.util.FileOps;
import edu.rice.cs.cunit.util.GUIUtils;
import edu.rice.cs.cunit.util.GetTextButtonGroup;
import edu.rice.cs.cunit.util.IPredicate;
import edu.rice.cs.cunit.util.QuotedStringTokenizer;
import edu.rice.cs.cunit.util.StringOps;
import edu.rice.cs.cunit.util.TextAreaMessageDialog;
import edu.rice.cs.cunit.util.TextComponentProperty;
import edu.rice.cs.cunit.util.XMLConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Node;

public class FileInstrumentorLauncher {
    public static final String PROJECT_ROOT_PROPERTY = "project.root";
    public static final String SOURCE_JAR_PROPERTY = "source.jar";
    public static final String CUNIT_JAR_PROPERTY = "cunit.jar";
    public static final String DEST_JAR_PROPERTY = "dest.jar";
    public static final String INSTRUMENTOR_NAME_PROPERTY = "instrumentor.name";
    public static final String SYSINSTRUMENTOR_NAME_PROPERTY = "sysinstrumentor.name";
    public static final String OUTPUT_FILE_PROPERTY = "output.file";
    public static final String FI_XML_PREFIX = "concutest/instrument";
    public static final String DEFAULT_SOURCE_JAR_PROPERTY = "default.source.jar";
    public static final String INPUT_FILES_PROPERTY = "input.files";
    public static final String CUNIT_FILTER_PROPERTY = "cunit.filter";

    public static void main(String[] args) {
        new FileInstrumentorLauncher().run(args);
    }

    public void run(String[] args) {
        for (String a : args) {
            if (!a.equalsIgnoreCase("-h") && !a.equalsIgnoreCase("--help")) continue;
            FileInstrumentorLauncher.printHelp();
            System.exit(0);
        }
        if (args.length > 1) {
            new FileInstrumentorLauncherView(args[0], args[1].equalsIgnoreCase("run"));
        } else if (args.length > 0) {
            new FileInstrumentorLauncherView(args[0], false);
        } else {
            new FileInstrumentorLauncherView(null, false);
        }
    }

    public static void printHelp() {
        System.out.println("Syntax:    java " + FileInstrumentorLauncher.class.getName());
        System.out.println("                [<xmlfile> [run]] [-h|--help]");
        System.out.println("Arguments: <xmlfile>     XML configuration file to open");
        System.out.println("           run           Immediately run the instrumentation (console mode)");
        System.out.println("           -h or --help  Show this help text");
        System.out.println("Example:   Open the file instrumentor with blank fields");
        System.out.println("           java " + FileInstrumentorLauncher.class.getName());
        System.out.println("Example:   Open the file instrumentor with data from the config.xml file");
        System.out.println("           java " + FileInstrumentorLauncher.class.getName() + " config.xml");
        System.out.println("Example:   Immediately run the instrumentation described in config.xml");
        System.out.println("           java " + FileInstrumentorLauncher.class.getName() + " config.xml run");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileInstrumentorLauncherView {
        private JFrame _frame;
        private File _projectRoot;
        private TextComponentProperty _projectRootName;
        private BooleanComponentProperty _instrumentRt;
        private TextComponentProperty _sourceRtJarName;
        private JButton _sourceRtJarBtn;
        private TextComponentProperty _cunitRtJarName;
        private List<String> _cunitFilters = new ArrayList<String>();
        private JButton _cunitRtJarBtn;
        private TextComponentProperty _destRtJarName;
        private JButton _destRtJarBtn;
        private TextComponentProperty _instrumentorName;
        private TextComponentProperty _sysInstrumentorName;
        private BooleanComponentProperty _createBackups;
        private TextComponentProperty _argsField;
        private ButtonGroupComponentProperty _outputChoice;
        private JButton _outputBtn;
        private TextComponentProperty _outputName;
        private JTable _fileTable;
        private DefaultTableModel _fileTableModel;
        private JTextField _classNameField;
        private JTextField _cmdLine;
        private JButton _runBtn;
        private JFileChooser _fcTxt;
        private JFileChooser _fcConfig;
        private JFileChooser _fcJar;
        private JFileChooser _fcClass;
        private JFileChooser _fcInput;
        JMenuBar _menuBar;
        JMenu _fileMenu;
        JMenuItem[] _fileMenuItems;
        JMenu _helpMenu;
        JMenuItem[] _helpMenuItems;
        JScrollPane _scrollPane;
        private boolean _initDone;
        private boolean _headless;
        private final IPredicate.Binary<String, File> _projectRootPredicate = new IPredicate.Binary<String, File>(){

            @Override
            public Boolean apply(String s, File f) {
                return f.exists() && f.isDirectory();
            }
        };
        private final IPredicate.Binary<String, File> _sourceRtJarPredicate = new IPredicate.Binary<String, File>(){

            @Override
            public Boolean apply(String s, File f) {
                String[] paths;
                if (s.length() == 0) {
                    s = FileInstrumentor.getDefaultSourceRtJarName();
                }
                if (!((Boolean)FileInstrumentorLauncherView.this._instrumentRt.get()).booleanValue()) {
                    return true;
                }
                for (String p : paths = FileOps.splitPaths(s, File.pathSeparatorChar)) {
                    File fp = new File(p);
                    if (fp.exists() && fp.isFile() && fp.canRead()) continue;
                    return false;
                }
                return true;
            }
        };
        private final IPredicate.Binary<String, File> _cunitRtJarPredicate = new IPredicate.Binary<String, File>(){

            @Override
            public Boolean apply(String s, File f) {
                if (s.length() == 0) {
                    f = new File(FileInstrumentor.getDefaultCunitRtJarName());
                }
                return (Boolean)FileInstrumentorLauncherView.this._instrumentRt.get() == false || f.exists() && f.isFile() && f.canRead();
            }
        };
        private final IPredicate.Binary<String, File> _destRtJarPredicate = new IPredicate.Binary<String, File>(){

            @Override
            public Boolean apply(String s, File f) {
                if (s.length() == 0) {
                    f = new File(FileInstrumentor.getDefaultDestRtJarName());
                }
                return (Boolean)FileInstrumentorLauncherView.this._instrumentRt.get() == false || !f.exists() || f.isFile() && f.canWrite();
            }
        };
        private final IPredicate.Binary<String, File> _outputFilePredicate = new IPredicate.Binary<String, File>(){

            @Override
            public Boolean apply(String s, File f) {
                return !((String)FileInstrumentorLauncherView.this._outputChoice.get()).equalsIgnoreCase("file") || s.length() > 0 && (!f.exists() || f.isFile() && f.canWrite());
            }
        };
        private final IPredicate.Binary<String, File> _instrumentorNamePredicate = new IPredicate.Binary<String, File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean apply(String s, File f) {
                if (s.length() == 0) {
                    s = FileInstrumentor.getDefaultInstrumentorName();
                }
                if (s.indexOf(46) < 0) {
                    s = "edu.rice.cs.cunit.instrumentors." + s;
                }
                Debug.out.println("fi.instrumentor.name", "Searching for class " + s);
                ArrayList<String> classPath = new ArrayList<String>();
                for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
                    Debug.out.println("fi.instrumentor.name", "\t" + path);
                    classPath.add(path);
                }
                ClassFileTools.ClassLocation loc = null;
                try {
                    loc = ClassFileTools.findClassFile(s, classPath);
                    if (loc == null) {
                        Debug.out.println("fi.instrumentor.name", "\tNOT FOUND");
                    } else {
                        Debug.out.println("fi.instrumentor.name", "\tFOUND: " + loc.getClassFile());
                    }
                    Boolean bl = loc != null;
                    return bl;
                }
                finally {
                    try {
                        if (loc != null) {
                            loc.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        };
        private final IPredicate.Binary<String, File> _sysInstrumentorNamePredicate = new IPredicate.Binary<String, File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean apply(String s, File f) {
                if (s.length() == 0) {
                    s = FileInstrumentor.getDefaultSystemInstrumentorName();
                }
                Debug.out.setLogTarget("fi.instrumentor.name", Debug.LogTarget.MAIN);
                if (s.indexOf(46) < 0) {
                    s = "edu.rice.cs.cunit.instrumentors." + s;
                }
                Debug.out.println("fi.instrumentor.name", "Searching for class " + s);
                ArrayList<String> classPath = new ArrayList<String>();
                for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
                    Debug.out.println("fi.instrumentor.name", "\t" + path);
                    classPath.add(path);
                }
                ClassFileTools.ClassLocation loc = null;
                try {
                    loc = ClassFileTools.findClassFile(s, classPath);
                    if (loc == null) {
                        Debug.out.println("fi.instrumentor.name", "\tNOT FOUND");
                    } else {
                        Debug.out.println("fi.instrumentor.name", "\tFOUND: " + loc.getClassFile());
                    }
                    Boolean bl = loc != null;
                    return bl;
                }
                finally {
                    try {
                        if (loc != null) {
                            loc.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        };

        public FileInstrumentorLauncherView(String configName, boolean run) {
            this._headless = run;
            this.initGUI();
            if (configName != null) {
                this.openConfig(new File(configName));
                if (run) {
                    this.executeFileInstrumentor(true);
                    Runtime.getRuntime().halt(0);
                }
            }
            if (!this._headless) {
                this.updatePaths();
                this._frame.setVisible(true);
            }
        }

        private void initGUI() {
            this._projectRootName = new TextComponentProperty("");
            this._projectRoot = new File(".");
            this._projectRootName.set(this._projectRoot.getAbsolutePath());
            this._instrumentRt = new BooleanComponentProperty(false);
            this._sourceRtJarName = new TextComponentProperty("");
            this._cunitRtJarName = new TextComponentProperty("");
            this._destRtJarName = new TextComponentProperty("");
            this._instrumentorName = new TextComponentProperty("");
            this._sysInstrumentorName = new TextComponentProperty("");
            this._createBackups = new BooleanComponentProperty(true);
            this._argsField = new TextComponentProperty("");
            this._outputChoice = new ButtonGroupComponentProperty("console");
            this._outputName = new TextComponentProperty("");
            this._fileTableModel = new DefaultTableModel(0, 1){

                @Override
                public String getColumnName(int column) {
                    switch (column) {
                        case 0: {
                            return "Path";
                        }
                    }
                    return super.getColumnName(column);
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return String.class;
                        }
                    }
                    return super.getColumnClass(columnIndex);
                }
            };
            if (!this._headless) {
                this._projectRootName.setComponent(new JTextField());
                this._instrumentRt.setComponent(new JCheckBox());
                this._sourceRtJarName.setComponent(new JTextField());
                this._cunitRtJarName.setComponent(new JTextField());
                this._destRtJarName.setComponent(new JTextField());
                this._instrumentorName.setComponent(new JTextField());
                this._sysInstrumentorName.setComponent(new JTextField());
                this._createBackups.setComponent(new JCheckBox());
                this._argsField.setComponent(new JTextField());
                JRadioButton conOutBtn = new JRadioButton("console");
                JRadioButton fileOutBtn = new JRadioButton("file");
                JRadioButton quietOutBtn = new JRadioButton("quiet");
                GetTextButtonGroup outputGroup = new GetTextButtonGroup();
                outputGroup.add(conOutBtn);
                outputGroup.add(fileOutBtn);
                outputGroup.add(quietOutBtn);
                this._outputChoice.setComponent(outputGroup);
                this._outputName.setComponent(new JTextField());
                this._frame = new JFrame("FileInstrumentorLauncher");
                this._frame.addWindowListener(new WindowListener(){

                    public void windowOpened(WindowEvent e) {
                    }

                    public void windowClosing(WindowEvent e) {
                        FileInstrumentorLauncherView.this._frame.setVisible(false);
                        System.exit(0);
                    }

                    public void windowClosed(WindowEvent e) {
                    }

                    public void windowIconified(WindowEvent e) {
                    }

                    public void windowDeiconified(WindowEvent e) {
                    }

                    public void windowActivated(WindowEvent e) {
                    }

                    public void windowDeactivated(WindowEvent e) {
                    }
                });
                try {
                    this._fcJar = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcJar = new JFileChooser();
                }
                try {
                    this._fcClass = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcClass = new JFileChooser();
                }
                try {
                    this._fcTxt = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcTxt = new JFileChooser();
                }
                try {
                    this._fcConfig = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcConfig = new JFileChooser();
                }
                try {
                    this._fcTxt = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcTxt = new JFileChooser();
                }
                try {
                    this._fcInput = new JFileChooser(new File(".").getCanonicalPath());
                }
                catch (IOException ioe) {
                    this._fcInput = new JFileChooser();
                }
                this._fcInput.setFileSelectionMode(2);
                this._fcInput.setMultiSelectionEnabled(true);
                final FileFilter rtJarFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().equalsIgnoreCase("rt.jar") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "rt.jar";
                    }
                };
                final FileFilter starJarFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".jar") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "*.jar";
                    }
                };
                final FileFilter starClassFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".class") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "*.class";
                    }
                };
                final FileFilter starTxtFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "*.txt";
                    }
                };
                final FileFilter starConfigFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".xml") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "*.xml";
                    }
                };
                final FileFilter starInputFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".jar") || f.getName().toLowerCase().endsWith(".class") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "*.class, *.jar";
                    }
                };
                this._frame.setLayout(new BorderLayout());
                JPanel topPanel = new JPanel();
                topPanel.setLayout(new SpringLayout());
                this._initDone = false;
                DocumentListener docListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent e) {
                        if (FileInstrumentorLauncherView.this._initDone) {
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                    }

                    public void removeUpdate(DocumentEvent e) {
                        if (FileInstrumentorLauncherView.this._initDone) {
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                    }

                    public void changedUpdate(DocumentEvent e) {
                        if (FileInstrumentorLauncherView.this._initDone) {
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                    }
                };
                this._menuBar = new JMenuBar();
                this._fileMenu = new JMenu("File");
                this._fileMenu.setMnemonic(70);
                this._fileMenu.getAccessibleContext().setAccessibleDescription("File menu.");
                this._menuBar.add(this._fileMenu);
                this._fileMenuItems = new JMenuItem[3];
                this._fileMenuItems[0] = new JMenuItem("Open configuration", 79);
                this._fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                this._fileMenuItems[0].getAccessibleContext().setAccessibleDescription("Opens a configuration file.");
                this._fileMenuItems[0].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcConfig.addChoosableFileFilter(starConfigFilter);
                        int returnVal = FileInstrumentorLauncherView.this._fcConfig.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            FileInstrumentorLauncherView.this.openConfig(FileInstrumentorLauncherView.this._fcConfig.getSelectedFile());
                        }
                        FileInstrumentorLauncherView.this._fcConfig.removeChoosableFileFilter(starConfigFilter);
                    }
                });
                this._fileMenu.add(this._fileMenuItems[0]);
                this._fileMenuItems[1] = new JMenuItem("Save configuration", 83);
                this._fileMenuItems[1].setAccelerator(KeyStroke.getKeyStroke(83, 2));
                this._fileMenuItems[1].getAccessibleContext().setAccessibleDescription("Saves a configuration file.");
                this._fileMenuItems[1].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcConfig.addChoosableFileFilter(starConfigFilter);
                        int returnVal = FileInstrumentorLauncherView.this._fcConfig.showSaveDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            FileInstrumentorLauncherView.this.saveConfig(FileInstrumentorLauncherView.this._fcConfig.getSelectedFile());
                        }
                        FileInstrumentorLauncherView.this._fcConfig.removeChoosableFileFilter(starConfigFilter);
                    }
                });
                this._fileMenu.add(this._fileMenuItems[1]);
                this._fileMenuItems[2] = new JMenuItem("Exit", 88);
                this._fileMenuItems[2].setAccelerator(KeyStroke.getKeyStroke(88, 2));
                this._fileMenuItems[2].getAccessibleContext().setAccessibleDescription("Close and exit the program.");
                this._fileMenuItems[2].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                });
                this._fileMenu.add(this._fileMenuItems[2]);
                this._helpMenu = new JMenu("Help");
                this._helpMenu.setMnemonic(72);
                this._helpMenu.getAccessibleContext().setAccessibleDescription("Help menu.");
                this._menuBar.add(this._helpMenu);
                this._helpMenuItems = new JMenuItem[1];
                this._helpMenuItems[0] = new JMenuItem("Properties", 80);
                this._helpMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(80, 2));
                this._helpMenuItems[0].getAccessibleContext().setAccessibleDescription("Display a list of properties and their values.");
                this._helpMenuItems[0].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.updatePaths();
                        StringBuilder sb = new StringBuilder();
                        for (Object o : System.getProperties().keySet()) {
                            String key = (String)o;
                            sb.append(key);
                            sb.append(" = ");
                            sb.append(System.getProperty(key));
                            sb.append(System.getProperty("line.separator"));
                        }
                        TextAreaMessageDialog.showDialog(FileInstrumentorLauncherView.this._frame, "Properties", sb.toString());
                    }
                });
                this._helpMenu.add(this._helpMenuItems[0]);
                this._frame.setJMenuBar(this._menuBar);
                JLabel l = new JLabel("Project Root:", 11);
                topPanel.add(l);
                JPanel p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._projectRootName.getComponent(), "Center");
                JButton projectRootBtn = new JButton("...");
                p.add((Component)projectRootBtn, "East");
                ((JTextComponent)this._projectRootName.getComponent()).getDocument().addDocumentListener(docListener);
                projectRootBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JFileChooser dirChooser;
                        try {
                            dirChooser = new JFileChooser(new File(".").getCanonicalPath());
                        }
                        catch (IOException ioe) {
                            dirChooser = new JFileChooser();
                        }
                        dirChooser.setFileSelectionMode(1);
                        int returnVal = dirChooser.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File file = dirChooser.getSelectedFile();
                            FileInstrumentorLauncherView.this._projectRootName.set(file.getAbsolutePath());
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                    }
                });
                ((JTextComponent)this._projectRootName.getComponent()).getDocument().addDocumentListener(docListener);
                l = new JLabel("Instrument rt.jar:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new FlowLayout());
                p.add((Component)this._instrumentRt.getComponent());
                ((JToggleButton)this._instrumentRt.getComponent()).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.setInstrumentRtJarEnable((Boolean)FileInstrumentorLauncherView.this._instrumentRt.get());
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                l = new JLabel("Source rt.jar:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._sourceRtJarName.getComponent(), "Center");
                this._sourceRtJarBtn = new JButton("...");
                p.add((Component)this._sourceRtJarBtn, "East");
                ((JTextComponent)this._sourceRtJarName.getComponent()).getDocument().addDocumentListener(docListener);
                this._sourceRtJarBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcJar.addChoosableFileFilter(starJarFilter);
                        FileInstrumentorLauncherView.this._fcJar.addChoosableFileFilter(rtJarFilter);
                        try {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(FileOps.makeRelativeTo(new File((String)FileInstrumentorLauncherView.this._sourceRtJarName.get()), FileInstrumentorLauncherView.this._projectRoot));
                        }
                        catch (IOException e1) {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(new File(FileInstrumentorLauncherView.this._projectRoot, (String)FileInstrumentorLauncherView.this._sourceRtJarName.get()));
                        }
                        int returnVal = FileInstrumentorLauncherView.this._fcJar.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File f = FileInstrumentorLauncherView.this._fcJar.getSelectedFile();
                            String fn = f.toString();
                            if (!f.isAbsolute()) {
                                fn = "%project.root%" + File.separator + fn;
                            }
                            FileInstrumentorLauncherView.this._sourceRtJarName.set(fn);
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                        FileInstrumentorLauncherView.this._fcJar.removeChoosableFileFilter(rtJarFilter);
                        FileInstrumentorLauncherView.this._fcJar.removeChoosableFileFilter(starJarFilter);
                    }
                });
                l = new JLabel("Concutest jar:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._cunitRtJarName.getComponent(), "Center");
                this._cunitRtJarBtn = new JButton("...");
                p.add((Component)this._cunitRtJarBtn, "East");
                ((JTextComponent)this._cunitRtJarName.getComponent()).getDocument().addDocumentListener(docListener);
                this._cunitRtJarBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcJar.addChoosableFileFilter(starJarFilter);
                        try {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(FileOps.makeRelativeTo(new File((String)FileInstrumentorLauncherView.this._cunitRtJarName.get()), FileInstrumentorLauncherView.this._projectRoot));
                        }
                        catch (IOException e1) {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(new File((String)FileInstrumentorLauncherView.this._projectRootName.get(), (String)FileInstrumentorLauncherView.this._cunitRtJarName.get()));
                        }
                        int returnVal = FileInstrumentorLauncherView.this._fcJar.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File f = FileInstrumentorLauncherView.this._fcJar.getSelectedFile();
                            String fn = f.toString();
                            if (!f.isAbsolute()) {
                                fn = "%project.root%" + File.separator + fn;
                            }
                            FileInstrumentorLauncherView.this._cunitRtJarName.set(fn);
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                        FileInstrumentorLauncherView.this._fcJar.removeChoosableFileFilter(starJarFilter);
                    }
                });
                l = new JLabel("Destination rt.jar:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._destRtJarName.getComponent(), "Center");
                this._destRtJarBtn = new JButton("...");
                p.add((Component)this._destRtJarBtn, "East");
                ((JTextComponent)this._destRtJarName.getComponent()).getDocument().addDocumentListener(docListener);
                this._destRtJarBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcJar.addChoosableFileFilter(starJarFilter);
                        try {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(FileOps.makeRelativeTo(new File((String)FileInstrumentorLauncherView.this._destRtJarName.get()), FileInstrumentorLauncherView.this._projectRoot));
                        }
                        catch (IOException e1) {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(new File((String)FileInstrumentorLauncherView.this._projectRootName.get(), (String)FileInstrumentorLauncherView.this._destRtJarName.get()));
                        }
                        int returnVal = FileInstrumentorLauncherView.this._fcJar.showSaveDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File f = FileInstrumentorLauncherView.this._fcJar.getSelectedFile();
                            String fn = f.toString();
                            if (!f.isAbsolute()) {
                                fn = "%project.root%" + File.separator + fn;
                            }
                            FileInstrumentorLauncherView.this._destRtJarName.set(fn);
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                        FileInstrumentorLauncherView.this._fcJar.removeChoosableFileFilter(starJarFilter);
                    }
                });
                l = new JLabel("Instrumentor:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._instrumentorName.getComponent(), "Center");
                JButton instrumentorBtn = new JButton("...");
                p.add((Component)instrumentorBtn, "East");
                ((JTextComponent)this._instrumentorName.getComponent()).getDocument().addDocumentListener(docListener);
                instrumentorBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcClass.addChoosableFileFilter(starClassFilter);
                        int returnVal = FileInstrumentorLauncherView.this._fcClass.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            try {
                                String cwd;
                                String name = FileInstrumentorLauncherView.this._fcClass.getSelectedFile().getCanonicalPath();
                                if (name.endsWith(".class")) {
                                    name = name.substring(0, name.length() - 6);
                                }
                                if (name.startsWith(cwd = new File(".").getCanonicalPath())) {
                                    name = name.substring(cwd.length() + 1);
                                }
                                name = name.replace(File.separatorChar, '.');
                                FileInstrumentorLauncherView.this._instrumentorName.set(name);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        FileInstrumentorLauncherView.this._fcClass.removeChoosableFileFilter(starClassFilter);
                    }
                });
                l = new JLabel("System instrumentor:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._sysInstrumentorName.getComponent(), "Center");
                JButton sysInstrumentorBtn = new JButton("...");
                p.add((Component)sysInstrumentorBtn, "East");
                ((JTextComponent)this._sysInstrumentorName.getComponent()).getDocument().addDocumentListener(docListener);
                sysInstrumentorBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcClass.addChoosableFileFilter(starClassFilter);
                        int returnVal = FileInstrumentorLauncherView.this._fcClass.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            try {
                                String cwd;
                                String name = FileInstrumentorLauncherView.this._fcClass.getSelectedFile().getCanonicalPath();
                                if (name.endsWith(".class")) {
                                    name = name.substring(0, name.length() - 6);
                                }
                                if (name.startsWith(cwd = new File(".").getCanonicalPath())) {
                                    name = name.substring(cwd.length() + 1);
                                }
                                name = name.replace(File.separatorChar, '.');
                                FileInstrumentorLauncherView.this._sysInstrumentorName.set(name);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        FileInstrumentorLauncherView.this._fcClass.removeChoosableFileFilter(starClassFilter);
                    }
                });
                l = new JLabel("Create backups:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new FlowLayout());
                p.add((Component)this._createBackups.getComponent());
                ((JToggleButton)this._createBackups.getComponent()).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                l = new JLabel("Additional arguments:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._argsField.getComponent(), "Center");
                ((JTextComponent)this._argsField.getComponent()).getDocument().addDocumentListener(docListener);
                l = new JLabel("Output:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new FlowLayout());
                p.add(conOutBtn);
                p.add(fileOutBtn);
                p.add(quietOutBtn);
                conOutBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.setOutputFileEnable(false);
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                fileOutBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.setOutputFileEnable(true);
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                quietOutBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.setOutputFileEnable(false);
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                l = new JLabel("Output file:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                p.add((Component)this._outputName.getComponent(), "Center");
                this._outputBtn = new JButton("...");
                p.add((Component)this._outputBtn, "East");
                ((JTextComponent)this._outputName.getComponent()).getDocument().addDocumentListener(docListener);
                this._outputBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcTxt.addChoosableFileFilter(starTxtFilter);
                        try {
                            FileInstrumentorLauncherView.this._fcJar.setSelectedFile(FileOps.makeRelativeTo(new File((String)FileInstrumentorLauncherView.this._outputName.get()), FileInstrumentorLauncherView.this._projectRoot));
                        }
                        catch (IOException e1) {
                            FileInstrumentorLauncherView.this._fcTxt.setSelectedFile(new File(FileInstrumentorLauncherView.this._projectRoot, (String)FileInstrumentorLauncherView.this._outputName.get()));
                        }
                        int returnVal = FileInstrumentorLauncherView.this._fcTxt.showSaveDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File f = FileInstrumentorLauncherView.this._fcTxt.getSelectedFile();
                            String fn = f.toString();
                            if (!f.isAbsolute()) {
                                fn = "%project.root%" + File.separator + fn;
                            }
                            FileInstrumentorLauncherView.this._outputName.set(fn);
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                        FileInstrumentorLauncherView.this._fcTxt.removeChoosableFileFilter(starTxtFilter);
                    }
                });
                l = new JLabel("Input files:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                this._classNameField = new JTextField();
                p.add((Component)this._classNameField, "Center");
                JPanel sp = new JPanel();
                p.add((Component)sp, "East");
                sp.setLayout(new BorderLayout());
                JButton addFileBtn = new JButton("+");
                addFileBtn.setToolTipText("Add input files");
                JButton removeFileBtn = new JButton("-");
                removeFileBtn.setToolTipText("Remove selected input files");
                sp.add((Component)addFileBtn, "West");
                sp.add((Component)removeFileBtn, "East");
                addFileBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this._fcInput.addChoosableFileFilter(starJarFilter);
                        FileInstrumentorLauncherView.this._fcInput.addChoosableFileFilter(starClassFilter);
                        FileInstrumentorLauncherView.this._fcInput.addChoosableFileFilter(starInputFilter);
                        int returnVal = FileInstrumentorLauncherView.this._fcInput.showOpenDialog(FileInstrumentorLauncherView.this._frame);
                        if (returnVal == 0) {
                            File[] selectedFiles = FileInstrumentorLauncherView.this._fcInput.getSelectedFiles();
                            FileInstrumentorLauncherView.this.addClassFiles(selectedFiles);
                        }
                        FileInstrumentorLauncherView.this._fcInput.removeChoosableFileFilter(starInputFilter);
                        FileInstrumentorLauncherView.this._fcInput.removeChoosableFileFilter(starClassFilter);
                        FileInstrumentorLauncherView.this._fcInput.removeChoosableFileFilter(starJarFilter);
                    }
                });
                removeFileBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        for (int r : FileInstrumentorLauncherView.this._fileTable.getSelectedRows()) {
                            FileInstrumentorLauncherView.this._fileTableModel.removeRow(r);
                        }
                        FileInstrumentorLauncherView.this.updatePaths();
                    }
                });
                this._classNameField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.addClassFiles(new File[]{new File(FileInstrumentorLauncherView.this._classNameField.getText())});
                        FileInstrumentorLauncherView.this._classNameField.setText("");
                    }
                });
                topPanel.add(new JPanel());
                p = new JPanel();
                topPanel.add(p);
                p.setLayout(new BorderLayout());
                this._fileTable = new JTable(this._fileTableModel);
                JScrollPane fileTableSP = new JScrollPane(this._fileTable);
                fileTableSP.setHorizontalScrollBarPolicy(30);
                fileTableSP.setVerticalScrollBarPolicy(22);
                p.add((Component)fileTableSP, "Center");
                this._fileTable.setMinimumSize(new Dimension(300, 200));
                this._fileTable.setPreferredSize(new Dimension(300, 200));
                this._fileTable.setSelectionMode(2);
                AbstractAction emptyAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        int[] sel = FileInstrumentorLauncherView.this._fileTable.getSelectedRows();
                        for (int i = sel.length - 1; i >= 0; --i) {
                            FileInstrumentorLauncherView.this._fileTableModel.removeRow(sel[i]);
                        }
                        if (sel.length > 0) {
                            FileInstrumentorLauncherView.this.updatePaths();
                        }
                    }
                };
                this._fileTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
                InputMap im = this._fileTable.getInputMap(1);
                im.put(KeyStroke.getKeyStroke("DELETE"), "delete");
                this._fileTable.getActionMap().put("delete", emptyAction);
                this._fileTable.getColumnModel().getColumn(0).setCellRenderer(new FileTableCellRenderer());
                l = new JLabel("Generated command line:", 11);
                topPanel.add(l);
                p = new JPanel();
                topPanel.add(p);
                l.setLabelFor(p);
                p.setLayout(new BorderLayout());
                this._cmdLine = new JTextField();
                p.add((Component)this._cmdLine, "Center");
                this._cmdLine.setEditable(false);
                this.updatePaths();
                GUIUtils.makeCompactGrid(topPanel, 14, 2, 0, 0, 3, 0);
                JPanel bottomPanel = new JPanel();
                bottomPanel.setLayout(new FlowLayout());
                this._runBtn = new JButton("Run");
                bottomPanel.add(this._runBtn);
                this._runBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileInstrumentorLauncherView.this.executeFileInstrumentor(false);
                    }
                });
                this._runBtn.setMnemonic('r');
                JPanel scrolledPane = new JPanel(new BorderLayout());
                scrolledPane.add((Component)topPanel, "Center");
                scrolledPane.add((Component)bottomPanel, "South");
                this._scrollPane = new JScrollPane(scrolledPane);
                this._frame.add((Component)this._scrollPane, "Center");
                this._frame.pack();
                this._initDone = true;
                this.setOutputFileEnable(((String)this._outputChoice.get()).equalsIgnoreCase("file"));
                this.setInstrumentRtJarEnable((Boolean)this._instrumentRt.get());
            }
        }

        private void addClassFiles(File ... selectedFiles) {
            for (File f : selectedFiles) {
                boolean unique = true;
                for (int r = 0; r < this._fileTableModel.getRowCount(); ++r) {
                    if (!this._fileTableModel.getValueAt(r, 0).equals(f)) continue;
                    unique = false;
                    break;
                }
                if (!unique) continue;
                Vector<String> row = new Vector<String>();
                try {
                    f = FileOps.makeRelativeTo(f, this._projectRoot);
                }
                catch (IOException e1) {
                    // empty catch block
                }
                String fn = f.toString();
                if (!f.isAbsolute()) {
                    fn = "%project.root%" + File.separator + fn;
                }
                row.add(fn);
                this._fileTableModel.addRow(row);
            }
            this.updatePaths();
        }

        private void updatePaths() {
            this._projectRoot = ((String)this._projectRootName.get()).length() == 0 ? new File(".") : new File(StringOps.replaceVariables((String)this._projectRootName.get(), System.getProperties()));
            System.setProperty(FileInstrumentorLauncher.DEFAULT_SOURCE_JAR_PROPERTY, FileInstrumentor.getDefaultSourceRtJarName());
            this.setProperty(FileInstrumentorLauncher.PROJECT_ROOT_PROPERTY, this._projectRootName, this._projectRootPredicate);
            this.setProperty(FileInstrumentorLauncher.SOURCE_JAR_PROPERTY, this._sourceRtJarName, this._sourceRtJarPredicate);
            this.setProperty(FileInstrumentorLauncher.CUNIT_JAR_PROPERTY, this._cunitRtJarName, this._cunitRtJarPredicate);
            this.setProperty(FileInstrumentorLauncher.DEST_JAR_PROPERTY, this._destRtJarName, this._destRtJarPredicate);
            this.setProperty(FileInstrumentorLauncher.INSTRUMENTOR_NAME_PROPERTY, this._instrumentorName, this._instrumentorNamePredicate);
            this.setProperty(FileInstrumentorLauncher.SYSINSTRUMENTOR_NAME_PROPERTY, this._sysInstrumentorName, this._sysInstrumentorNamePredicate);
            this.setProperty(FileInstrumentorLauncher.OUTPUT_FILE_PROPERTY, this._outputName, this._outputFilePredicate);
            if (!this._headless) {
                this.updateCmdLine();
                this._fileTable.repaint();
            }
        }

        private void openConfig(File file) {
            System.out.println(file.toString());
            try {
                this.openConfig(new FileReader(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void openConfig(Reader r) {
            try {
                XMLConfig xc = new XMLConfig(r);
                this._projectRootName.set(xc.get("concutest/instrument/project.root", "").replace('/', File.separatorChar));
                this._projectRoot = ((String)this._projectRootName.get()).length() == 0 ? new File(".") : new File(StringOps.replaceVariables((String)this._projectRootName.get(), System.getProperties()));
                try {
                    this._projectRoot = this._projectRoot.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this._projectRootName.setToolTipText(this._projectRoot.getAbsolutePath());
                String s = xc.get("concutest/instrument.rt", "false");
                this._instrumentRt.set(s.equalsIgnoreCase("true"));
                this.setInstrumentRtJarEnable((Boolean)this._instrumentRt.get());
                s = xc.get("concutest/instrument/source.jar", "").replace('/', File.separatorChar).replace('|', File.pathSeparatorChar);
                this._sourceRtJarName.set(s);
                this._sourceRtJarName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                s = xc.get("concutest/instrument/cunit.jar", "").replace('/', File.separatorChar);
                this._cunitRtJarName.set(s);
                this._cunitRtJarName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                s = xc.get("concutest/instrument/dest.jar", "").replace('/', File.separatorChar);
                this._destRtJarName.set(s);
                this._destRtJarName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                s = xc.get("concutest/instrument/instrumentor.name", "");
                this._instrumentorName.set(s);
                this._instrumentorName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                s = xc.get("concutest/instrument/sysinstrumentor.name", "");
                this._sysInstrumentorName.set(s);
                this._sysInstrumentorName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                s = xc.get("concutest/instrument/backups.create", "false");
                this._createBackups.set(s.equalsIgnoreCase("true"));
                this._argsField.set(xc.get("concutest/instrument/args.line", ""));
                this._outputChoice.set(xc.get("concutest/instrument/output.type", "console"));
                this.setOutputFileEnable(((String)this._outputChoice.get()).equalsIgnoreCase("file"));
                s = xc.get("concutest/instrument/output.file", "").replace('/', File.separatorChar);
                this._outputName.set(s);
                this._outputName.setToolTipText(StringOps.replaceVariables(s, System.getProperties()));
                this._fileTableModel.setRowCount(0);
                List<String> fileNames = xc.getMultiple("concutest/instrument/input/file");
                for (String fn : fileNames) {
                    if (fn.length() <= 0) continue;
                    Vector<String> row = new Vector<String>();
                    row.add(fn.replace('/', File.separatorChar));
                    this._fileTableModel.addRow(row);
                }
                this._cunitFilters = xc.getMultiple("concutest/instrument/cunit/filter");
                this.updatePaths();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void saveConfig(File file) {
            try {
                Node n;
                XMLConfig xc = file.exists() ? new XMLConfig(file) : new XMLConfig();
                xc.set("concutest/instrument/project.root", ((String)this._projectRootName.get()).replace(File.separatorChar, '/'));
                xc.set("concutest/instrument.rt", String.valueOf(this._instrumentRt.get()));
                xc.set("concutest/instrument/source.jar", ((String)this._sourceRtJarName.get()).replace(File.separatorChar, '/').replace(File.pathSeparatorChar, '|'));
                xc.set("concutest/instrument/cunit.jar", ((String)this._cunitRtJarName.get()).replace(File.separatorChar, '/'));
                xc.set("concutest/instrument/dest.jar", ((String)this._destRtJarName.get()).replace(File.separatorChar, '/'));
                xc.set("concutest/instrument/instrumentor.name", (String)this._instrumentorName.get());
                xc.set("concutest/instrument/sysinstrumentor.name", (String)this._sysInstrumentorName.get());
                xc.set("concutest/instrument/backups.create", String.valueOf(this._createBackups.get()));
                xc.set("concutest/instrument/args.line", (String)this._argsField.get());
                xc.set("concutest/instrument/output.type", (String)this._outputChoice.get());
                xc.set("concutest/instrument/output.file", ((String)this._outputName.get()).replace(File.separatorChar, '/'));
                if (this._fileTableModel.getRowCount() > 0) {
                    n = xc.set("concutest/instrument/input", "");
                    for (int r = 0; r < this._fileTableModel.getRowCount(); ++r) {
                        xc.set("file", ((String)this._fileTableModel.getValueAt(r, 0)).replace(File.separatorChar, '/'), n, false);
                    }
                }
                if (this._cunitFilters.size() > 0) {
                    n = xc.set("concutest/instrument/cunit", "");
                    for (String filter : this._cunitFilters) {
                        xc.set("file", filter.replace(File.separatorChar, '/'), n, false);
                    }
                }
                xc.save(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void updateCmdLine() {
            if (!this._headless) {
                this._cmdLine.setText(this.getCmdLine());
            }
        }

        private void setOutputFileEnable(boolean b) {
            if (!this._headless) {
                this._outputName.setEnabled(b);
                this._outputBtn.setEnabled(b);
            }
        }

        private void setInstrumentRtJarEnable(boolean b) {
            if (!this._headless) {
                this._sourceRtJarName.setEnabled(b);
                this._sourceRtJarBtn.setEnabled(b);
                this._cunitRtJarName.setEnabled(b);
                this._cunitRtJarBtn.setEnabled(b);
                this._destRtJarName.setEnabled(b);
                this._destRtJarBtn.setEnabled(b);
            }
        }

        public void executeFileInstrumentor(boolean block) {
            if (!this._headless) {
                this._runBtn.setText("running...");
                this._runBtn.setEnabled(false);
            }
            final Thread tMain = new Thread(new Runnable(){

                public void run() {
                    FileInstrumentor.main(FileInstrumentorLauncherView.this.getArgs().toArray(new String[0]));
                }
            });
            tMain.start();
            Thread tSlave = new Thread(new Runnable(){

                public void run() {
                    boolean died = false;
                    while (!died) {
                        try {
                            tMain.join();
                            died = true;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!FileInstrumentorLauncherView.this._headless) {
                        FileInstrumentorLauncherView.this._runBtn.setText("Run");
                        FileInstrumentorLauncherView.this._runBtn.setEnabled(true);
                    }
                }
            });
            tSlave.start();
            if (block) {
                boolean died = false;
                while (!died) {
                    try {
                        tSlave.join();
                        died = true;
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private ArrayList<String> getArgs() {
            String pr = this.setProperty(FileInstrumentorLauncher.PROJECT_ROOT_PROPERTY, this._projectRootName, this._projectRootPredicate);
            String sj = this.setProperty(FileInstrumentorLauncher.SOURCE_JAR_PROPERTY, this._sourceRtJarName, this._sourceRtJarPredicate);
            String cj = this.setProperty(FileInstrumentorLauncher.CUNIT_JAR_PROPERTY, this._cunitRtJarName, this._cunitRtJarPredicate);
            String dj = this.setProperty(FileInstrumentorLauncher.DEST_JAR_PROPERTY, this._destRtJarName, this._destRtJarPredicate);
            String in = this.setProperty(FileInstrumentorLauncher.INSTRUMENTOR_NAME_PROPERTY, this._instrumentorName, this._instrumentorNamePredicate);
            String sn = this.setProperty(FileInstrumentorLauncher.SYSINSTRUMENTOR_NAME_PROPERTY, this._sysInstrumentorName, this._sysInstrumentorNamePredicate);
            String of = this.setProperty(FileInstrumentorLauncher.OUTPUT_FILE_PROPERTY, this._outputName, this._outputFilePredicate);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (int r = 0; r < this._fileTableModel.getRowCount(); ++r) {
                if (first) {
                    first = false;
                } else {
                    sb.append(File.pathSeparatorChar);
                }
                String f = StringOps.replaceVariables((String)this._fileTableModel.getValueAt(r, 0), System.getProperties());
                sb.append(f);
            }
            String vs = StringOps.replaceVariables(sb.toString(), System.getProperties());
            System.setProperty(FileInstrumentorLauncher.INPUT_FILES_PROPERTY, vs);
            sb = new StringBuilder();
            first = true;
            for (String filter : this._cunitFilters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(File.pathSeparatorChar);
                }
                String f = StringOps.replaceVariables(filter, System.getProperties());
                sb.append(f);
            }
            String fs = StringOps.replaceVariables(sb.toString(), System.getProperties());
            System.setProperty(FileInstrumentorLauncher.CUNIT_FILTER_PROPERTY, fs);
            ArrayList<String> args = new ArrayList<String>();
            if (((String)this._outputChoice.get()).equalsIgnoreCase("quiet")) {
                args.add("-quiet");
            } else if (((String)this._outputChoice.get()).equalsIgnoreCase("file")) {
                args.add("-output");
                args.add(of);
            }
            if (((Boolean)this._instrumentRt.get()).booleanValue()) {
                args.add("-rt");
                if (((String)this._sourceRtJarName.get()).length() > 0) {
                    args.add("-rts");
                    args.add(sj);
                }
                if (((String)this._cunitRtJarName.get()).length() > 0) {
                    args.add("-rtm");
                    args.add(cj);
                }
                if (((String)this._destRtJarName.get()).length() > 0) {
                    args.add("-rtd");
                    args.add(dj);
                }
            }
            if (((String)this._instrumentorName.get()).length() > 0) {
                args.add("-i");
                args.add(in);
            }
            if (((String)this._sysInstrumentorName.get()).length() > 0) {
                args.add("-s");
                args.add(sn);
            }
            if (!((Boolean)this._createBackups.get()).booleanValue()) {
                args.add("-nobackup");
            }
            if (this._cunitFilters.size() > 0) {
                args.add("-rtmfilter");
                args.add(fs);
            }
            sb = new StringBuilder();
            if (((String)this._argsField.get()).length() > 0) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer((String)this._argsField.get());
                for (String a : tok) {
                    String repl = StringOps.replaceVariables(a, System.getProperties());
                    args.add(repl);
                    sb.append(repl);
                    sb.append(' ');
                }
            }
            this._argsField.setToolTipText(sb.toString().trim());
            for (int r = 0; r < this._fileTableModel.getRowCount(); ++r) {
                String f = StringOps.replaceVariables((String)this._fileTableModel.getValueAt(r, 0), System.getProperties());
                args.add(f);
            }
            return args;
        }

        private String getCmdLine() {
            StringBuilder sb = new StringBuilder();
            for (String a : this.getArgs()) {
                sb.append(a);
                sb.append(' ');
            }
            return sb.toString();
        }

        private String setProperty(String k, TextComponentProperty tp, IPredicate.Binary<String, File> okPred) {
            String vs = StringOps.replaceVariables((String)tp.get(), System.getProperties());
            System.setProperty(k, vs);
            if (!this._headless) {
                tp.setToolTipText(vs);
                Color bg = UIManager.getColor("TextField.background");
                File f = new File(vs);
                if (!((Boolean)okPred.apply(vs, f)).booleanValue()) {
                    bg = Color.RED.darker();
                }
                tp.setBackground(bg);
            }
            return vs;
        }

        public class FileTableCellRenderer
        extends DefaultTableCellRenderer
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                File f;
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                String fn = StringOps.replaceVariables((String)o, System.getProperties());
                if (fn.indexOf(32) >= 0) {
                    fn = '\"' + fn + '\"';
                }
                if (!(f = new File(fn)).exists()) {
                    c.setBackground(isSelected ? Color.RED : Color.RED.darker());
                    c.setToolTipText("Not found: " + fn);
                } else {
                    c.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    c.setToolTipText(fn);
                }
                return c;
            }
        }
    }
}

