/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ListUtilities;
import koala.dynamicjava.util.ReflectionUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportationManager
implements Cloneable {
    protected List<String> importOnDemandClauses = new LinkedList<String>();
    protected List<String> singleTypeImportClauses = new LinkedList<String>();
    protected List<String> importOnDemandStaticClauses = new LinkedList<String>();
    protected List<Field> singleTypeImportStaticFieldClauses = new LinkedList<Field>();
    protected List<Method> singleTypeImportStaticMethodClauses = new LinkedList<Method>();
    protected String currentPackage;
    protected ClassLoader classLoader;

    public ImportationManager(ClassLoader cl) {
        this.classLoader = cl;
        this.declarePackageImport("java.lang");
        this.setCurrentPackage("");
    }

    public Object clone() {
        return new ImportationManager(this);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public void setCurrentPackage(String pkg) {
        this.currentPackage = pkg;
    }

    public String getCurrentPackage() {
        return this.currentPackage;
    }

    public List<String> getImportOnDemandClauses() {
        return this.importOnDemandClauses;
    }

    public List<String> getSingleTypeImportClauses() {
        return this.singleTypeImportClauses;
    }

    public List<String> getImportOnDemandStaticClauses() {
        return this.importOnDemandStaticClauses;
    }

    public List<Field> getSingleTypeImportStaticFieldClauses() {
        return this.singleTypeImportStaticFieldClauses;
    }

    public List<Method> getSingleTypeImportStaticMethodClauses() {
        return this.singleTypeImportStaticMethodClauses;
    }

    public void declarePackageImport(String pkg) {
        if (this.importOnDemandClauses.size() == 0 || !this.importOnDemandClauses.get(0).equals(pkg)) {
            this.importOnDemandClauses.remove(pkg);
            this.importOnDemandClauses.add(0, pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareClassImport(String cname) throws ClassNotFoundException {
        try {
            if (!this.singleTypeImportClauses.remove(cname)) {
                Class.forName(cname, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            Class<?> c = this.findInnerClass(cname);
            this.singleTypeImportClauses.remove(c == null ? cname : c.getName());
            this.singleTypeImportClauses.add(0, c == null ? cname : c.getName());
        }
        finally {
            this.singleTypeImportClauses.add(0, cname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareClassStaticImport(String cname) throws ClassNotFoundException {
        try {
            if (!this.importOnDemandStaticClauses.remove(cname)) {
                Class.forName(cname, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            Class<?> c = this.findInnerClass(cname);
            this.importOnDemandStaticClauses.remove(c == null ? cname : c.getName());
            this.importOnDemandStaticClauses.add(0, c == null ? cname : c.getName());
        }
        finally {
            this.importOnDemandStaticClauses.add(0, cname);
        }
    }

    public void declareMemberStaticImport(String member) throws ClassNotFoundException {
        Class<?> surroundingClass;
        int i = member.lastIndexOf(46);
        String surroundingClassName = member;
        if (i > 0) {
            surroundingClassName = member.substring(0, i);
        }
        try {
            surroundingClass = Class.forName(surroundingClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            surroundingClass = this.findInnerClass(surroundingClassName);
        }
        boolean foundSomethingToImport = false;
        boolean foundSecurityException = false;
        String name = member.substring(i + 1, member.length());
        try {
            Class<?> c;
            try {
                c = Class.forName(member, true, this.classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                c = this.findInnerClass(member);
            }
            if (this.isPublicAndStatic(c.getModifiers())) {
                this.declareClassImport(member);
                foundSomethingToImport = true;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
            foundSecurityException = true;
        }
        try {
            Field f = surroundingClass.getField(name);
            if (this.isPublicAndStatic(f.getModifiers())) {
                this.singleTypeImportStaticFieldClauses.remove(f);
                this.singleTypeImportStaticFieldClauses.add(0, f);
                foundSomethingToImport = true;
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            foundSecurityException = true;
        }
        try {
            Method[] methodArray = surroundingClass.getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method m;
                if (!this.isPublicAndStatic(methodArray[j].getModifiers()) || !methodArray[j].getName().equals(name) || !this.isPublicAndStatic((m = methodArray[j]).getModifiers())) continue;
                this.singleTypeImportStaticMethodClauses.remove(m);
                this.singleTypeImportStaticMethodClauses.add(0, m);
                foundSomethingToImport = true;
            }
        }
        catch (SecurityException e) {
            foundSecurityException = true;
        }
        if (foundSomethingToImport) {
            return;
        }
        throw new ClassNotFoundException(new StringBuffer().append("No public members of the name ").append(member).toString());
    }

    public Class<?> lookupClass(String cname, String ccname) throws ClassNotFoundException {
        String str = cname.replace('.', '$');
        String t = this.currentPackage.equals("") ? cname : new StringBuffer().append(this.currentPackage).append(".").append(cname).toString();
        try {
            return Class.forName(t, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (cname.indexOf(46) != -1) {
                try {
                    return Class.forName(cname, false, this.classLoader);
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
            }
            try {
                return this.findInnerClass(t);
            }
            catch (ClassNotFoundException e3) {
                block23: {
                    for (String s : this.singleTypeImportClauses) {
                        if (this.hasSuffix(s, cname) || this.hasSuffix(s, str)) {
                            try {
                                return Class.forName(s, false, this.classLoader);
                            }
                            catch (ClassNotFoundException e4) {
                                return this.findInnerClass(s);
                            }
                        }
                        int i = str.indexOf(36);
                        if (i == -1) continue;
                        try {
                            if (!this.hasSuffix(s, str.substring(0, i))) continue;
                            return Class.forName(new StringBuffer().append(s).append(str.substring(i, str.length())).toString(), false, this.classLoader);
                        }
                        catch (ClassNotFoundException e5) {
                        }
                    }
                    if (ccname != null) {
                        try {
                            return Class.forName(new StringBuffer().append(ccname).append("$").append(str).toString(), false, this.classLoader);
                        }
                        catch (ClassNotFoundException e6) {
                            int i;
                            Iterator<String> it = this.getOuterNames(ccname).iterator();
                            String tmp = ccname;
                            while (it.hasNext()) {
                                String s = it.next();
                                int i2 = tmp.lastIndexOf(s) + s.length();
                                tmp = tmp.substring(0, i2);
                                if (!s.equals(cname)) continue;
                                return Class.forName(tmp, false, this.classLoader);
                            }
                            if (!ccname.endsWith(cname) || (i = ccname.lastIndexOf(cname)) <= 0 || ccname.charAt(i - 1) != '$') break block23;
                            return Class.forName(ccname, false, this.classLoader);
                        }
                    }
                }
                for (String s : this.importOnDemandClauses) {
                    try {
                        return Class.forName(new StringBuffer().append(s).append(".").append(str).toString(), false, this.classLoader);
                    }
                    catch (ClassNotFoundException e7) {
                    }
                }
                for (String s : this.importOnDemandStaticClauses) {
                    try {
                        return Class.forName(new StringBuffer().append(s).append("$").append(str).toString(), false, this.classLoader);
                    }
                    catch (ClassNotFoundException e8) {
                    }
                }
                throw new ClassNotFoundException(cname);
            }
        }
    }

    protected List<String> getOuterNames(String cname) {
        int i;
        LinkedList<String> l = new LinkedList<String>();
        while ((i = cname.lastIndexOf(36)) != -1) {
            if ((i = (cname = cname.substring(0, i)).lastIndexOf(36)) != -1) {
                l.add(cname.substring(i + 1, cname.length()));
                continue;
            }
            i = cname.lastIndexOf(46);
            if (i != -1) {
                l.add(cname.substring(i + 1, cname.length()));
                continue;
            }
            l.add(cname);
        }
        return l;
    }

    protected Class<?> findInnerClass(String s) throws ClassNotFoundException {
        int n;
        while ((n = s.lastIndexOf(46)) != -1) {
            s = new StringBuffer().append(s.substring(0, n)).append('$').append(s.substring(n + 1, s.length())).toString();
            try {
                return Class.forName(s, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(s);
    }

    protected ImportationManager(ImportationManager im) {
        this.importOnDemandClauses = ListUtilities.listCopy(im.importOnDemandClauses);
        this.singleTypeImportClauses = ListUtilities.listCopy(im.singleTypeImportClauses);
        this.importOnDemandStaticClauses = ListUtilities.listCopy(im.importOnDemandStaticClauses);
        this.singleTypeImportStaticFieldClauses = ListUtilities.listCopy(im.singleTypeImportStaticFieldClauses);
        this.singleTypeImportStaticMethodClauses = ListUtilities.listCopy(im.singleTypeImportStaticMethodClauses);
        this.currentPackage = im.currentPackage;
        this.classLoader = im.classLoader;
    }

    protected Method lookupMethod(String name, Class<?>[] params) throws NoSuchMethodException {
        for (Method m : this.singleTypeImportStaticMethodClauses) {
            if (!m.getName().equals(name) || !ReflectionUtilities.hasCompatibleSignatures(m.getParameterTypes(), params)) continue;
            return m;
        }
        for (String className : this.importOnDemandStaticClauses) {
            try {
                Method toReturn = ReflectionUtilities.lookupMethod(this.lookupClass(className, null), name, params);
                return toReturn;
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new NoSuchMethodException(name);
    }

    public String getQualifiedName(String methodName, Class<?>[] args) throws NoSuchMethodException {
        LinkedList toReturn = new LinkedList();
        Method m = this.lookupMethod(methodName, args);
        return m.getDeclaringClass().getName();
    }

    protected boolean hasSuffix(String c1, String c2) {
        return this.suffix(c1).equals(c2);
    }

    protected String suffix(String s) {
        int i = s.lastIndexOf(46);
        String s2 = s;
        if (i != -1) {
            s2 = s.substring(i + 1, s.length());
        }
        return s2;
    }

    protected boolean isPublicAndStatic(int modifiers) {
        return Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
    }

    public boolean fieldExists(String name) {
        try {
            this.lookupField(name);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public Field lookupField(String name) throws NoSuchFieldException {
        for (Field f : this.singleTypeImportStaticFieldClauses) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        for (String className : this.importOnDemandStaticClauses) {
            try {
                Field f;
                f = ReflectionUtilities.getField(this.lookupClass(className, null), name);
                return f;
            }
            catch (NoSuchFieldException nsme) {
            }
            catch (AmbiguousFieldException afe) {
                throw new RuntimeException(new StringBuffer().append("Ambiguous Field exception: Field ").append(name).append(" is ambiguous").toString());
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new NoSuchFieldException(name);
    }

    public List<IdentifierToken> getQualifiedName(String fieldName) throws NoSuchFieldException {
        int i;
        LinkedList<IdentifierToken> toReturn = new LinkedList<IdentifierToken>();
        Field f = this.lookupField(fieldName);
        String toParse = new StringBuffer().append(f.getDeclaringClass().getName()).append(".").append(fieldName).toString();
        if (toParse.startsWith("class ")) {
            toParse = toParse.substring(6, toParse.length());
        }
        while ((i = toParse.lastIndexOf(".")) != -1) {
            toReturn.add(0, new Identifier(toParse.substring(i + 1, toParse.length())));
            toParse = toParse.substring(0, i);
        }
        toReturn.add(0, new Identifier(toParse));
        return toReturn;
    }
}

