/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeDeclaration
extends Node {
    public static final String ACCESS_FLAGS = "accessFlags";
    public static final String NAME = "name";
    public static final String INTERFACES = "interfaces";
    public static final String MEMBERS = "members";
    private int accessFlags;
    private String name;
    private List<String> interfaces;
    private List<Node> members;

    protected TypeDeclaration(int flags, String name, List<? extends ReferenceType> impl, List<Node> body, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.accessFlags = flags;
        this.name = name;
        if (impl != null) {
            this.interfaces = new LinkedList<String>();
            Iterator<? extends ReferenceType> it = impl.iterator();
            while (it.hasNext()) {
                this.interfaces.add(it.next().getRepresentation());
            }
        }
        this.members = body;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int f) {
        this.accessFlags = f;
        this.firePropertyChange(ACCESS_FLAGS, this.accessFlags, this.accessFlags);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> l) {
        this.interfaces = l;
        this.firePropertyChange(INTERFACES, this.interfaces, this.interfaces);
    }

    public List<Node> getMembers() {
        return this.members;
    }

    public void setMembers(List<Node> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.members = l;
        this.firePropertyChange(MEMBERS, this.members, this.members);
    }
}

