/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceType
extends Type {
    public static final String REPRESENTATION = "representation";
    private String representation;

    public ReferenceType(List<IdentifierToken> ids) {
        this(ids, null, 0, 0, 0, 0);
    }

    public ReferenceType(String rep) {
        this(rep, null, 0, 0, 0, 0);
    }

    public ReferenceType(List<IdentifierToken> ids, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (ids == null) {
            throw new IllegalArgumentException("ids == null");
        }
        this.representation = TreeUtilities.listToName(ids);
    }

    public ReferenceType(String rep, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (rep == null) {
            throw new IllegalArgumentException("rep == null");
        }
        this.representation = rep;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.representation = s;
        this.firePropertyChange(REPRESENTATION, this.representation, this.representation);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.toStringHelper()).append(")").toString();
    }

    protected String toStringHelper() {
        return this.getRepresentation();
    }
}

