/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.context.AbstractVariable;
import koala.dynamicjava.interpreter.context.Constant;
import koala.dynamicjava.interpreter.context.SimpleContext;
import koala.dynamicjava.interpreter.context.Variable;
import koala.dynamicjava.util.ImportationManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableContext
implements SimpleContext {
    protected Link scopes;
    protected Scope scope;
    protected Scope cscope;
    protected ImportationManager importationManager;

    protected VariableContext() {
        this.enterScope();
    }

    public VariableContext(Set<AbstractVariable> entries) {
        this();
        Iterator<AbstractVariable> it = entries.iterator();
        while (it.hasNext()) {
            it.next().set(this, null);
        }
    }

    public VariableContext(ImportationManager im) {
        this();
        this.importationManager = im;
    }

    @Override
    public void enterScope() {
        this.scopes = LinkFactory.createLink(this.scopes);
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
    }

    @Override
    public void enterScope(Set<AbstractVariable> entries) {
        this.enterScope();
        Iterator<AbstractVariable> it = entries.iterator();
        while (it.hasNext()) {
            it.next().set(this, null);
        }
    }

    @Override
    public void defineVariables(Set<AbstractVariable> vars) {
        for (AbstractVariable v : vars) {
            if (v.get(this) != Scope.NO_SUCH_KEY) continue;
            v.set(this, null);
        }
    }

    @Override
    public Set<AbstractVariable> leaveScope() {
        Set<AbstractVariable> result = this.getCurrentScopeVariables();
        this.scopes = this.scopes.next;
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
        return result;
    }

    @Override
    public Set<AbstractVariable> getCurrentScopeVariables() {
        HashSet<AbstractVariable> result = new HashSet<AbstractVariable>(11);
        Iterator<String> it = this.scope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Variable(it.next()));
        }
        it = this.cscope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Constant(it.next()));
        }
        return result;
    }

    @Override
    public Set<String> getCurrentScopeVariableNames() {
        HashSet<String> result = new HashSet<String>(11);
        Iterator<String> it = this.scope.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        it = this.cscope.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    @Override
    public boolean isDefinedVariable(String name) {
        Link l = this.scopes;
        while (l != null) {
            if (l.scope.contains(name) || l.cscope.contains(name)) {
                return true;
            }
            l = l.next;
        }
        return false;
    }

    @Override
    public boolean isFinal(String name) {
        Link l = this.scopes;
        while (l != null) {
            if (l.cscope.contains(name)) {
                return true;
            }
            l = l.next;
        }
        return false;
    }

    @Override
    public void define(String name, Object value) {
        if (this.scope.put(name, value) != Scope.NO_SUCH_KEY) {
            throw new IllegalStateException(name);
        }
    }

    @Override
    public void defineConstant(String name, Object value) {
        if (this.cscope.put(name, value) != Scope.NO_SUCH_KEY || this.scope.contains(name)) {
            throw new IllegalStateException(name);
        }
    }

    @Override
    public Object get(String name) {
        Link l = this.scopes;
        while (l != null) {
            Object result = l.scope.get(name);
            if (result != Scope.NO_SUCH_KEY || (result = l.cscope.get(name)) != Scope.NO_SUCH_KEY) {
                return result;
            }
            l = l.next;
        }
        throw new IllegalStateException(name);
    }

    @Override
    public void set(String name, Object value) {
        Link l = this.scopes;
        while (l != null) {
            if (l.scope.contains(name)) {
                l.scope.put(name, value);
                return;
            }
            l = l.next;
        }
        throw new IllegalStateException(name);
    }

    @Override
    public void setConstant(String name, Object value) {
        this.cscope.put(name, value);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.scope.put(name, value);
    }

    @Override
    public Map<String, Object> getConstants() {
        HashMap<String, Object> result = new HashMap<String, Object>(11);
        Link l = this.scopes;
        while (l != null) {
            for (String s : l.cscope.keySet()) {
                result.put(s, l.cscope.get(s));
            }
            l = l.next;
        }
        return result;
    }

    @Override
    public void setRevertPoint() {
        this.scope.setRevertPoint();
        this.cscope.setRevertPoint();
    }

    @Override
    public void revert() {
        this.scope.revert();
        this.cscope.revert();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Scope {
        protected HashMap<String, Object> _table = new HashMap(11, 0.75f);
        protected LinkedList<String> _addedKeys = new LinkedList();
        public static final Object NO_SUCH_KEY = new Object();

        public Object get(String key) {
            if (this._table.containsKey(key)) {
                return this._table.get(key);
            }
            return NO_SUCH_KEY;
        }

        public boolean contains(String key) {
            return this._table.containsKey(key);
        }

        public Object put(String key, Object value) {
            boolean wasThere = this._table.containsKey(key);
            Object val = this._table.put(key, value);
            this._addedKeys.add(key);
            return wasThere ? val : NO_SUCH_KEY;
        }

        public Set<String> keySet() {
            return this._table.keySet();
        }

        public void clear() {
            this._table.clear();
            this._addedKeys.clear();
        }

        public void revert() {
            for (String key : this._addedKeys) {
                this._table.remove(key);
            }
            this._addedKeys.clear();
        }

        public void setRevertPoint() {
            this._addedKeys.clear();
        }
    }

    protected static class LinkFactory {
        protected static final int SIZE = 10;
        protected static final WeakReference[] links = new WeakReference[10];

        protected LinkFactory() {
        }

        public static Link createLink(Link next) {
            return new Link(next);
        }

        public static void recycle(Link l) {
        }
    }

    protected static class Link {
        public Scope scope = new Scope();
        public Scope cscope = new Scope();
        public Link next;

        public Link(Link next) {
            this.next = next;
        }
    }
}

