/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TypeDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeClassLoader
extends SecureClassLoader
implements ClassLoaderContainer {
    public static String DEFAULT_CODE_SOURCE_URL = "http://koala.ilog.fr/djava/javadoc/koala/dynamicjava/interpreter/TreeClassLoader.html";
    public static String CODE_SOURCE_URL_PROPERTY = "koala.dynamicjava.interpreter.TreeClassLoader.codesource.url";
    protected static CodeSource codeSource;
    protected Map<String, Class> classes = new HashMap<String, Class>(11);
    protected Map<String, Node> trees = new HashMap<String, Node>(11);
    protected Interpreter interpreter;
    protected ClassLoader classLoader;

    public TreeClassLoader(Interpreter i) {
        this(i, null);
    }

    public TreeClassLoader(Interpreter i, ClassLoader cl) {
        super(i.getClass().getClassLoader());
        this.interpreter = i;
        this.classLoader = cl;
    }

    public Class<?> defineClass(String name, byte[] code) {
        Class<?> c = this.defineClass(name, code, 0, code.length, codeSource);
        this.classes.put(name, c);
        this.trees.remove(name);
        return c;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean hasDefined(String name) {
        return this.classes.containsKey(name);
    }

    public Set getClassNames() {
        return this.classes.keySet();
    }

    public void addTree(String name, TypeDeclaration node) {
        this.trees.put(name, node);
    }

    public TypeDeclaration getTree(String name) {
        return (TypeDeclaration)this.trees.get(name);
    }

    public void addURL(URL url) {
        this.classLoader = new URLClassLoader(new URL[]{url}, this.classLoader);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        try {
            if (this.classLoader != null) {
                return Class.forName(name, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.interpreter.loadClass(name);
    }

    static {
        try {
            String url = System.getProperty(CODE_SOURCE_URL_PROPERTY);
            if (url != null) {
                codeSource = new CodeSource(new URL(url), (Certificate[])null);
            }
        }
        catch (MalformedURLException mfue) {
            codeSource = new CodeSource(null, (Certificate[])null);
        }
        try {
            codeSource = new CodeSource(new URL(DEFAULT_CODE_SOURCE_URL), (Certificate[])null);
        }
        catch (MalformedURLException mfue) {
            throw new RuntimeException(mfue.getMessage());
        }
    }
}

