/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import koala.dynamicjava.interpreter.AbstractTypeChecker;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.UninitializedObject;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.context.MethodModificationError;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.modifier.VariableModifier;
import koala.dynamicjava.interpreter.throwable.BreakException;
import koala.dynamicjava.interpreter.throwable.ContinueException;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BooleanType;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.IntType;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.tiger.generic.GenericReferenceType;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationVisitor
extends VisitorObject<Object> {
    private Context context;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Array;
    static /* synthetic */ Class class$java$lang$Character;

    public EvaluationVisitor(Context ctx) {
        this.context = ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(WhileStatement node) {
        try {
            while (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
                try {
                    node.getBody().acceptVisitor(this);
                }
                catch (ContinueException e) {
                    if (!e.isLabeled() || node.hasLabel(e.getLabel())) continue;
                    throw e;
                    return null;
                }
            }
        }
        catch (BreakException e) {
            if (!e.isLabeled() || node.hasLabel(e.getLabel())) return null;
            throw e;
        }
    }

    @Override
    public Object visit(ForEachStatement node) {
        Node statement1;
        LinkedList<IdentifierToken> listForQualifiedName;
        Expression condition;
        LinkedList<IdentifierToken> listForQualifiedName2;
        Identifier newforcounter;
        Method m;
        Class<?> c;
        VariableDeclaration init;
        PrimaryExpression exp;
        Set vars = (Set)node.getProperty("variables");
        this.context.enterScope(vars);
        FormalParameter formalparam = node.getParameter();
        Expression collection = node.getCollection();
        Class<?> collTypeClass = NodeProperties.getType(collection);
        Node body = node.getBody();
        if (collTypeClass.isArray()) {
            exp = new IntegerLiteral("0");
            exp.setProperty("type", Integer.TYPE);
            init = new VariableDeclaration(false, new IntType(), node.getVars().get(0), exp);
            c = NodeProperties.getType(exp);
            init.setProperty("type", c);
            init.getType().setProperty("type", c);
        } else {
            exp = new ObjectMethodCall(node.getCollection(), "iterator", null, "", 0, 0, 0, 0);
            m = null;
            try {
                m = this.context.lookupMethod(((ObjectMethodCall)exp).getExpression(), "iterator", Constants.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
            }
            catch (MethodModificationError e) {
                // empty catch block
            }
            exp.setProperty("method", m);
            exp.setProperty("type", m.getReturnType());
            Identifier javaId = new Identifier("java");
            Identifier utilId = new Identifier("util");
            Identifier iteratorId = new Identifier("Iterator");
            LinkedList<IdentifierToken> ids = new LinkedList<IdentifierToken>();
            ids.add(javaId);
            ids.add(utilId);
            ids.add(iteratorId);
            LinkedList<List<? extends Type>> typeArgs = new LinkedList<List<? extends Type>>();
            LinkedList<Type> arg1 = new LinkedList<Type>();
            arg1.add(formalparam.getType());
            typeArgs.add(arg1);
            init = new VariableDeclaration(false, new GenericReferenceType(ids, typeArgs), node.getVars().get(0), exp);
            c = NodeProperties.getType(exp);
            init.setProperty("type", c);
            init.getType().setProperty("type", c);
        }
        init.acceptVisitor(this);
        if (collTypeClass.isArray()) {
            newforcounter = new Identifier(node.getVars().get(0));
            listForQualifiedName2 = new LinkedList<IdentifierToken>();
            listForQualifiedName2.add(newforcounter);
            QualifiedName lhs = new QualifiedName(listForQualifiedName2);
            LinkedList<Expression> argsToGetLength = new LinkedList<Expression>();
            argsToGetLength.add(collection);
            ArrayType art = new ArrayType(formalparam.getType(), 1);
            StaticMethodCall rhs = new StaticMethodCall(art, "getLength", argsToGetLength);
            m = null;
            try {
                Class[] lookupArgs = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = EvaluationVisitor.class$("java.lang.Object")) : class$java$lang$Object};
                m = (class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = EvaluationVisitor.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array).getMethod("getLength", lookupArgs);
            }
            catch (NoSuchMethodException e) {
            }
            catch (MethodModificationError e) {
                // empty catch block
            }
            rhs.setProperty("method", m);
            rhs.setProperty("type", m.getReturnType());
            condition = new LessExpression(lhs, rhs);
            condition.setProperty("type", new BooleanType());
        } else {
            newforcounter = new Identifier(node.getVars().get(0));
            listForQualifiedName2 = new LinkedList();
            listForQualifiedName2.add(newforcounter);
            QualifiedName qf = new QualifiedName(listForQualifiedName2);
            condition = new ObjectMethodCall(qf, "hasNext", null, "", 0, 0, 0, 0);
            Method m2 = null;
            try {
                m2 = this.context.lookupMethod(exp, "hasNext", Constants.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
            }
            catch (MethodModificationError e) {
                // empty catch block
            }
            condition.setProperty("method", m2);
            condition.setProperty("type", m2.getReturnType());
        }
        SimpleAssignExpression assignment = null;
        if (collTypeClass.isArray()) {
            Identifier counterName = new Identifier(node.getVars().get(0));
            listForQualifiedName = new LinkedList<IdentifierToken>();
            listForQualifiedName.add(counterName);
            QualifiedName arg = new QualifiedName(listForQualifiedName);
            VariableModifier mod = new VariableModifier(arg, Integer.TYPE);
            arg.setProperty("modifier", mod);
            statement1 = new AddAssignExpression(arg, new IntegerLiteral("1"));
            statement1.setProperty("type", Integer.TYPE);
            ArrayAccess arrayaccess = new ArrayAccess(collection, arg);
            listForQualifiedName = new LinkedList();
            listForQualifiedName.add(new Identifier(formalparam.getName()));
            arg = new QualifiedName(listForQualifiedName);
            mod = new VariableModifier(arg, collTypeClass.getComponentType());
            arg.setProperty("modifier", mod);
            assignment = new SimpleAssignExpression(arg, arrayaccess);
            assignment.setProperty("type", collTypeClass.getComponentType());
        } else {
            Identifier newforcounter2 = new Identifier(node.getVars().get(0));
            listForQualifiedName = new LinkedList();
            listForQualifiedName.add(newforcounter2);
            QualifiedName qf = new QualifiedName(listForQualifiedName);
            ObjectMethodCall next = new ObjectMethodCall(qf, "next", null, "", 0, 0, 0, 0);
            Method m3 = null;
            try {
                m3 = this.context.lookupMethod(exp, "next", Constants.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
            }
            catch (MethodModificationError e) {
                // empty catch block
            }
            next.setProperty("method", m3);
            next.setProperty("type", m3.getReturnType());
            statement1 = new VariableDeclaration(formalparam.isFinal(), formalparam.getType(), formalparam.getName(), next);
            statement1.setProperty("type", NodeProperties.getType(next));
            c = NodeProperties.getType(next);
            statement1.setProperty("type", c);
            ((VariableDeclaration)statement1).getType().setProperty("type", c);
        }
        while (((Boolean)condition.acceptVisitor(this)).booleanValue()) {
            if (assignment != null) {
                ((Node)assignment).acceptVisitor(this);
            }
            statement1.acceptVisitor(this);
            body.acceptVisitor(this);
        }
        this.context.leaveScope();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ForStatement node) {
        try {
            Set vars = (Set)node.getProperty("variables");
            this.context.enterScope(vars);
            if (node.getInitialization() != null) {
                Iterator<Node> it = node.getInitialization().iterator();
                while (it.hasNext()) {
                    it.next().acceptVisitor(this);
                }
            }
            try {
                Expression cond = node.getCondition();
                List<Node> update = node.getUpdate();
                while (cond == null || ((Boolean)cond.acceptVisitor(this)).booleanValue()) {
                    block12: {
                        try {
                            node.getBody().acceptVisitor(this);
                        }
                        catch (ContinueException e) {
                            if (!e.isLabeled() || node.hasLabel(e.getLabel())) break block12;
                            throw e;
                        }
                    }
                    if (update == null) continue;
                    Iterator<Node> it = update.iterator();
                    while (it.hasNext()) {
                        it.next().acceptVisitor(this);
                    }
                }
            }
            catch (BreakException e) {
                if (e.isLabeled() && !node.hasLabel(e.getLabel())) {
                    throw e;
                }
            }
        }
        finally {
            this.context.leaveScope();
        }
        return null;
    }

    @Override
    public Object visit(DoStatement node) {
        block5: {
            try {
                do {
                    try {
                        node.getBody().acceptVisitor(this);
                    }
                    catch (ContinueException e) {
                        if (!e.isLabeled() || node.hasLabel(e.getLabel())) continue;
                        throw e;
                    }
                } while (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue());
            }
            catch (BreakException e) {
                if (!e.isLabeled() || node.hasLabel(e.getLabel())) break block5;
                throw e;
            }
        }
        return null;
    }

    @Override
    public Object visit(SwitchStatement node) {
        try {
            SwitchBlock sc;
            boolean processed = false;
            Object o = node.getSelector().acceptVisitor(this);
            if (o instanceof Character) {
                o = new Integer(((Character)o).charValue());
            }
            Class<?> EnumClass = TigerUtilities.isTigerEnabled() ? Class.forName("java.lang.Enum") : null;
            Object sel = TigerUtilities.isTigerEnabled() && o.getClass().getSuperclass() == EnumClass ? o : (Number)o;
            ListIterator<SwitchBlock> it = node.getBindings().listIterator();
            ListIterator<SwitchBlock> dit = null;
            block4: while (it.hasNext()) {
                sc = it.next();
                Object bind = null;
                if (sc.getExpression() != null) {
                    o = sc.getExpression().acceptVisitor(this);
                    if (o instanceof Character) {
                        o = new Integer(((Character)o).charValue());
                    }
                    bind = TigerUtilities.isTigerEnabled() && o.getClass().getSuperclass() == EnumClass ? o : (Number)o;
                } else {
                    dit = node.getBindings().listIterator(it.nextIndex() - 1);
                }
                if ((bind == null || !(sel instanceof Number) || ((Number)sel).intValue() != ((Number)bind).intValue()) && (!TigerUtilities.isTigerEnabled() || sel.getClass().getSuperclass() != EnumClass || !sel.equals(bind))) continue;
                processed = true;
                while (true) {
                    if (sc.getStatements() != null) {
                        Iterator<Node> it2 = sc.getStatements().iterator();
                        while (it2.hasNext()) {
                            it2.next().acceptVisitor(this);
                        }
                    }
                    if (!it.hasNext()) break block4;
                    sc = it.next();
                }
            }
            if (!processed && dit != null) {
                sc = (SwitchBlock)dit.next();
                while (true) {
                    if (sc.getStatements() != null) {
                        Iterator<Node> it2 = sc.getStatements().iterator();
                        while (it2.hasNext()) {
                            it2.next().acceptVisitor(this);
                        }
                    }
                    if (dit.hasNext()) {
                        sc = (SwitchBlock)dit.next();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (BreakException e) {
            if (e.isLabeled()) {
                throw e;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionError("Tiger is enabled, but cannot find class java.lang.Enum! Please contact the DynamicJava/DrJava team (javaplt@cs.rice.edu).");
        }
        catch (NoClassDefFoundError e) {
            throw new ExecutionError("Tiger is enabled, but cannot find class java.lang.Enum! Please contact the DynamicJava/DrJava team (javaplt@cs.rice.edu).");
        }
        return null;
    }

    @Override
    public Object visit(LabeledStatement node) {
        block2: {
            try {
                node.getStatement().acceptVisitor(this);
            }
            catch (BreakException e) {
                if (e.isLabeled() && e.getLabel().equals(node.getLabel())) break block2;
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(SynchronizedStatement node) {
        Object object = node.getLock().acceptVisitor(this);
        synchronized (object) {
            node.getBody().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(BreakStatement node) {
        throw new BreakException("unexpected.break", node.getLabel());
    }

    @Override
    public Object visit(ContinueStatement node) {
        throw new ContinueException("unexpected.continue", node.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(TryStatement node) {
        boolean handled = false;
        try {
            node.getTryBlock().acceptVisitor(this);
        }
        catch (Throwable e) {
            Throwable t = e;
            if (e instanceof ThrownException) {
                t = ((ThrownException)e).getException();
            } else if (e instanceof CatchedExceptionError) {
                t = ((CatchedExceptionError)e).getException();
            }
            for (CatchStatement cs : node.getCatchStatements()) {
                Class<?> c = NodeProperties.getType(cs.getException().getType());
                if (!c.isAssignableFrom(t.getClass())) continue;
                handled = true;
                this.context.enterScope();
                this.context.define(cs.getException().getName(), t);
                cs.getBlock().acceptVisitor(this);
                break;
            }
            if (!handled) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CatchedExceptionError((Exception)e, (Node)node);
            }
        }
        finally {
            Node n;
            if (handled) {
                this.context.leaveScope();
            }
            if ((n = node.getFinallyBlock()) != null) {
                n.acceptVisitor(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(ThrowStatement node) {
        throw new ThrownException((Throwable)node.getExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(ReturnStatement node) {
        if (node.getExpression() != null) {
            throw new ReturnException("return.statement", node.getExpression().acceptVisitor(this), node);
        }
        throw new ReturnException("return.statement", node);
    }

    @Override
    public Object visit(IfThenStatement node) {
        if (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(IfThenElseStatement node) {
        if (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        } else {
            node.getElseStatement().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(AssertStatement node) {
        if (!((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
            String toThrow = "";
            Expression n = node.getFailString();
            if (n != null) {
                toThrow = n.acceptVisitor(this).toString();
            }
            throw new AssertionError((Object)toThrow);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(BlockStatement node) {
        try {
            Set vars = (Set)node.getProperty("variables");
            this.context.enterScope(vars);
            Iterator<Node> it = node.getStatements().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        finally {
            this.context.leaveScope();
        }
        return null;
    }

    @Override
    public Object visit(Literal node) {
        return node.getValue();
    }

    @Override
    public Object visit(VariableDeclaration node) {
        Class<?> c = NodeProperties.getType(node.getType());
        if (node.getInitializer() != null) {
            Object o = EvaluationVisitor.performCast(c, node.getInitializer().acceptVisitor(this));
            if (node.isFinal()) {
                this.context.setConstant(node.getName(), o);
            } else {
                this.context.set(node.getName(), o);
            }
        } else if (node.isFinal()) {
            this.context.setConstant(node.getName(), UninitializedObject.INSTANCE);
        } else {
            this.context.set(node.getName(), UninitializedObject.INSTANCE);
        }
        return null;
    }

    @Override
    public Object visit(ObjectFieldAccess node) {
        Class<?> c = NodeProperties.getType(node.getExpression());
        Object obj = node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            Field f = (Field)node.getProperty("field");
            if (this.context.getAccessible()) {
                f.setAccessible(true);
            }
            try {
                return f.get(obj);
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return new Integer(Array.getLength(obj));
    }

    private Object buildArrayOfRemainingArgs(Class<?>[] typs, int larg_size, Iterator<Expression> it) {
        if (!typs[typs.length - 1].isArray()) {
            throw new RuntimeException("Last argument is not variable arguments");
        }
        Class<?> componentType = typs[typs.length - 1].getComponentType();
        Object argArray = Array.newInstance(componentType, new int[]{larg_size - typs.length + 1});
        int n = larg_size - typs.length + 1;
        for (int j = 0; j < n; ++j) {
            Object p = it.next().acceptVisitor(this);
            Object casted = EvaluationVisitor.performCast(componentType, p);
            if (componentType.isPrimitive()) {
                if (componentType == Boolean.TYPE && casted instanceof Boolean) {
                    Array.setBoolean(argArray, j, (Boolean)casted);
                    continue;
                }
                if (componentType == Character.TYPE && casted instanceof Character) {
                    Array.setChar(argArray, j, ((Character)casted).charValue());
                    continue;
                }
                if (casted instanceof Number) {
                    if (componentType == Character.TYPE) {
                        Array.setChar(argArray, j, (char)((Number)casted).intValue());
                        continue;
                    }
                    if (componentType == Byte.TYPE) {
                        Array.setByte(argArray, j, ((Number)casted).byteValue());
                        continue;
                    }
                    if (componentType == Short.TYPE) {
                        Array.setShort(argArray, j, ((Number)casted).shortValue());
                        continue;
                    }
                    if (componentType == Integer.TYPE) {
                        Array.setInt(argArray, j, ((Number)casted).intValue());
                        continue;
                    }
                    if (componentType == Long.TYPE) {
                        Array.setLong(argArray, j, ((Number)casted).longValue());
                        continue;
                    }
                    if (componentType == Float.TYPE) {
                        Array.setFloat(argArray, j, ((Number)casted).floatValue());
                        continue;
                    }
                    Array.setDouble(argArray, j, ((Number)casted).doubleValue());
                    continue;
                }
                throw new ClassCastException(new StringBuffer().append("Cannot insert object of type ").append(casted.getClass()).append(" into primitive array").toString());
            }
            Array.set(argArray, j, casted);
        }
        return argArray;
    }

    @Override
    public Object visit(ObjectMethodCall node) {
        Expression exp = node.getExpression();
        Object obj = exp.acceptVisitor(this);
        if (node.hasProperty("method")) {
            Method m = (Method)node.getProperty("method");
            Class<?>[] typs = m.getParameterTypes();
            if (this.context.getAccessible()) {
                m.setAccessible(true);
            }
            List<Expression> larg = node.getArguments();
            Object[] args = Constants.EMPTY_OBJECT_ARRAY;
            if (larg != null) {
                int i;
                args = new Object[typs.length];
                ListIterator<Expression> it = larg.listIterator();
                for (i = 0; i < typs.length - 1; ++i) {
                    Object p = it.next().acceptVisitor(this);
                    args[i] = EvaluationVisitor.performCast(typs[i], p);
                }
                if (typs.length > 0) {
                    Object last = null;
                    if (it.hasNext()) {
                        last = it.next().acceptVisitor(this);
                    }
                    if (!TigerUtilities.isVarArgs(m)) {
                        args[i] = last;
                    } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                        args[i] = last;
                    } else {
                        it.previous();
                        args[i] = this.buildArrayOfRemainingArgs(typs, larg.size(), it);
                    }
                }
            } else if (TigerUtilities.isVarArgs(m) && typs.length == 1) {
                Class<?> compType = typs[0].getComponentType();
                args = new Object[]{Array.newInstance(compType, 0)};
            }
            try {
                return m.invoke(obj, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new ThrownException(e.getTargetException(), (Node)node);
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        Class<?> c = NodeProperties.getType(exp);
        int len = Array.getLength(obj);
        Object result = Array.newInstance(c.getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, Array.get(obj, i));
        }
        return result;
    }

    @Override
    public Object visit(StaticFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        try {
            return f.get(null);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object visit(SuperFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        try {
            return f.get(this.context.getHiddenArgument());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object visit(SuperMethodCall node) {
        Method m = (Method)node.getProperty("method");
        List<Expression> larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        Class<?>[] typs = m.getParameterTypes();
        if (larg != null) {
            int i;
            ListIterator<Expression> it = larg.listIterator();
            args = new Object[typs.length];
            for (i = 0; i < typs.length - 1; ++i) {
                args[i] = it.next().acceptVisitor(this);
            }
            if (typs.length > 0) {
                Object last = null;
                if (it.hasNext()) {
                    last = it.next().acceptVisitor(this);
                }
                if (!TigerUtilities.isVarArgs(m)) {
                    args[i] = last;
                } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                    args[i] = last;
                } else {
                    it.previous();
                    args[i] = this.buildArrayOfRemainingArgs(typs, larg.size(), it);
                }
            }
        } else if (TigerUtilities.isVarArgs(m) && typs.length == 1) {
            Class<?> compType = typs[0].getComponentType();
            args = new Object[]{Array.newInstance(compType, 0)};
        }
        try {
            return m.invoke(this.context.getHiddenArgument(), args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object visit(StaticMethodCall node) {
        Method m = (Method)node.getProperty("method");
        List<Expression> larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        Class<?>[] typs = m.getParameterTypes();
        if (larg != null) {
            int i;
            args = new Object[typs.length];
            ListIterator<Expression> it = larg.listIterator();
            for (i = 0; i < typs.length - 1; ++i) {
                args[i] = it.next().acceptVisitor(this);
            }
            if (typs.length > 0) {
                Object last = null;
                if (it.hasNext()) {
                    last = it.next().acceptVisitor(this);
                }
                if (!TigerUtilities.isVarArgs(m)) {
                    args[i] = last;
                } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                    args[i] = last;
                } else {
                    it.previous();
                    args[i] = this.buildArrayOfRemainingArgs(typs, larg.size(), it);
                }
            }
        } else if (TigerUtilities.isVarArgs(m) && typs.length == 1) {
            Class<?> compType = typs[0].getComponentType();
            args = new Object[]{Array.newInstance(compType, 0)};
        }
        try {
            return m.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object visit(SimpleAssignExpression node) {
        Expression ln = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(ln);
        mod.prepare(this, this.context);
        Object val = node.getRightExpression().acceptVisitor(this);
        val = EvaluationVisitor.performCast(NodeProperties.getType(node), val);
        mod.modify(this.context, val);
        return val;
    }

    @Override
    public Object visit(QualifiedName node) {
        Object result = this.context.get(node.getRepresentation());
        if (result == UninitializedObject.INSTANCE) {
            node.setProperty("errorStrings", new String[]{node.getRepresentation()});
            throw new ExecutionError("uninitialized.variable", node);
        }
        return result;
    }

    @Override
    public Object visit(TypeExpression node) {
        return node.getProperty("value");
    }

    @Override
    public Object visit(SimpleAllocation node) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        List<Expression> larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        Class<?>[] typs = cons.getParameterTypes();
        if (larg != null) {
            args = new Object[typs.length];
            ListIterator<Expression> it = larg.listIterator();
            int i = 0;
            while (i < typs.length - 1) {
                args[i++] = it.next().acceptVisitor(this);
            }
            if (typs.length > 0) {
                Object last = null;
                if (it.hasNext()) {
                    last = it.next().acceptVisitor(this);
                }
                if (!TigerUtilities.isVarArgs(cons)) {
                    args[i] = last;
                } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                    args[i] = last;
                } else {
                    it.previous();
                    args[i] = this.buildArrayOfRemainingArgs(typs, larg.size(), it);
                }
            }
        } else if (TigerUtilities.isVarArgs(cons) && typs.length == 1) {
            Class<?> compType = typs[0].getComponentType();
            args = new Object[]{Array.newInstance(compType, 0)};
        }
        return this.context.invokeConstructor(node, args);
    }

    @Override
    public Object visit(ArrayAllocation node) {
        if (node.getInitialization() != null) {
            return node.getInitialization().acceptVisitor(this);
        }
        int[] dims = new int[node.getSizes().size()];
        Iterator<Expression> it = node.getSizes().iterator();
        int i = 0;
        while (it.hasNext()) {
            Number n = (Number)it.next().acceptVisitor(this);
            dims[i++] = n.intValue();
        }
        if (node.getDimension() != dims.length) {
            Class<?> c = NodeProperties.getComponentType(node);
            c = Array.newInstance(c, 0).getClass();
            return Array.newInstance(c, dims);
        }
        return Array.newInstance(NodeProperties.getComponentType(node), dims);
    }

    @Override
    public Object visit(ArrayInitializer node) {
        Object result = Array.newInstance(NodeProperties.getType(node.getElementType()), node.getCells().size());
        Iterator<Expression> it = node.getCells().iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next().acceptVisitor(this);
            Array.set(result, i++, o);
        }
        return result;
    }

    @Override
    public Object visit(ArrayAccess node) {
        Object t = node.getExpression().acceptVisitor(this);
        Object o = node.getCellNumber().acceptVisitor(this);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        return Array.get(t, ((Number)o).intValue());
    }

    @Override
    public Object visit(InnerAllocation node) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        Class<?> c = NodeProperties.getType(node);
        List<Expression> larg = node.getArguments();
        Object[] args = null;
        Class<?>[] typs = cons.getParameterTypes();
        if (larg != null) {
            args = new Object[typs.length];
            args[0] = node.getExpression().acceptVisitor(this);
            ListIterator<Expression> it = larg.listIterator();
            int i = 1;
            while (i < typs.length - 1) {
                args[i++] = it.next().acceptVisitor(this);
            }
            if (typs.length > 0) {
                Object last = null;
                if (it.hasNext()) {
                    last = it.next().acceptVisitor(this);
                }
                if (!TigerUtilities.isVarArgs(cons)) {
                    args[i] = last;
                } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                    args[i] = last;
                } else {
                    it.previous();
                    args[i] = this.buildArrayOfRemainingArgs(typs, larg.size() + 1, it);
                }
            }
        } else if (TigerUtilities.isVarArgs(cons) && typs.length == 1) {
            Class<?> compType = typs[0].getComponentType();
            args = new Object[]{node.getExpression().acceptVisitor(this), Array.newInstance(compType, 0)};
        } else {
            args = new Object[]{node.getExpression().acceptVisitor(this)};
        }
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object visit(ClassAllocation node) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        List<Expression> larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        Class<?>[] typs = cons.getParameterTypes();
        if (larg != null) {
            args = new Object[typs.length];
            ListIterator<Expression> it = larg.listIterator();
            int i = 0;
            while (i < typs.length - 1) {
                args[i++] = it.next().acceptVisitor(this);
            }
            if (typs.length > 0) {
                Object last = null;
                if (it.hasNext()) {
                    last = it.next().acceptVisitor(this);
                }
                if (!TigerUtilities.isVarArgs(cons)) {
                    args[i] = last;
                } else if (last != null && typs[i].isAssignableFrom(last.getClass())) {
                    args[i] = last;
                } else {
                    it.previous();
                    args[i] = this.buildArrayOfRemainingArgs(typs, larg.size(), it);
                }
            }
        } else if (TigerUtilities.isVarArgs(cons) && typs.length == 1) {
            Class<?> compType = typs[0].getComponentType();
            args = new Object[]{Array.newInstance(compType, 0)};
        }
        return this.context.invokeConstructor(node, args);
    }

    @Override
    public Object visit(NotExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Boolean b = (Boolean)node.getExpression().acceptVisitor(this);
        if (b.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Object visit(ComplementExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Class<?> c = NodeProperties.getType(node);
        Object o = node.getExpression().acceptVisitor(this);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(~((Number)o).intValue());
        }
        return new Long(((Number)o).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Object visit(PlusExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.plus(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(MinusExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.minus(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(AddExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.add(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(AddAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.add(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(SubtractExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.subtract(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(SubtractAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.subtract(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(MultiplyExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.multiply(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(MultiplyAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.multiply(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(DivideExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.divide(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(DivideAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.divide(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(RemainderExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.remainder(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(RemainderAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.remainder(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(EqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.equalTo(NodeProperties.getType(ln), NodeProperties.getType(rn), ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(NotEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.notEqualTo(NodeProperties.getType(ln), NodeProperties.getType(rn), ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(LessExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.lessThan(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(LessOrEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.lessOrEqual(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(GreaterExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.greaterThan(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(GreaterOrEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.greaterOrEqual(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    @Override
    public Object visit(InstanceOfExpression node) {
        Object v = node.getExpression().acceptVisitor(this);
        Class<?> c = NodeProperties.getType(node.getReferenceType());
        return c.isInstance(v) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(ConditionalExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Boolean b = (Boolean)node.getConditionExpression().acceptVisitor(this);
        if (b.booleanValue()) {
            return node.getIfTrueExpression().acceptVisitor(this);
        }
        return node.getIfFalseExpression().acceptVisitor(this);
    }

    @Override
    public Object visit(PostIncrement node) {
        Class<?> resType;
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.add(calcType, v, InterpreterUtilities.ONE);
        mod.modify(this.context, result);
        return v;
    }

    @Override
    public Object visit(PreIncrement node) {
        Class<?> resType;
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.add(calcType, v, InterpreterUtilities.ONE);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(PostDecrement node) {
        Class<?> resType;
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.subtract(calcType, v, InterpreterUtilities.ONE);
        mod.modify(this.context, result);
        return v;
    }

    @Override
    public Object visit(PreDecrement node) {
        Class<?> resType;
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.subtract(calcType, v, InterpreterUtilities.ONE);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(CastExpression node) {
        return EvaluationVisitor.performCast(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(BitAndExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.bitAnd(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(BitAndAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.bitAnd(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        NodeProperties.getModifier(left).modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(ExclusiveOrExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.xOr(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(ExclusiveOrAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.xOr(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(BitOrExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.bitOr(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(BitOrAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.bitOr(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(ShiftLeftExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.shiftLeft(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(ShiftLeftAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.shiftLeft(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(ShiftRightExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.shiftRight(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(ShiftRightAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.shiftRight(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(UnsignedShiftRightExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    @Override
    public Object visit(UnsignedShiftRightAssignExpression node) {
        Class<?> resType;
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object rhs = node.getRightExpression().acceptVisitor(this);
        Class<?> calcType = resType = NodeProperties.getType(node);
        if (TigerUtilities.isBoxingType(resType)) {
            calcType = TigerUtilities.correspondingPrimType(resType);
        }
        Object result = InterpreterUtilities.unsignedShiftRight(calcType, lhs, rhs);
        result = EvaluationVisitor.performCast(calcType, result);
        mod.modify(this.context, result);
        return result;
    }

    @Override
    public Object visit(AndExpression node) {
        Expression exp = node.getLeftExpression();
        boolean b = (Boolean)exp.acceptVisitor(this);
        if (b) {
            exp = node.getRightExpression();
            b = (Boolean)exp.acceptVisitor(this);
            return b ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object visit(OrExpression node) {
        Expression exp = node.getLeftExpression();
        boolean b = (Boolean)exp.acceptVisitor(this);
        if (!b) {
            exp = node.getRightExpression();
            b = (Boolean)exp.acceptVisitor(this);
            return b ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Object visit(FunctionCall node) {
        BlockStatement body;
        FormalParameter fp;
        MethodDeclaration md = (MethodDeclaration)node.getProperty("function");
        List<Expression> larg = node.getArguments();
        if (md.isVarArgs()) {
            if (larg == null) {
                ArrayInitializer array = new ArrayInitializer(new LinkedList<Expression>());
                LinkedList<Expression> le = new LinkedList<Expression>();
                List<FormalParameter> lfp = md.getParameters();
                Iterator<FormalParameter> itfp = lfp.iterator();
                if (!itfp.hasNext()) {
                    throw new IllegalStateException("Variable Arguments function does not have a formal parameter list");
                }
                array.setElementType(itfp.next().getType());
                le.add(array);
                node.setArguments(le);
            } else {
                Iterator<FormalParameter> params = md.getParameters().iterator();
                Iterator<Expression> args = larg.iterator();
                LinkedList<Expression> le = new LinkedList<Expression>();
                fp = null;
                while (params.hasNext()) {
                    fp = params.next();
                    if (!params.hasNext()) continue;
                    le.add(args.next());
                }
                LinkedList<Expression> cells = new LinkedList<Expression>();
                while (args.hasNext()) {
                    cells.add(args.next());
                }
                ArrayInitializer array = new ArrayInitializer(cells);
                Type t = fp.getType();
                if (!(t instanceof ArrayType)) {
                    throw new IllegalStateException("Varargs method does not have an array type for its final parameter");
                }
                array.setElementType(((ArrayType)t).getElementType());
                le.add(array);
                node.setArguments(le);
            }
        }
        GlobalContext c = new GlobalContext(this.context.getInterpreter());
        if (node.getArguments() != null) {
            Iterator<FormalParameter> it1 = md.getParameters().iterator();
            Iterator<Expression> it2 = node.getArguments().iterator();
            while (it1.hasNext()) {
                fp = it1.next();
                if (fp.isFinal()) {
                    c.setConstant(fp.getName(), it2.next().acceptVisitor(this));
                    continue;
                }
                c.setVariable(fp.getName(), it2.next().acceptVisitor(this));
            }
        }
        if (!(body = md.getBody()).hasProperty("visited")) {
            body.setProperty("visited", null);
            ImportationManager im = (ImportationManager)md.getProperty("importationManager");
            GlobalContext ctx = new GlobalContext(this.context.getInterpreter());
            ctx.setImportationManager(im);
            NameVisitor nv = new NameVisitor(ctx, ctx);
            Iterator<FormalParameter> it = md.getParameters().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(nv);
            }
            ((Node)body).acceptVisitor(nv);
            ctx = new GlobalContext(this.context.getInterpreter());
            ctx.setImportationManager(im);
            ctx.setFunctions((List)md.getProperty("functions"));
            AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(ctx);
            it = md.getParameters().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(tc);
            }
            ((Node)body).acceptVisitor(tc);
        }
        List<FormalParameter> params = md.getParameters();
        Iterator<FormalParameter> itParam = params.iterator();
        Class[] typs = new Class[params.size()];
        int i = 0;
        while (itParam.hasNext()) {
            typs[i++] = (Class)itParam.next().getProperty("type");
        }
        try {
            ((Node)body).acceptVisitor(new EvaluationVisitor(c));
        }
        catch (ReturnException e) {
            return e.getValue();
        }
        return null;
    }

    protected static Object performCast(Class<?> tc, Object o) {
        if (o == null || !tc.isPrimitive()) {
            return o;
        }
        Class<?> oc = o.getClass();
        if (oc == (class$java$lang$Character == null ? (class$java$lang$Character = EvaluationVisitor.class$("java.lang.Character")) : class$java$lang$Character)) {
            return EvaluationVisitor.performCast(tc, new Integer(((Character)o).charValue()));
        }
        if (tc == Byte.TYPE) {
            return new Byte(((Number)o).byteValue());
        }
        if (tc == Short.TYPE) {
            return new Short(((Number)o).shortValue());
        }
        if (tc == Integer.TYPE) {
            return new Integer(((Number)o).intValue());
        }
        if (tc == Long.TYPE) {
            return new Long(((Number)o).longValue());
        }
        if (tc == Float.TYPE) {
            return new Float(((Number)o).floatValue());
        }
        if (tc == Double.TYPE) {
            return new Double(((Number)o).doubleValue());
        }
        if (tc == Character.TYPE) {
            return new Character((char)((Number)o).shortValue());
        }
        return o;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

