/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import koala.dynamicjava.classinfo.ClassInfo;

public class ClassPool {
    protected Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>(11);

    public ClassInfo add(String cn, ClassInfo ci) {
        this.classes.put(cn, ci);
        ClassInfo[] infos = ci.getDeclaredClasses();
        for (int i = 0; i < infos.length; ++i) {
            String s = infos[i].getName();
            if (this.classes.containsKey(s)) continue;
            this.add(s, infos[i]);
        }
        return ci;
    }

    public boolean contains(String cn) {
        return this.classes.containsKey(cn);
    }

    public ClassInfo get(String cn) {
        return this.classes.get(cn);
    }

    public ClassInfo getFirstCompilable() {
        Iterator<String> it = this.classes.keySet().iterator();
        while (it.hasNext()) {
            ClassInfo ci = this.classes.get(it.next());
            if (!ci.isCompilable()) continue;
            return ci;
        }
        return null;
    }
}

