/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantString;
import koala.dynamicjava.classfile.FieldIdentifier;
import koala.dynamicjava.classfile.InterfaceMethodIdentifier;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodIdentifier;

public class ConstantPool {
    private static final byte CONSTANT_UTF8 = 1;
    private static final byte CONSTANT_INTEGER = 3;
    private static final byte CONSTANT_FLOAT = 4;
    private static final byte CONSTANT_LONG = 5;
    private static final byte CONSTANT_DOUBLE = 6;
    private static final byte CONSTANT_CLASS = 7;
    private static final byte CONSTANT_STRING = 8;
    private static final byte CONSTANT_FIELDREF = 9;
    private static final byte CONSTANT_METHODREF = 10;
    private static final byte CONSTANT_INTERFACEMETHODREF = 11;
    private static final byte CONSTANT_NAMEANDTYPE = 12;
    private Map<Object, Info> constants = new HashMap<Object, Info>();
    private short count = 1;
    List<Info> constantList = new LinkedList<Info>();

    public short getCount() {
        return this.count;
    }

    public short put(Integer cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new IntegerInfo(cst);
        }
        return info.index;
    }

    public short put(Long cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new LongInfo(cst);
        }
        return info.index;
    }

    public short put(Float cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new FloatInfo(cst);
        }
        return info.index;
    }

    public short put(Double cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new DoubleInfo(cst);
        }
        return info.index;
    }

    public short put(ConstantString cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new StringInfo(cst);
        }
        return info.index;
    }

    public short put(ClassIdentifier cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new ClassInfo(cst);
        }
        return info.index;
    }

    public short put(FieldIdentifier cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new FieldInfo(cst);
        }
        return info.index;
    }

    public short put(MethodIdentifier cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new MethodInfo(cst);
        }
        return info.index;
    }

    public short put(InterfaceMethodIdentifier cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new InterfaceMethodInfo(cst);
        }
        return info.index;
    }

    public void write(OutputStream out) throws IOException {
        this.write(new DataOutputStream(out));
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.count);
        Iterator<Info> it = this.constantList.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
    }

    short putNameAndType(String name, String type, String[] params) {
        NameAndTypeKey ntk = new NameAndTypeKey(name, type, params);
        Info info = this.constants.get(ntk);
        if (info == null) {
            info = new NameAndTypeInfo(ntk);
        }
        return info.index;
    }

    short putUTF8(String cst) {
        Info info = this.constants.get(cst);
        if (info == null) {
            info = new UTF8Info(cst);
        }
        return info.index;
    }

    Info get(short i) {
        return this.constantList.get(i);
    }

    static class NameAndTypeKey {
        String name;
        String type;

        NameAndTypeKey(String n, String t, String[] p) {
            this.name = n;
            this.type = JVMUtilities.createMethodDescriptor(t, p);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof NameAndTypeKey)) {
                return false;
            }
            NameAndTypeKey fk = (NameAndTypeKey)other;
            return this.name.equals(fk.name) && this.type.equals(fk.type);
        }

        public int hashCode() {
            return this.name.hashCode() + this.type.hashCode();
        }
    }

    class UTF8Info
    extends Info {
        String value;

        UTF8Info(String v) {
            super(v);
            this.value = v;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeUTF(this.value);
        }
    }

    class NameAndTypeInfo
    extends Info {
        int nameIndex;
        int typeIndex;

        NameAndTypeInfo(NameAndTypeKey v) {
            super(v);
            this.nameIndex = ConstantPool.this.putUTF8(v.name);
            this.typeIndex = ConstantPool.this.putUTF8(v.type);
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(12);
            out.writeShort(this.nameIndex);
            out.writeShort(this.typeIndex);
        }
    }

    class InterfaceMethodInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        InterfaceMethodInfo(InterfaceMethodIdentifier v) {
            super(v);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(v.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(v.getName(), v.getType(), v.getParameters());
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(11);
            out.writeShort(this.classIndex);
            out.writeShort(this.nameAndTypeIndex);
        }
    }

    class MethodInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        MethodInfo(MethodIdentifier v) {
            super(v);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(v.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(v.getName(), v.getType(), v.getParameters());
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(10);
            out.writeShort(this.classIndex);
            out.writeShort(this.nameAndTypeIndex);
        }
    }

    class FieldInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        FieldInfo(FieldIdentifier v) {
            super(v);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(v.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(v.getName(), v.getType(), null);
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(9);
            out.writeShort(this.classIndex);
            out.writeShort(this.nameAndTypeIndex);
        }
    }

    class ClassInfo
    extends Info {
        int UTF8Index;

        ClassInfo(ClassIdentifier v) {
            super(v);
            this.UTF8Index = ConstantPool.this.putUTF8(v.getValue());
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(7);
            out.writeShort(this.UTF8Index);
        }
    }

    class StringInfo
    extends Info {
        int UTF8Index;

        StringInfo(ConstantString v) {
            super(v);
            this.UTF8Index = ConstantPool.this.putUTF8(v.getValue());
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(8);
            out.writeShort(this.UTF8Index);
        }
    }

    class DoubleInfo
    extends Info {
        Double value;

        DoubleInfo(Double v) {
            super(v);
            this.value = v;
        }

        short getIndexIncrement() {
            return 2;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(6);
            out.writeDouble(this.value);
        }
    }

    class FloatInfo
    extends Info {
        Float value;

        FloatInfo(Float v) {
            super(v);
            this.value = v;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(4);
            out.writeFloat(this.value.floatValue());
        }
    }

    class LongInfo
    extends Info {
        Long value;

        LongInfo(Long v) {
            super(v);
            this.value = v;
        }

        short getIndexIncrement() {
            return 2;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(5);
            out.writeLong(this.value);
        }
    }

    class IntegerInfo
    extends Info {
        Integer value;

        IntegerInfo(Integer v) {
            super(v);
            this.value = v;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeByte(3);
            out.writeInt(this.value);
        }
    }

    abstract class Info {
        short index;

        Info(Object cst) {
            this.index = ConstantPool.this.count;
            ConstantPool.this.count = (short)(ConstantPool.this.count + this.getIndexIncrement());
            ConstantPool.this.constants.put(cst, this);
            ConstantPool.this.constantList.add(this);
        }

        short getIndexIncrement() {
            return 1;
        }

        abstract void write(DataOutputStream var1) throws IOException;
    }
}

