/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import edu.rice.cs.util.swing.Utilities;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public final class SlaveJVMRunner {
    public static final boolean SHOW_DEBUG_DIALOGS = false;
    protected static final Log _log;
    private static final long RMI_TIMEOUT = 5000L;
    private static Thread _main;
    private static volatile boolean _notDone;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$util$newjvm$SlaveJVMRunner;

    private SlaveJVMRunner() {
    }

    private static AbstractSlaveJVM _getInstance(Class clazz) throws Exception {
        try {
            return (AbstractSlaveJVM)clazz.getField("ONLY").get(null);
        }
        catch (Throwable t) {
            _log.log("SlaveRemote class does not have an ONLY field!");
            return (AbstractSlaveJVM)clazz.newInstance();
        }
    }

    public static synchronized void main(String[] args) {
        try {
            System.setProperty("java.rmi.server.hostname", "127.0.0.1");
            if (!$assertionsDisabled && args.length != 3 && args.length != 2) {
                throw new AssertionError();
            }
            _notDone = true;
            _main = Thread.currentThread();
            FileInputStream fstream = new FileInputStream(args[0]);
            ObjectInputStream ostream = new ObjectInputStream(new BufferedInputStream(fstream));
            _log.log("Slave JVM reading master remote stub from file " + args[0] + " with " + fstream.getChannel().size() + " bytes");
            MasterRemote masterRemote = (MasterRemote)ostream.readObject();
            _notDone = false;
            _log.log("SlaveJVMRunner completed reading " + masterRemote);
            fstream.close();
            ostream.close();
            AbstractSlaveJVM slave = null;
            try {
                Class<?> slaveClass = Class.forName(args[1]);
                slave = SlaveJVMRunner._getInstance(slaveClass);
                SlaveRemote slaveRemote = (SlaveRemote)UnicastRemoteObject.toStub(slave);
                _log.log("SlaveJVMRunner exported stub " + slaveRemote);
                slave.start(masterRemote);
                _log.log("SlaveJVMRunner invoking the method registerSlave(" + slave + ") in the Master JVM");
                masterRemote.registerSlave(slave);
            }
            catch (Exception e) {
                _log.log("SlaveJVMRunner could not instantiate and start slave class '" + slave + "'.  Threw exception: " + e);
                try {
                    masterRemote.errorStartingSlave(e);
                }
                catch (RemoteException re) {
                    String msg = "SlaveJVMRunner could not instantiate and register the slave.\n  Also failed to display error through master JVM, because:\n" + StringOps.getStackTrace(re) + "\n";
                    SlaveJVMRunner._showErrorMessage(msg, e);
                }
                System.exit(3);
            }
        }
        catch (Exception e) {
            SlaveJVMRunner._showErrorMessage("SlaveJVMRunner could not set up the Slave JVM.", e);
            _log.log("SlaveJVMRunner could not set up the Slave JVM. Calling System.exit(2) in response to: " + e);
            System.exit(2);
        }
    }

    private static void _showErrorMessage(String cause, Throwable t) {
        String msg = "An error occurred in SlaveJVMRunner while starting the slave JVM:\n  " + cause + "\n\nOriginal error:\n" + StringOps.getStackTrace(t);
        _log.log("ERROR in SlaveJVMRunner: " + cause + "; threw " + t);
        if (!Utilities.TEST_MODE) {
            System.out.println(msg);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$util$newjvm$SlaveJVMRunner == null ? (class$edu$rice$cs$util$newjvm$SlaveJVMRunner = SlaveJVMRunner.class$("edu.rice.cs.util.newjvm.SlaveJVMRunner")) : class$edu$rice$cs$util$newjvm$SlaveJVMRunner).desiredAssertionStatus();
        _log = new Log("MasterSlave.txt", false);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

