/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.swing;

import edu.rice.cs.plt.swing.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class TextAreaMessageDialog
extends JDialog {
    public static void showDialog(Component comp, String title, String message) {
        Frame frame = JOptionPane.getFrameForComponent(comp);
        TextAreaMessageDialog dialog = new TextAreaMessageDialog(frame, comp, title, message);
        SwingUtil.setPopupLoc(dialog, frame);
        dialog.setVisible(true);
    }

    private TextAreaMessageDialog(Frame frame, Component comp, String title, String message) {
        super(frame, title, true);
        this.setDefaultCloseOperation(2);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(SwingUtil.disposeAction(this));
        this.getRootPane().setDefaultButton(okButton);
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(false);
        textArea.setBackground(SystemColor.window);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        textArea.setBorder(emptyBorder);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)textArea, "Center");
        contentPane.add((Component)okButton, "South");
        Dimension parentDim = comp != null ? comp.getSize() : this.getToolkit().getScreenSize();
        int xs = (int)parentDim.getWidth() / 4;
        int ys = (int)parentDim.getHeight() / 5;
        this.setSize(Math.max(xs, 350), Math.max(ys, 250));
        this.setLocationRelativeTo(comp);
    }
}

