/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.lambda.Lambda2;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMappedIterator<T1, T2, R>
implements Iterator<R> {
    private final Iterator<? extends T1> _source1;
    private final Iterator<? extends T2> _source2;
    private final Lambda2<? super T1, ? super T2, ? extends R> _map;

    public BinaryMappedIterator(Iterator<? extends T1> source1, Iterator<? extends T2> source2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        this._source1 = source1;
        this._source2 = source2;
        this._map = map;
    }

    @Override
    public boolean hasNext() {
        return this._source1.hasNext();
    }

    @Override
    public R next() {
        return this._map.value(this._source1.next(), this._source2.next());
    }

    @Override
    public void remove() {
        this._source1.remove();
        this._source2.remove();
    }

    public static <T1, T2, R> BinaryMappedIterator<T1, T2, R> make(Iterator<? extends T1> source1, Iterator<? extends T2> source2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        return new BinaryMappedIterator<T1, T2, R>(source1, source2, map);
    }
}

