/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectInputStream;
import edu.rice.cs.plt.io.DirectOutputStream;
import edu.rice.cs.plt.io.ExpandingByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LinkedInputAndOutputStream {
    private final DirectInputStream _linkedInputStream;
    private final DirectOutputStream _linkedOutputStream;
    private long _readIndex = 0L;
    private boolean _eof = false;
    private long _writeIndex = 0L;

    public LinkedInputAndOutputStream(final InputStream in, final OutputStream out) {
        final ExpandingByteBuffer buffer = new ExpandingByteBuffer();
        final DirectInputStream fromBuffer = buffer.inputStream();
        final DirectOutputStream toBuffer = buffer.outputStream();
        this._linkedInputStream = new DirectInputStream(){

            public int read(byte[] bbuf, int offset, int bytes) throws IOException {
                int read = 0;
                if (!buffer.isEmpty()) {
                    int bufferReadResult = fromBuffer.read(bbuf, offset, bytes);
                    if (bufferReadResult < 0) {
                        throw new IllegalStateException("Unexpected negative result from ExpandingByteBuffer read");
                    }
                    if (bufferReadResult > 0) {
                        read += bufferReadResult;
                        bytes -= bufferReadResult;
                    }
                }
                if (buffer.isEmpty() && bytes >= 0) {
                    int readResult = in.read(bbuf, offset + read, bytes);
                    if (readResult < 0) {
                        LinkedInputAndOutputStream.access$002(LinkedInputAndOutputStream.this, true);
                        return read > 0 ? read : readResult;
                    }
                    read += readResult;
                    bytes -= readResult;
                    LinkedInputAndOutputStream.access$114(LinkedInputAndOutputStream.this, readResult);
                }
                return read;
            }

            public void close() throws IOException {
                in.close();
            }

            public int available() throws IOException {
                return in.available();
            }
        };
        this._linkedOutputStream = new DirectOutputStream(){

            public void write(byte[] bbuf, int offset, int bytes) throws IOException {
                long newIndex = LinkedInputAndOutputStream.access$200(LinkedInputAndOutputStream.this) + (long)bytes;
                while (newIndex > LinkedInputAndOutputStream.access$100(LinkedInputAndOutputStream.this)) {
                    if (LinkedInputAndOutputStream.access$000(LinkedInputAndOutputStream.this)) {
                        LinkedInputAndOutputStream.access$102(LinkedInputAndOutputStream.this, newIndex);
                        continue;
                    }
                    int bufferWriteResult = toBuffer.write(in, (int)(newIndex - LinkedInputAndOutputStream.access$100(LinkedInputAndOutputStream.this)));
                    if (bufferWriteResult < 0) {
                        LinkedInputAndOutputStream.access$002(LinkedInputAndOutputStream.this, true);
                        continue;
                    }
                    LinkedInputAndOutputStream.access$114(LinkedInputAndOutputStream.this, bufferWriteResult);
                }
                out.write(bbuf, offset, bytes);
                LinkedInputAndOutputStream.access$202(LinkedInputAndOutputStream.this, newIndex);
            }

            public void close() throws IOException {
                out.close();
            }

            public void flush() throws IOException {
                out.flush();
            }
        };
    }

    public DirectInputStream inputStream() {
        return this._linkedInputStream;
    }

    public DirectOutputStream outputStream() {
        return this._linkedOutputStream;
    }

    static boolean access$002(LinkedInputAndOutputStream x0, boolean x1) {
        x0._eof = x1;
        return x0._eof;
    }

    static long access$114(LinkedInputAndOutputStream x0, long x1) {
        return x0._readIndex += x1;
    }

    static long access$200(LinkedInputAndOutputStream x0) {
        return x0._writeIndex;
    }

    static long access$100(LinkedInputAndOutputStream x0) {
        return x0._readIndex;
    }

    static boolean access$000(LinkedInputAndOutputStream x0) {
        return x0._eof;
    }

    static long access$102(LinkedInputAndOutputStream x0, long x1) {
        x0._readIndex = x1;
        return x0._readIndex;
    }

    static long access$202(LinkedInputAndOutputStream x0, long x1) {
        x0._writeIndex = x1;
        return x0._writeIndex;
    }
}

