/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.concurrent.ConcurrentBox;
import edu.rice.cs.plt.concurrent.IncrementalTask;
import edu.rice.cs.plt.concurrent.IncrementalTaskController;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.io.VoidOutputStream;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentUtil {
    public static final Runnable1<Long> SLEEPING_RUNNABLE = new SleepingRunnable(null);
    public static final Runnable1<Long> WORKING_RUNNABLE = new WorkingRunnable(null);
    private static final /* synthetic */ Class class$java$lang$String;

    private ConcurrentUtil() {
    }

    public static void sleep(long delay) {
        SLEEPING_RUNNABLE.run(Autobox.valueOf(delay));
    }

    public static void work(long delay) {
        WORKING_RUNNABLE.run(Autobox.valueOf(delay));
    }

    public static TaskController<Void> runInThread(Runnable task) {
        return ConcurrentUtil.computeInThread(LambdaUtil.asThunk(task), true);
    }

    public static TaskController<Void> runInThread(Runnable task, boolean start) {
        return ConcurrentUtil.computeInThread(LambdaUtil.asThunk(task), start);
    }

    public static <R> TaskController<R> computeInThread(Thunk<? extends R> task) {
        return ConcurrentUtil.computeInThread(task, true);
    }

    public static <R> TaskController<R> computeInThread(final Thunk<? extends R> task, boolean start) {
        final ThreadController controller = new ThreadController();
        Runnable runner = new Runnable(){

            public void run() {
                Object result = null;
                Throwable exception = null;
                try {
                    result = task.value();
                }
                catch (Throwable e) {
                    exception = e;
                }
                controller.done(result, exception);
            }
        };
        controller.setThread(new Thread(runner, "ConcurrentUtil task"));
        if (start) {
            controller.start();
        }
        return controller;
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(IncrementalTask<? extends I, ? extends R> task) {
        return ConcurrentUtil.computeInThread(task, true, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(IncrementalTask<? extends I, ? extends R> task, boolean start) {
        return ConcurrentUtil.computeInThread(task, start, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(final IncrementalTask<? extends I, ? extends R> task, boolean start, final boolean ignoreIntermediateResults) {
        final IncrementalThreadController controller = new IncrementalThreadController(start);
        Runnable runner = new Runnable(){

            public void run() {
                Object result = null;
                Object intermediate = null;
                Throwable exception = null;
                try {
                    while (exception == null && !task.isFinished()) {
                        controller.authorizeContinue();
                        try {
                            intermediate = task.step();
                        }
                        catch (Throwable e) {
                            exception = e;
                        }
                        if (exception != null || ignoreIntermediateResults) continue;
                        controller.addResult(intermediate);
                    }
                    if (exception == null) {
                        controller.authorizeContinue();
                        try {
                            result = task.value();
                        }
                        catch (Throwable e) {
                            exception = e;
                        }
                    }
                    controller.done(result, exception);
                }
                catch (InterruptedException e) {
                    controller.aborting();
                }
            }
        };
        Thread t = new Thread(runner, "ConcurrentUtil task");
        controller.setThread(t);
        t.start();
        return controller;
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task) {
        return ConcurrentUtil.computeInProcess(task, true);
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task, boolean start) {
        ProcessController<R> controller = new ProcessController<R>(task, new LazyThunk<Process>(new Thunk<Process>(){
            private static final /* synthetic */ Class class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess;

            @Override
            public Process value() {
                try {
                    return ConcurrentUtil.runJavaProcess((class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess == null ? (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess = 3.class$("edu.rice.cs.plt.concurrent.ConcurrentUtil$TaskProcess")) : class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess).getName(), new String[0]);
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }

            @Override
            public Object value() {
                return this.value();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }));
        if (start) {
            controller.start();
        }
        return controller;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static TaskController computeInProcess(Thunk task, final Iterable_ classPath, boolean start) {
        ProcessController controller = new ProcessController(task, new LazyThunk<Process>(new Thunk<Process>(){
            private static final /* synthetic */ Class class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess;

            @Override
            public Process value() {
                try {
                    return ConcurrentUtil.runJavaProcess((class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess == null ? (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess = 4.class$("edu.rice.cs.plt.concurrent.ConcurrentUtil$TaskProcess")) : class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess).getName(), IterUtil.empty(), classPath);
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }

            @Override
            public Object value() {
                return this.value();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }));
        if (start) {
            controller.start();
        }
        return controller;
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task, final File workingDir, boolean start) {
        ProcessController<R> controller = new ProcessController<R>(task, new LazyThunk<Process>(new Thunk<Process>(){
            private static final /* synthetic */ Class class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess;

            @Override
            public Process value() {
                try {
                    return ConcurrentUtil.runJavaProcess((class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess == null ? (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess = 5.class$("edu.rice.cs.plt.concurrent.ConcurrentUtil$TaskProcess")) : class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess).getName(), IterUtil.empty(), workingDir);
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }

            @Override
            public Object value() {
                return this.value();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }));
        if (start) {
            controller.start();
        }
        return controller;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static TaskController computeInProcess(Thunk task, final Iterable_ classPath, final File workingDir, final Properties properties, final Iterable_ jvmParams, boolean start) {
        ProcessController controller = new ProcessController(task, new LazyThunk<Process>(new Thunk<Process>(){
            private static final /* synthetic */ Class class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess;

            @Override
            public Process value() {
                try {
                    return ConcurrentUtil.runJavaProcess((class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess == null ? (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess = 6.class$("edu.rice.cs.plt.concurrent.ConcurrentUtil$TaskProcess")) : class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess).getName(), IterUtil.empty(), classPath, workingDir, properties, jvmParams);
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }

            @Override
            public Object value() {
                return this.value();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }));
        if (start) {
            controller.start();
        }
        return controller;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static TaskController computeInProcess(Thunk task, final File javaCommand, final Iterable_ classPath, final File workingDir, final Properties properties, final Iterable_ jvmParams, boolean start) {
        ProcessController controller = new ProcessController(task, new LazyThunk<Process>(new Thunk<Process>(){
            private static final /* synthetic */ Class class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess;

            @Override
            public Process value() {
                try {
                    return ConcurrentUtil.runJavaProcess(javaCommand, (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess == null ? (class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess = 7.class$("edu.rice.cs.plt.concurrent.ConcurrentUtil$TaskProcess")) : class$edu$rice$cs$plt$concurrent$ConcurrentUtil$TaskProcess).getName(), IterUtil.empty(), classPath, workingDir, properties, jvmParams);
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            }

            @Override
            public Object value() {
                return this.value();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }));
        if (start) {
            controller.start();
        }
        return controller;
    }

    public static Process runJavaProcess(String mainClass, String ... classParams) throws IOException {
        File javaCommand = new File(System.getProperty("java.home", ""));
        Iterable_ classPath = IOUtil.parsePath((String)System.getProperty("java.class.path", ""));
        File workingDir = new File(System.getProperty("user.dir", ""));
        Properties properties = new Properties();
        EmptyIterable jvmParams = IterUtil.empty();
        return ConcurrentUtil.runJavaProcess(javaCommand, mainClass, IterUtil.asIterable(classParams), classPath, workingDir, properties, jvmParams);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Process runJavaProcess(String mainClass, Iterable_ classParams) throws IOException {
        File javaCommand = new File(System.getProperty("java.home", ""));
        Iterable_ classPath = IOUtil.parsePath((String)System.getProperty("java.class.path", ""));
        File workingDir = new File(System.getProperty("user.dir", ""));
        Properties properties = new Properties();
        EmptyIterable jvmParams = IterUtil.empty();
        return ConcurrentUtil.runJavaProcess(javaCommand, mainClass, classParams, classPath, workingDir, properties, jvmParams);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Process runJavaProcess(String mainClass, Iterable_ classParams, Iterable_ classPath) throws IOException {
        File javaCommand = new File(System.getProperty("java.home", ""));
        File workingDir = new File(System.getProperty("user.dir", ""));
        Properties properties = new Properties();
        EmptyIterable jvmParams = IterUtil.empty();
        return ConcurrentUtil.runJavaProcess(javaCommand, mainClass, classParams, classPath, workingDir, properties, jvmParams);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Process runJavaProcess(String mainClass, Iterable_ classParams, File workingDir) throws IOException {
        File javaCommand = new File(System.getProperty("java.home", ""));
        Iterable_ classPath = IOUtil.attemptAbsoluteFiles(IOUtil.parsePath((String)System.getProperty("java.class.path", "")));
        Properties properties = new Properties();
        EmptyIterable jvmParams = IterUtil.empty();
        return ConcurrentUtil.runJavaProcess(javaCommand, mainClass, classParams, classPath, workingDir, properties, jvmParams);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Process runJavaProcess(String mainClass, Iterable_ classParams, Iterable_ classPath, File workingDir, Properties properties, Iterable_ jvmParams) throws IOException {
        File javaCommand = new File(System.getProperty("java.home", ""));
        return ConcurrentUtil.runJavaProcess(javaCommand, mainClass, classParams, classPath, workingDir, properties, jvmParams);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Process runJavaProcess(File javaCommand, String mainClass, Iterable_ classParams, Iterable_ classPath, File workingDir, Properties properties, Iterable_ jvmParams) throws IOException {
        LinkedList<String> propArgs = new LinkedList<String>();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            propArgs.add(new StringBuffer().append("-D").append(prop.getKey()).append("=").append(prop.getValue()).toString());
        }
        AbstractIterable args = IterUtil.singleton(ConcurrentUtil._findJavaExecutable(javaCommand));
        args = IterUtil.compose(args, IterUtil.make("-classpath", IOUtil.pathToString(classPath)));
        args = IterUtil.compose(args, propArgs);
        args = IterUtil.compose(args, jvmParams);
        args = IterUtil.compose(args, (Iterable_)((Object)IterUtil.compose(mainClass, classParams)));
        return Runtime.getRuntime().exec((String[])IterUtil.asArray(args, class$java$lang$String == null ? (class$java$lang$String = ConcurrentUtil.class$("java.lang.String")) : class$java$lang$String), null, workingDir);
    }

    private static String _findJavaExecutable(File f) {
        if (IOUtil.attemptIsFile(f)) {
            return f.getPath();
        }
        f = IOUtil.attemptAbsoluteFile(f);
        String os = System.getProperty("os.name", "");
        File[] candidates = new File[]{new File(f, "../bin"), new File(f, "bin"), f};
        if (TextUtil.containsIgnoreCase(os, "netware")) {
            return "java";
        }
        if (TextUtil.containsIgnoreCase(os, "windows")) {
            for (File dir : candidates) {
                File result = new File(dir, "javaw.exe");
                if (IOUtil.attemptExists(result)) {
                    return result.getPath();
                }
                result = new File(dir, "java.exe");
                if (!IOUtil.attemptExists(result)) continue;
                return result.getPath();
            }
        } else {
            for (File dir : candidates) {
                File result = new File(dir, "java");
                if (!IOUtil.attemptExists(result)) continue;
                return result.getPath();
            }
        }
        return "java";
    }

    public static void discardProcessOutput(Process p) {
        ConcurrentUtil.copyProcessOut(p, VoidOutputStream.INSTANCE);
        ConcurrentUtil.copyProcessErr(p, VoidOutputStream.INSTANCE);
    }

    public static void copyProcessOutput(Process p, OutputStream out, OutputStream err) {
        ConcurrentUtil.copyProcessOut(p, out);
        ConcurrentUtil.copyProcessErr(p, err);
    }

    public static void discardProcessOut(Process p) {
        ConcurrentUtil.copyProcessOut(p, VoidOutputStream.INSTANCE);
    }

    public static Thread copyProcessOut(Process p, OutputStream out) {
        return ConcurrentUtil.copyProcessOut(p, out, false);
    }

    public static Thread copyProcessOut(Process p, OutputStream out, boolean close) {
        Thread result = new Thread(new CopyStream(p.getInputStream(), out, close));
        result.start();
        return result;
    }

    public static TaskController<String> processOutAsString(Process p) {
        return ConcurrentUtil.computeInThread(new StreamToString(p.getInputStream()));
    }

    public static void discardProcessErr(Process p) {
        ConcurrentUtil.copyProcessErr(p, VoidOutputStream.INSTANCE);
    }

    public static Thread copyProcessErr(Process p, OutputStream err) {
        return ConcurrentUtil.copyProcessErr(p, err, false);
    }

    public static Thread copyProcessErr(Process p, OutputStream err, boolean close) {
        Thread result = new Thread(new CopyStream(p.getErrorStream(), err, close));
        result.start();
        return result;
    }

    public static TaskController<String> processErrAsString(Process p) {
        return ConcurrentUtil.computeInThread(new StreamToString(p.getErrorStream()));
    }

    public static Properties getProperties(String ... prefixes) {
        Properties result = new Properties();
        block0: for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            for (String prefix : prefixes) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(prefix)) continue;
                result.put(entry.getKey(), entry.getValue());
                continue block0;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class StreamToString
    implements Thunk<String> {
        private final InputStream _stream;

        public StreamToString(InputStream stream) {
            this._stream = stream;
        }

        @Override
        public String value() {
            try {
                return IOUtil.toString(new InputStreamReader(this._stream));
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }

        @Override
        public Object value() {
            return this.value();
        }
    }

    private static final class CopyStream
    implements Runnable,
    Serializable {
        private final InputStream _in;
        private final OutputStream _out;
        private final boolean _close;

        public CopyStream(InputStream in, OutputStream out, boolean close) {
            this._in = in;
            this._out = out;
            this._close = close;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    IOUtil.copyInputStream(this._in, this._out);
                }
                finally {
                    if (this._close) {
                        this._out.close();
                    }
                }
            }
            catch (IOException e) {
                DebugUtil.error.log(e);
            }
        }
    }

    private static class TaskProcess {
        private TaskProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String ... args) {
            try {
                ObjectOutputStream objOut = new ObjectOutputStream(System.out);
                try {
                    Object result = null;
                    Exception exception = null;
                    try {
                        IOUtil.replaceSystemOut(VoidOutputStream.INSTANCE);
                        try {
                            ObjectInputStream objIn = new ObjectInputStream(System.in);
                            try {
                                Thunk task = (Thunk)objIn.readObject();
                                try {
                                    result = task.value();
                                }
                                catch (Throwable e) {
                                    exception = new InvocationTargetException(e);
                                }
                            }
                            finally {
                                objIn.close();
                            }
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                    }
                    finally {
                        IOUtil.revertSystemOut();
                    }
                    objOut.writeObject(result);
                    objOut.writeObject(exception);
                }
                finally {
                    objOut.close();
                }
            }
            catch (IOException e) {
                DebugUtil.error.log("Can't create or write to ObjectOutputStream", e);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessController<R>
    extends TaskController<R> {
        private Thunk<? extends R> _task;
        private Thunk<Process> _process;
        private Exception _exception;

        public ProcessController(Thunk<? extends R> task, Thunk<Process> process) {
            this._task = task;
            this._process = process;
            this._exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doStart() {
            this._status = TaskController.Status.RUNNING;
            try {
                this._process.value();
                ConcurrentUtil.discardProcessErr(this._process.value());
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof IOException) {
                    this._exception = (IOException)e.getCause();
                    this._status = TaskController.Status.FINISHED;
                }
                throw e;
            }
            if (this._exception == null) {
                try {
                    ObjectOutputStream objOut = new ObjectOutputStream(this._process.value().getOutputStream());
                    try {
                        objOut.writeObject(this._task);
                    }
                    finally {
                        objOut.close();
                    }
                }
                catch (IOException e) {
                    this._exception = e;
                    this._process.value().destroy();
                    this._status = TaskController.Status.FINISHED;
                }
            }
        }

        @Override
        protected void doCancel() {
            if (this._status == TaskController.Status.RUNNING) {
                this._process.value().destroy();
            }
            this._task = null;
            this._process = null;
            this._exception = null;
            this._status = TaskController.Status.CANCELLED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected R getValue() throws Exception {
            this.start();
            Object result = null;
            if (this._exception == null) {
                try {
                    ObjectInputStream objIn = new ObjectInputStream(this._process.value().getInputStream());
                    try {
                        Object serializedResult;
                        result = serializedResult = objIn.readObject();
                        this._exception = (Exception)objIn.readObject();
                    }
                    finally {
                        objIn.close();
                    }
                }
                catch (InterruptedIOException e) {
                    this._exception = new InterruptedException(e.getMessage());
                    this._exception.setStackTrace(e.getStackTrace());
                }
                catch (IOException e) {
                    this._exception = e;
                }
            }
            this._status = TaskController.Status.FINISHED;
            if (this._exception != null) {
                throw this._exception;
            }
            return (R)result;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncrementalThreadController<I, R>
    extends IncrementalTaskController<I, R> {
        private Thread _t;
        private CompletionMonitor _continueMonitor;
        private Box<List<I>> _intermediateResults;
        private volatile R _result;
        private volatile Throwable _exception;

        public IncrementalThreadController(boolean start) {
            this._continueMonitor = new CompletionMonitor(start);
            this._intermediateResults = new ConcurrentBox(new LinkedList());
            if (start) {
                this._status = TaskController.Status.RUNNING;
            }
        }

        protected void setThread(Thread t) {
            this._t = t;
        }

        protected void authorizeContinue() throws InterruptedException {
            if (!this._continueMonitor.isSignalled()) {
                this._status = TaskController.Status.PAUSED;
                DebugUtil.debug.log("Waiting for signal to continue");
                this._continueMonitor.ensureSignalled();
                DebugUtil.debug.log("Received signal to continue");
                this._status = TaskController.Status.RUNNING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addResult(I result) {
            Box<List<I>> box = this._intermediateResults;
            synchronized (box) {
                ((List)this._intermediateResults.value()).add(result);
                this._intermediateResults.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done(R result, Throwable exception) {
            this._result = result;
            this._exception = exception;
            this._status = TaskController.Status.FINISHED;
            Box<List<I>> box = this._intermediateResults;
            synchronized (box) {
                this._intermediateResults.notifyAll();
            }
        }

        protected void aborting() {
            this._status = TaskController.Status.CANCELLED;
            this._t = null;
            this._continueMonitor = null;
            this._intermediateResults = null;
            this._result = null;
            this._exception = null;
        }

        @Override
        protected void doStart() {
            this._continueMonitor.signal();
        }

        @Override
        protected void doPause() {
            this._continueMonitor.reset();
        }

        @Override
        protected void doCancel() {
            if (this._status == TaskController.Status.FINISHED) {
                this.aborting();
            } else {
                this._continueMonitor.reset();
                this._t.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<I> getIntermediateValues() throws InterruptedException {
            Box<List<I>> box = this._intermediateResults;
            synchronized (box) {
                while (((List)this._intermediateResults.value()).isEmpty() && this._status != TaskController.Status.FINISHED) {
                    this._continueMonitor.signal();
                    DebugUtil.debug.log("Waiting for intermediate results");
                    this._intermediateResults.wait();
                    DebugUtil.debug.log("Done waiting for intermediate results");
                }
                List result = (List)this._intermediateResults.value();
                this._intermediateResults.set(new LinkedList());
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasIntermediateValue() {
            Box<List<I>> box = this._intermediateResults;
            synchronized (box) {
                return !((List)this._intermediateResults.value()).isEmpty();
            }
        }

        @Override
        protected R getValue() throws InterruptedException, InvocationTargetException {
            this._continueMonitor.signal();
            this._t.join();
            if (this._exception != null) {
                throw new InvocationTargetException(this._exception);
            }
            return this._result;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadController<R>
    extends TaskController<R> {
        private Thread _t;
        private volatile R _result;
        private volatile Throwable _exception;

        protected void setThread(Thread t) {
            this._t = t;
        }

        protected void done(R result, Throwable exception) {
            if (this._status != TaskController.Status.CANCELLED) {
                this._result = result;
                this._exception = exception;
                this._status = TaskController.Status.FINISHED;
            }
        }

        @Override
        protected void doStart() {
            this._t.start();
            this._status = TaskController.Status.RUNNING;
        }

        @Override
        protected void doCancel() {
            this._status = TaskController.Status.CANCELLED;
            this._t.interrupt();
            this._t = null;
            this._result = null;
            this._exception = null;
        }

        @Override
        protected R getValue() throws InterruptedException, InvocationTargetException {
            this.start();
            this._t.join();
            if (this._exception != null) {
                throw new InvocationTargetException(this._exception);
            }
            return this._result;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WorkingRunnable
    implements Runnable1<Long>,
    Serializable {
        private WorkingRunnable() {
        }

        @Override
        public void run(Long delay) {
            long finished = System.currentTimeMillis() + delay;
            while (System.currentTimeMillis() < finished) {
                Thread.currentThread();
                if (Thread.interrupted()) break;
                for (int i = 0; i < 1000; ++i) {
                    long junk = delay * (delay - (long)i);
                }
            }
        }

        @Override
        public void run(Object x0) {
            this.run((Long)x0);
        }

        WorkingRunnable(1 x0) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SleepingRunnable
    implements Runnable1<Long>,
    Serializable {
        private SleepingRunnable() {
        }

        @Override
        public void run(Long delay) {
            try {
                Thread.currentThread();
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run(Object x0) {
            this.run((Long)x0);
        }

        SleepingRunnable(1 x0) {
            this();
        }
    }
}

