/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Statement {
    private final BracedBody _statements;

    public Block(SourceInfo in_sourceInfo, BracedBody in_statements) {
        super(in_sourceInfo);
        if (in_statements == null) {
            throw new IllegalArgumentException("Parameter 'statements' to the Block constructor was null. This class may not have null field values.");
        }
        this._statements = in_statements;
    }

    public final BracedBody getStatements() {
        return this._statements;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forBlock(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forBlock(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("Block:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("statements = ");
        BracedBody temp_statements = this.getStatements();
        if (temp_statements == null) {
            writer.print("null");
        } else {
            temp_statements.outputHelp(writer);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        Block casted = (Block)obj;
        return this.getStatements().equals(casted.getStatements());
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        return code ^= this.getStatements().hashCode();
    }
}

