/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.javalanglevels.BlockData;
import edu.rice.cs.javalanglevels.Bob;
import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.ExpressionTypeChecker;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TryCatchBodyTypeChecker;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.AssignmentExpression;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.Body;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.CatchBlock;
import edu.rice.cs.javalanglevels.tree.CharLiteral;
import edu.rice.cs.javalanglevels.tree.DefaultCase;
import edu.rice.cs.javalanglevels.tree.DoStatement;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.ExpressionStatement;
import edu.rice.cs.javalanglevels.tree.ForStatement;
import edu.rice.cs.javalanglevels.tree.IfThenElseStatement;
import edu.rice.cs.javalanglevels.tree.IfThenStatement;
import edu.rice.cs.javalanglevels.tree.IncrementExpression;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.IntegerLiteral;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.LabeledCase;
import edu.rice.cs.javalanglevels.tree.LexicalLiteral;
import edu.rice.cs.javalanglevels.tree.NormalTryCatchStatement;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.NumericUnaryExpression;
import edu.rice.cs.javalanglevels.tree.SimpleAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.SimpleSuperReference;
import edu.rice.cs.javalanglevels.tree.SimpleThisReference;
import edu.rice.cs.javalanglevels.tree.SwitchCase;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchFinallyStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.Type;
import edu.rice.cs.javalanglevels.tree.UnbracedBody;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.ValueReturnStatement;
import edu.rice.cs.javalanglevels.tree.VariableDeclarator;
import edu.rice.cs.javalanglevels.tree.VoidReturnStatement;
import edu.rice.cs.javalanglevels.tree.WhileStatement;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BodyTypeChecker
extends Bob {
    protected BodyData _bodyData;

    public BodyTypeChecker(BodyData bodyData, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        super(bodyData, file, packageName, importedFiles, importedPackages, vars, thrown);
        this._bodyData = bodyData;
    }

    @Override
    protected Data _getData() {
        return this._bodyData;
    }

    @Override
    public TypeData forSimpleThisReferenceOnly(SimpleThisReference that) {
        return this._bodyData.getSymbolData().getInstanceData();
    }

    @Override
    public TypeData forSimpleSuperReferenceOnly(SimpleSuperReference that) {
        return this._bodyData.getSymbolData().getSuperClass().getInstanceData();
    }

    protected BodyTypeChecker createANewInstanceOfMe(BodyData bodyData, File file, String pakage, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        return new BodyTypeChecker(bodyData, file, pakage, importedFiles, importedPackages, vars, thrown);
    }

    @Override
    public TypeData forInstanceInitializer(InstanceInitializer that) {
        return this.forBlock(that.getCode());
    }

    @Override
    public TypeData forUninitializedVariableDeclaratorOnly(UninitializedVariableDeclarator that, TypeData type_result, TypeData name_result) {
        this._vars.addLast(this._bodyData.getVar(that.getName().getText()));
        return null;
    }

    public TypeData forBodyOnly(Body that, TypeData[] items_result) {
        for (int i = 0; i < items_result.length; ++i) {
            if (items_result[i] == null || that.getStatements()[i] instanceof ExpressionStatement) continue;
            if (i < items_result.length - 1) {
                BodyTypeChecker._addError("Unreachable statement.", (JExpression)((Object)that.getStatements()[i + 1]));
            }
            return items_result[i];
        }
        return null;
    }

    public TypeData forBracedBodyOnly(BracedBody that, TypeData[] items_result) {
        return this.forBodyOnly((Body)that, items_result);
    }

    public TypeData forUnbracedBodyOnly(UnbracedBody that, TypeData[] items_result) {
        return this.forBodyOnly((Body)that, items_result);
    }

    @Override
    public TypeData forVoidReturnStatementOnly(VoidReturnStatement that) {
        MethodData md = this._bodyData.getMethodData();
        if (md.getReturnType() != SymbolData.VOID_TYPE) {
            BodyTypeChecker._addError("Cannot return void when the method's expected return type is not void.", that);
            return md.getReturnType().getInstanceData();
        }
        return SymbolData.VOID_TYPE.getInstanceData();
    }

    @Override
    public TypeData forValueReturnStatement(ValueReturnStatement that) {
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData value_result = that.getValue().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        return this.forValueReturnStatementOnly(that, value_result);
    }

    @Override
    public TypeData forValueReturnStatementOnly(ValueReturnStatement that, TypeData value_result) {
        MethodData md = this._bodyData.getMethodData();
        SymbolData expected = md.getReturnType();
        if (expected == null) {
            return value_result;
        }
        if (value_result == null || !this.assertFound(value_result, that)) {
            return expected.getInstanceData();
        }
        if (value_result != null && !value_result.isInstanceType()) {
            BodyTypeChecker._addError(new StringBuffer().append("You cannot return a class or interface name.  Perhaps you meant to say ").append(value_result.getName()).append(".class or to create an instance").toString(), that);
            return value_result.getInstanceData();
        }
        if (expected == SymbolData.VOID_TYPE) {
            BodyTypeChecker._addError("Cannot return a value when the method's expected return type is void.", that);
            return SymbolData.VOID_TYPE.getInstanceData();
        }
        if (!this._isAssignableFrom(expected, value_result.getSymbolData())) {
            BodyTypeChecker._addError(new StringBuffer().append("This method expected to return type: \"").append(expected.getName()).append("\" but here returned type: \"").append(value_result.getName()).append("\".").toString(), that);
        }
        return value_result;
    }

    @Override
    public TypeData forForStatement(ForStatement that) {
        Boolean expOk = Boolean.TRUE;
        if (that.getCondition() instanceof Expression) {
            Expression exp = (Expression)that.getCondition();
            expOk = exp.visit(new NoAssignmentAllowedInExpression("the conditional expression of a for-statement", null));
        }
        BodyTypeChecker btc = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData init_result = that.getInit().visit(btc);
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, btc._vars, this._thrown);
        TypeData condition_result = that.getCondition().visit(etc);
        btc.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        TypeData update_result = that.getUpdate().visit(btc);
        TypeData code_result = that.getCode().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        if (expOk.booleanValue()) {
            return this.forForStatementOnly(that, init_result, condition_result, update_result, code_result);
        }
        return null;
    }

    @Override
    public TypeData forForStatementOnly(ForStatement that, TypeData init_result, TypeData condition_result, TypeData update_result, TypeData code_result) {
        if (condition_result != null && this.assertFound(condition_result, that)) {
            if (!condition_result.isInstanceType()) {
                BodyTypeChecker._addError("This for-statement's conditional expression must be a boolean value. Instead, it is a class or interface name", that);
            } else if (!condition_result.getSymbolData().isBooleanType(_targetVersion)) {
                BodyTypeChecker._addError(new StringBuffer().append("This for-statement's conditional expression must be a boolean value. Instead, its type is ").append(condition_result.getName()).toString(), that);
            }
        }
        return null;
    }

    @Override
    public TypeData forIfThenStatement(IfThenStatement that) {
        Boolean expOk = Boolean.TRUE;
        if (that.getTestExpression() instanceof Expression) {
            Expression exp = that.getTestExpression();
            expOk = exp.visit(new NoAssignmentAllowedInExpression("the conditional expression of an if-then statement", null));
        }
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData testExpression_result = that.getTestExpression().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        BodyTypeChecker btc = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData thenStatement_result = that.getThenStatement().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        if (expOk.booleanValue()) {
            return this.forIfThenStatementOnly(that, testExpression_result, thenStatement_result);
        }
        return null;
    }

    @Override
    public TypeData forIfThenStatementOnly(IfThenStatement that, TypeData testExpression_result, TypeData thenStatement_result) {
        if (testExpression_result != null && this.assertFound(testExpression_result, that.getTestExpression())) {
            if (!testExpression_result.isInstanceType()) {
                BodyTypeChecker._addError("This if-then-statement's conditional expression must be a boolean value. Instead, it is a class or interface name", that);
            } else if (!testExpression_result.getSymbolData().isBooleanType(_targetVersion)) {
                BodyTypeChecker._addError(new StringBuffer().append("This if-then-statement's conditional expression must be a boolean value. Instead, its type is ").append(testExpression_result.getName()).toString(), that.getTestExpression());
            }
        }
        return null;
    }

    @Override
    public TypeData forIfThenElseStatement(IfThenElseStatement that) {
        Boolean expOk = Boolean.TRUE;
        if (that.getTestExpression() instanceof Expression) {
            Expression exp = that.getTestExpression();
            expOk = exp.visit(new NoAssignmentAllowedInExpression("the conditional expression of an if-then-else statement", null));
        }
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData testExpression_result = that.getTestExpression().visit(etc);
        this.thingsThatHaveBeenAssigned = etc.thingsThatHaveBeenAssigned;
        BodyTypeChecker btcThen = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData thenStatement_result = that.getThenStatement().visit(btcThen);
        this.unassignVariableDatas(btcThen.thingsThatHaveBeenAssigned);
        BodyTypeChecker btcElse = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData elseStatement_result = that.getElseStatement().visit(btcElse);
        this.unassignVariableDatas(btcElse.thingsThatHaveBeenAssigned);
        this.reassignVariableDatas(btcThen.thingsThatHaveBeenAssigned, btcElse.thingsThatHaveBeenAssigned);
        if (expOk.booleanValue()) {
            return this.forIfThenElseStatementOnly(that, testExpression_result, thenStatement_result, elseStatement_result);
        }
        return null;
    }

    @Override
    public TypeData forIfThenElseStatementOnly(IfThenElseStatement that, TypeData testExpression_result, TypeData thenStatement_result, TypeData elseStatement_result) {
        if (testExpression_result != null && this.assertFound(testExpression_result, that.getTestExpression())) {
            if (!testExpression_result.isInstanceType()) {
                BodyTypeChecker._addError("This if-then-else statement's conditional expression must be a boolean value. Instead, it is a class or interface name", that);
            } else if (!testExpression_result.getSymbolData().isBooleanType(_targetVersion)) {
                BodyTypeChecker._addError(new StringBuffer().append("This if-then-else statement's conditional expression must be a boolean value. Instead, its type is ").append(testExpression_result.getName()).toString(), that.getTestExpression());
            }
        }
        if (testExpression_result == null || thenStatement_result == null || elseStatement_result == null) {
            return null;
        }
        SymbolData result = this.getCommonSuperType(thenStatement_result.getSymbolData(), elseStatement_result.getSymbolData());
        if (result == null) {
            return null;
        }
        return result.getInstanceData();
    }

    @Override
    public TypeData forWhileStatement(WhileStatement that) {
        Boolean expOk = Boolean.TRUE;
        if (that.getCondition() instanceof Expression) {
            Expression exp = that.getCondition();
            expOk = exp.visit(new NoAssignmentAllowedInExpression("the condition expression of a while statement", null));
        }
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData condition_result = that.getCondition().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        BodyTypeChecker btc = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData code_result = that.getCode().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        if (expOk.booleanValue()) {
            return this.forWhileStatementOnly(that, condition_result, code_result);
        }
        return null;
    }

    @Override
    public TypeData forWhileStatementOnly(WhileStatement that, TypeData condition_result, TypeData code_result) {
        if (condition_result != null && this.assertFound(condition_result, that.getCondition())) {
            if (!condition_result.isInstanceType()) {
                BodyTypeChecker._addError("This while-statement's conditional expression must be a boolean value. Instead, it is a class or interface name", that);
            } else if (!condition_result.getSymbolData().isBooleanType(_targetVersion)) {
                BodyTypeChecker._addError(new StringBuffer().append("This while-statement's conditional expression must be a boolean value. Instead, its type is ").append(condition_result.getName()).toString(), that.getCondition());
            }
        }
        return null;
    }

    @Override
    public TypeData forDoStatement(DoStatement that) {
        BodyTypeChecker btc = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData code_result = that.getCode().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        Boolean expOk = Boolean.TRUE;
        if (that.getCondition() instanceof Expression) {
            Expression exp = that.getCondition();
            expOk = exp.visit(new NoAssignmentAllowedInExpression("the condition expression of a do statement", null));
        }
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData condition_result = that.getCondition().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        if (expOk.booleanValue()) {
            return this.forDoStatementOnly(that, code_result, condition_result);
        }
        return null;
    }

    @Override
    public TypeData forDoStatementOnly(DoStatement that, TypeData code_result, TypeData condition_result) {
        if (condition_result != null && this.assertFound(condition_result, that.getCondition())) {
            if (!condition_result.isInstanceType()) {
                BodyTypeChecker._addError("This do-statement's conditional expression must be a boolean value. Instead, it is a class or interface name", that.getCondition());
            } else if (!condition_result.getSymbolData().isBooleanType(_targetVersion)) {
                BodyTypeChecker._addError(new StringBuffer().append("This do-statement's conditional expression must be a boolean value. Instead, its type is ").append(condition_result.getName()).toString(), that.getCondition());
            }
        }
        if (code_result == null) {
            return null;
        }
        return code_result.getInstanceData();
    }

    @Override
    public TypeData forSwitchStatement(SwitchStatement that) {
        Expression exp = that.getTest();
        exp.visit(new NoAssignmentAllowedInExpression("the switch expression of a switch statement", null));
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData test_result = that.getTest().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        if (test_result == null || !this.assertFound(test_result, exp)) {
            return null;
        }
        if (!this._isAssignableFrom(SymbolData.INT_TYPE, test_result.getSymbolData()) && !this._isAssignableFrom(SymbolData.CHAR_TYPE, test_result.getSymbolData())) {
            BodyTypeChecker._addError(new StringBuffer().append("The switch expression must be either an int or a char.  You have used a ").append(test_result.getSymbolData().getName()).toString(), that.getTest());
        }
        TypeData[] cases_result = this.makeArrayOfRetType(that.getCases().length);
        BodyTypeChecker[] btcs = new BodyTypeChecker[that.getCases().length];
        HashSet<Integer> labels = new HashSet<Integer>();
        LinkedList variablesAssigned = new LinkedList();
        boolean seenDefault = false;
        boolean hadCaseReturn = false;
        for (int i = 0; i < that.getCases().length; ++i) {
            SwitchCase sc = that.getCases()[i];
            btcs[i] = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
            cases_result[i] = sc.visit(btcs[i]);
            if (sc instanceof LabeledCase) {
                LabeledCase lc = (LabeledCase)sc;
                Integer toCheck = null;
                if (lc.getLabel() instanceof CharLiteral) {
                    toCheck = Autobox.valueOf((int)((CharLiteral)lc.getLabel()).getValue());
                }
                if (lc.getLabel() instanceof IntegerLiteral) {
                    toCheck = Autobox.valueOf(((IntegerLiteral)lc.getLabel()).getValue());
                }
                if (toCheck != null) {
                    if (labels.contains(toCheck)) {
                        BodyTypeChecker._addError(new StringBuffer().append("You cannot have two switch cases with the same label ").append(toCheck).toString(), lc.getLabel());
                    } else {
                        labels.add(toCheck);
                    }
                }
            } else {
                if (seenDefault) {
                    BodyTypeChecker._addError("A switch statement can only have one default case", sc);
                }
                seenDefault = true;
            }
            if (cases_result[i] != null || i == cases_result.length - 1) {
                if (!hadCaseReturn) {
                    variablesAssigned = btcs[i].thingsThatHaveBeenAssigned;
                    hadCaseReturn = true;
                } else {
                    Iterator iter = variablesAssigned.iterator();
                    while (iter.hasNext()) {
                        if (btcs[i].thingsThatHaveBeenAssigned.contains(iter.next())) continue;
                        iter.remove();
                    }
                }
            }
            this.unassignVariableDatas(btcs[i].thingsThatHaveBeenAssigned);
        }
        if (seenDefault) {
            for (VariableData vd : variablesAssigned) {
                vd.gotValue();
            }
        }
        return this.forSwitchStatementOnly(that, test_result, cases_result, seenDefault);
    }

    public TypeData forSwitchStatementOnly(SwitchStatement that, TypeData test_result, TypeData[] cases_result, boolean sawDefault) {
        if (!sawDefault) {
            return null;
        }
        for (int i = 0; i < cases_result.length; ++i) {
            if (cases_result[i] == null || cases_result[i].getSymbolData() != SymbolData.KEEP_GOING) continue;
            return null;
        }
        if (cases_result[cases_result.length - 1] == null) {
            return null;
        }
        return this._bodyData.getMethodData().getReturnType().getInstanceData();
    }

    @Override
    public TypeData forLabeledCase(LabeledCase that) {
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData label_result = that.getLabel().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        Expression exp = that.getLabel();
        if (label_result == null || !this.assertFound(label_result, exp)) {
            return null;
        }
        if (!(exp instanceof LexicalLiteral || exp instanceof NumericUnaryExpression && ((NumericUnaryExpression)exp).getValue() instanceof LexicalLiteral)) {
            BodyTypeChecker._addError(new StringBuffer().append("The labels of a switch statement must be constants.  You are using a more complicated expression of type ").append(label_result.getSymbolData().getName()).toString(), that.getLabel());
        } else if (!this._isAssignableFrom(SymbolData.INT_TYPE, label_result.getSymbolData())) {
            BodyTypeChecker._addError(new StringBuffer().append("The labels of a switch statement must be constants of int or char type.  You specified a constant of type ").append(label_result.getSymbolData().getName()).toString(), that.getLabel());
        }
        return this.forSwitchCase(that);
    }

    @Override
    public TypeData forDefaultCase(DefaultCase that) {
        return this.forSwitchCase(that);
    }

    public TypeData forSwitchCase(SwitchCase that) {
        TypeData code_result = that.getCode().visit(this);
        if (code_result == null && that.getCode().getStatements().length > 0) {
            BodyTypeChecker._addError("You must end a non-empty switch case with a break or return statement at the Advanced level", that);
        }
        return code_result;
    }

    @Override
    public TypeData forBlock(Block that) {
        BlockData bd = this._bodyData.getNextBlock();
        if (bd == null) {
            throw new RuntimeException("Internal Program Error: Enclosing body does not contain this block.  Please report this bug");
        }
        BodyTypeChecker btc = this.createANewInstanceOfMe(bd, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData statements_result = that.getStatements().visit(btc);
        this.thingsThatHaveBeenAssigned.addAll(btc.thingsThatHaveBeenAssigned);
        return statements_result;
    }

    @Override
    public TypeData forTypeOnly(Type that) {
        for (Data sd = this.getSymbolData(that.getName(), this._data, that); sd != null && !LanguageLevelVisitor.isJavaLibraryClass(((Data)sd).getSymbolData().getName()); sd = sd.getOuterData()) {
            if (BodyTypeChecker.checkAccessibility(that, sd.getMav(), sd.getName(), ((Data)sd).getSymbolData(), this._bodyData.getSymbolData(), "class")) continue;
            return null;
        }
        return null;
    }

    protected void checkDuplicateExceptions(TryCatchStatement that) {
        int i;
        LinkedList<SymbolData> catchBlockExceptions = new LinkedList<SymbolData>();
        CatchBlock[] catchBlocks = that.getCatchBlocks();
        for (i = 0; i < catchBlocks.length; ++i) {
            catchBlockExceptions.addLast(this.getSymbolData(catchBlocks[i].getException().getDeclarator().getType().getName(), this._data, catchBlocks[i].getException()));
        }
        for (i = 0; i < catchBlockExceptions.size(); ++i) {
            for (int j = i + 1; j < catchBlockExceptions.size(); ++j) {
                if (catchBlockExceptions.get(j) == null || !((SymbolData)catchBlockExceptions.get(j)).isSubClassOf((SymbolData)catchBlockExceptions.get(i))) continue;
                BodyTypeChecker._addError(new StringBuffer().append("Exception ").append(((SymbolData)catchBlockExceptions.get(j)).getName()).append(" has already been caught").toString(), catchBlocks[j].getException());
            }
        }
    }

    protected SymbolData getCommonSuperType(SymbolData s1, SymbolData s2) {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == SymbolData.KEEP_GOING && s2 != null) {
            return SymbolData.KEEP_GOING;
        }
        if (s2 == SymbolData.KEEP_GOING && s1 != null) {
            return SymbolData.KEEP_GOING;
        }
        if (s1 == null && s1 != SymbolData.KEEP_GOING) {
            return s2;
        }
        if (s2 == null && s1 != SymbolData.KEEP_GOING) {
            return s1;
        }
        if (s1 == null || s2 == null) {
            return null;
        }
        if (s1 == SymbolData.EXCEPTION) {
            return s2;
        }
        if (s2 == SymbolData.EXCEPTION) {
            return s1;
        }
        SymbolData sd = this.getCommonSuperTypeBaseCase(s1, s2);
        if (sd != null) {
            return sd;
        }
        sd = this.getCommonSuperTypeBaseCase(s2, s1);
        if (sd != null) {
            return sd;
        }
        if (s1.getSuperClass() == null) {
            return this.getSymbolData("java.lang.Object", this._data, new NullLiteral(JExprParser.NO_SOURCE_INFO));
        }
        sd = this.getCommonSuperType(s1.getSuperClass(), s2);
        if (sd != null) {
            return sd;
        }
        for (SymbolData currSd : s1.getInterfaces()) {
            sd = this.getCommonSuperType(currSd, s2);
            if (sd == null) continue;
            return sd;
        }
        return null;
    }

    protected boolean isException(SymbolData sd) {
        return sd == SymbolData.EXCEPTION || sd.isSubClassOf(this.getSymbolData("java.lang.Throwable", new NullLiteral(JExprParser.NO_SOURCE_INFO), false, false));
    }

    protected InstanceData tryCatchLeastRestrictiveType(InstanceData tryBlock_result, InstanceData[] catchBlocks_result, InstanceData finallyBlock_result) {
        if (tryBlock_result == null || tryBlock_result == SymbolData.KEEP_GOING.getInstanceData()) {
            return finallyBlock_result;
        }
        InstanceData leastRestrictiveType = tryBlock_result;
        for (int i = 0; i < catchBlocks_result.length; ++i) {
            if (catchBlocks_result[i] == null) {
                return finallyBlock_result;
            }
            if (catchBlocks_result[i] == SymbolData.KEEP_GOING.getInstanceData() || !this._isAssignableFrom(catchBlocks_result[i].getSymbolData(), ((TypeData)leastRestrictiveType).getSymbolData())) continue;
            leastRestrictiveType = catchBlocks_result[i];
        }
        if (leastRestrictiveType == null && finallyBlock_result == null) {
            return null;
        }
        SymbolData result = leastRestrictiveType == null ? this.getCommonSuperType(null, finallyBlock_result.getSymbolData()) : (finallyBlock_result == null ? this.getCommonSuperType(((TypeData)leastRestrictiveType).getSymbolData(), null) : this.getCommonSuperType(((TypeData)leastRestrictiveType).getSymbolData(), finallyBlock_result.getSymbolData()));
        if (result != null) {
            return result.getInstanceData();
        }
        return null;
    }

    @Override
    public boolean isUncaughtCheckedException(SymbolData sd, JExpression that) {
        if (this.isCheckedException(sd, that)) {
            MethodData md = this._bodyData.getMethodData();
            for (int i = 0; i < md.getThrown().length; ++i) {
                if (!sd.isSubClassOf(this.getSymbolData(md.getThrown()[i], this._data, that))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void makeSureCaughtStuffWasThrown(TryCatchStatement that, SymbolData[] caught_array, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        for (int i = 0; i < caught_array.length; ++i) {
            SymbolData currCaughtSD = caught_array[i];
            boolean foundThrownException = false;
            if (!this.isCheckedException(currCaughtSD, that) || currCaughtSD.getName().equals("java.lang.Exception") || currCaughtSD.getName().equals("java.lang.Throwable")) continue;
            for (Pair pair : thrown) {
                SymbolData sd = (SymbolData)pair.getFirst();
                if (!sd.isSubClassOf(currCaughtSD)) continue;
                foundThrownException = true;
            }
            if (foundThrownException) continue;
            BodyTypeChecker._addError(new StringBuffer().append("The exception ").append(currCaughtSD.getName()).append(" is never thrown in the body of the corresponding try block").toString(), that.getCatchBlocks()[i]);
        }
    }

    protected void compareThrownAndCaught(TryCatchStatement that, SymbolData[] caught_array, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        LinkedList<SymbolData> caught = new LinkedList<SymbolData>();
        for (int i = 0; i < caught_array.length; ++i) {
            caught.addLast(caught_array[i]);
        }
        for (Pair pair : thrown) {
            JExpression j;
            SymbolData sd = (SymbolData)pair.getFirst();
            if (!this.isUncaughtCheckedException(sd, j = (JExpression)pair.getSecond())) continue;
            boolean foundCatchBlock = false;
            for (SymbolData currCaughtSD : caught) {
                if (!sd.isSubClassOf(currCaughtSD)) continue;
                foundCatchBlock = true;
            }
            if (foundCatchBlock) continue;
            this.handleUncheckedException(sd, j);
        }
        this.makeSureCaughtStuffWasThrown(that, caught_array, thrown);
    }

    public TypeData forTryCatchFinallyStatementOnly(TryCatchFinallyStatement that, TypeData tryBlock_result, TypeData[] catchBlocks_result, TypeData finallyBlock_result) {
        this.checkDuplicateExceptions(that);
        InstanceData[] ids = new InstanceData[catchBlocks_result.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = catchBlocks_result[i] != null ? catchBlocks_result[i].getInstanceData() : null;
        }
        if (tryBlock_result == null && finallyBlock_result == null) {
            return this.tryCatchLeastRestrictiveType(null, ids, null);
        }
        if (tryBlock_result == null) {
            return this.tryCatchLeastRestrictiveType(null, ids, finallyBlock_result.getInstanceData());
        }
        if (finallyBlock_result == null) {
            return this.tryCatchLeastRestrictiveType(tryBlock_result.getInstanceData(), ids, null);
        }
        return this.tryCatchLeastRestrictiveType(tryBlock_result.getInstanceData(), ids, finallyBlock_result.getInstanceData());
    }

    @Override
    public TypeData forTryCatchFinallyStatement(TryCatchFinallyStatement that) {
        TryCatchBodyTypeChecker btc = new TryCatchBodyTypeChecker(this._bodyData, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this.cloneVariableDataList(this._vars), new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData tryBlock_result = that.getTryBlock().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        BodyTypeChecker[] catchTCs = new BodyTypeChecker[that.getCatchBlocks().length];
        LinkedList<LinkedList<VariableData>> catchVars = new LinkedList<LinkedList<VariableData>>();
        CatchBlock[] catchBlocks = that.getCatchBlocks();
        TypeData[] catchBlocks_result = this.makeArrayOfRetType(catchBlocks.length);
        SymbolData[] caughtExceptions = new SymbolData[catchBlocks.length];
        for (int i = 0; i < catchBlocks.length; ++i) {
            catchTCs[i] = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
            catchBlocks_result[i] = catchBlocks[i].visit(catchTCs[i]);
            this.unassignVariableDatas(catchTCs[i].thingsThatHaveBeenAssigned);
            catchVars.addLast(catchTCs[i].thingsThatHaveBeenAssigned);
            caughtExceptions[i] = this.getSymbolData(catchBlocks[i].getException().getDeclarator().getType().getName(), this._data, catchBlocks[i]);
        }
        BodyTypeChecker btcFinally = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
        TypeData finallyBlock_result = that.getFinallyBlock().visit(btcFinally);
        this.reassignLotsaVariableDatas(btc.thingsThatHaveBeenAssigned, catchVars);
        if (finallyBlock_result == null) {
            this.compareThrownAndCaught(that, caughtExceptions, btc._thrown);
        } else {
            this._thrown = new LinkedList();
        }
        if (finallyBlock_result == SymbolData.KEEP_GOING.getInstanceData()) {
            finallyBlock_result = null;
        }
        if (this instanceof TryCatchBodyTypeChecker) {
            this._thrown.addAll(btc._thrown);
        }
        return this.forTryCatchFinallyStatementOnly(that, tryBlock_result, catchBlocks_result, finallyBlock_result);
    }

    @Override
    public TypeData forCatchBlock(CatchBlock that) {
        VariableDeclarator dec = that.getException().getDeclarator();
        SymbolData exception_result = this.getSymbolData(dec.getType().getName(), this._data, dec.getType());
        BlockData bd = this._bodyData.getNextBlock();
        if (bd == null) {
            throw new RuntimeException("Internal Program Error: Enclosing body does not contain this block.  Please report this bug");
        }
        VariableData vd = bd.getVar(dec.getName().getText());
        if (vd == null) {
            throw new RuntimeException("Internal Program Error: Catch block does not contain its exception variable.  Please report this bug");
        }
        LinkedList<VariableData> newVars = this.cloneVariableDataList(this._vars);
        newVars.addLast(vd);
        BodyTypeChecker btc = this.createANewInstanceOfMe(bd, this._file, this._package, this._importedFiles, this._importedPackages, newVars, this._thrown);
        TypeData block_result = that.getBlock().getStatements().visit(btc);
        this.thingsThatHaveBeenAssigned.addAll(btc.thingsThatHaveBeenAssigned);
        return this.forCatchBlockOnly(that, exception_result, block_result);
    }

    @Override
    public TypeData forCatchBlockOnly(CatchBlock that, SymbolData exception_result, TypeData block_result) {
        return block_result;
    }

    public TypeData forNormalTryCatchStatementOnly(NormalTryCatchStatement that, TypeData tryBlock_result, TypeData[] catchBlocks_result) {
        this.checkDuplicateExceptions(that);
        InstanceData[] ids = new InstanceData[catchBlocks_result.length];
        for (int i = 0; i < catchBlocks_result.length; ++i) {
            ids[i] = (InstanceData)catchBlocks_result[i];
        }
        return this.tryCatchLeastRestrictiveType((InstanceData)tryBlock_result, ids, null);
    }

    @Override
    public TypeData forNormalTryCatchStatement(NormalTryCatchStatement that) {
        TryCatchBodyTypeChecker btc = new TryCatchBodyTypeChecker(this._bodyData, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this.cloneVariableDataList(this._vars), new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData tryBlock_result = that.getTryBlock().visit(btc);
        this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        LinkedList<LinkedList<VariableData>> catchVars = new LinkedList<LinkedList<VariableData>>();
        BodyTypeChecker[] catchTCs = new BodyTypeChecker[that.getCatchBlocks().length];
        CatchBlock[] catchBlocks = that.getCatchBlocks();
        TypeData[] catchBlocks_result = this.makeArrayOfRetType(catchBlocks.length);
        SymbolData[] caughtExceptions = new SymbolData[catchBlocks.length];
        for (int i = 0; i < catchBlocks.length; ++i) {
            catchTCs[i] = this.createANewInstanceOfMe(this._bodyData, this._file, this._package, this._importedFiles, this._importedPackages, this.cloneVariableDataList(this._vars), this._thrown);
            catchBlocks_result[i] = catchBlocks[i].visit(catchTCs[i]);
            this.unassignVariableDatas(catchTCs[i].thingsThatHaveBeenAssigned);
            catchVars.addLast(catchTCs[i].thingsThatHaveBeenAssigned);
            caughtExceptions[i] = this.getSymbolData(catchBlocks[i].getException().getDeclarator().getType().getName(), this._data, catchBlocks[i]);
        }
        this.reassignLotsaVariableDatas(btc.thingsThatHaveBeenAssigned, catchVars);
        this.compareThrownAndCaught(that, caughtExceptions, btc._thrown);
        if (this instanceof TryCatchBodyTypeChecker) {
            this._thrown.addAll(btc._thrown);
        }
        return this.forNormalTryCatchStatementOnly(that, tryBlock_result, catchBlocks_result);
    }

    @Override
    public Object forCatchBlock(CatchBlock x0) {
        return this.forCatchBlock(x0);
    }

    @Override
    public Object forDefaultCase(DefaultCase x0) {
        return this.forDefaultCase(x0);
    }

    @Override
    public Object forLabeledCase(LabeledCase x0) {
        return this.forLabeledCase(x0);
    }

    @Override
    public Object forNormalTryCatchStatement(NormalTryCatchStatement x0) {
        return this.forNormalTryCatchStatement(x0);
    }

    @Override
    public Object forTryCatchFinallyStatement(TryCatchFinallyStatement x0) {
        return this.forTryCatchFinallyStatement(x0);
    }

    @Override
    public Object forValueReturnStatement(ValueReturnStatement x0) {
        return this.forValueReturnStatement(x0);
    }

    @Override
    public Object forForStatement(ForStatement x0) {
        return this.forForStatement(x0);
    }

    @Override
    public Object forDoStatement(DoStatement x0) {
        return this.forDoStatement(x0);
    }

    @Override
    public Object forWhileStatement(WhileStatement x0) {
        return this.forWhileStatement(x0);
    }

    @Override
    public Object forIfThenElseStatement(IfThenElseStatement x0) {
        return this.forIfThenElseStatement(x0);
    }

    @Override
    public Object forIfThenStatement(IfThenStatement x0) {
        return this.forIfThenStatement(x0);
    }

    @Override
    public Object forSwitchStatement(SwitchStatement x0) {
        return this.forSwitchStatement(x0);
    }

    @Override
    public Object forBlock(Block x0) {
        return this.forBlock(x0);
    }

    @Override
    public Object forInstanceInitializer(InstanceInitializer x0) {
        return this.forInstanceInitializer(x0);
    }

    @Override
    public Object forUnbracedBodyOnly(UnbracedBody x0, Object[] x1) {
        return this.forUnbracedBodyOnly(x0, (TypeData[])x1);
    }

    @Override
    public Object forBracedBodyOnly(BracedBody x0, Object[] x1) {
        return this.forBracedBodyOnly(x0, (TypeData[])x1);
    }

    @Override
    public Object forBodyOnly(Body x0, Object[] x1) {
        return this.forBodyOnly(x0, (TypeData[])x1);
    }

    @Override
    public Object forSimpleSuperReferenceOnly(SimpleSuperReference x0) {
        return this.forSimpleSuperReferenceOnly(x0);
    }

    @Override
    public Object forSimpleThisReferenceOnly(SimpleThisReference x0) {
        return this.forSimpleThisReferenceOnly(x0);
    }

    @Override
    public Object forTypeOnly(Type x0) {
        return this.forTypeOnly(x0);
    }

    @Override
    public Object forUninitializedVariableDeclaratorOnly(UninitializedVariableDeclarator x0, Object x1, Object x2) {
        return this.forUninitializedVariableDeclaratorOnly(x0, (TypeData)x1, (TypeData)x2);
    }

    @Override
    public Object forNormalTryCatchStatementOnly(NormalTryCatchStatement x0, Object x1, Object[] x2) {
        return this.forNormalTryCatchStatementOnly(x0, (TypeData)x1, (TypeData[])x2);
    }

    @Override
    public Object forTryCatchFinallyStatementOnly(TryCatchFinallyStatement x0, Object x1, Object[] x2, Object x3) {
        return this.forTryCatchFinallyStatementOnly(x0, (TypeData)x1, (TypeData[])x2, (TypeData)x3);
    }

    @Override
    public Object forValueReturnStatementOnly(ValueReturnStatement x0, Object x1) {
        return this.forValueReturnStatementOnly(x0, (TypeData)x1);
    }

    @Override
    public Object forVoidReturnStatementOnly(VoidReturnStatement x0) {
        return this.forVoidReturnStatementOnly(x0);
    }

    @Override
    public Object forForStatementOnly(ForStatement x0, Object x1, Object x2, Object x3, Object x4) {
        return this.forForStatementOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData)x3, (TypeData)x4);
    }

    @Override
    public Object forDoStatementOnly(DoStatement x0, Object x1, Object x2) {
        return this.forDoStatementOnly(x0, (TypeData)x1, (TypeData)x2);
    }

    @Override
    public Object forWhileStatementOnly(WhileStatement x0, Object x1, Object x2) {
        return this.forWhileStatementOnly(x0, (TypeData)x1, (TypeData)x2);
    }

    @Override
    public Object forIfThenElseStatementOnly(IfThenElseStatement x0, Object x1, Object x2, Object x3) {
        return this.forIfThenElseStatementOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData)x3);
    }

    @Override
    public Object forIfThenStatementOnly(IfThenStatement x0, Object x1, Object x2) {
        return this.forIfThenStatementOnly(x0, (TypeData)x1, (TypeData)x2);
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class NoAssignmentAllowedInExpression
    extends JExpressionIFAbstractVisitor<Boolean> {
        String _location;

        private NoAssignmentAllowedInExpression(String location) {
            this._location = location;
        }

        @Override
        public Boolean defaultCase(JExpressionIF that) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean forIncrementExpression(IncrementExpression that) {
            TypeChecker._addError(new StringBuffer().append("You cannot use an increment or decrement expression in ").append(this._location).append(" at any language level").toString(), that);
            return Boolean.FALSE;
        }

        @Override
        public Boolean forAssignmentExpression(AssignmentExpression that) {
            TypeChecker._addError(new StringBuffer().append("You cannot use an assignment expression in ").append(this._location).append(" at any language level").toString(), that);
            return Boolean.FALSE;
        }

        @Override
        public Boolean forSimpleAssignmentExpression(SimpleAssignmentExpression that) {
            TypeChecker._addError(new StringBuffer().append("You cannot use an assignment expression in ").append(this._location).append(" at any language level").append(".  Perhaps you meant to compare two values with '=='").toString(), that);
            return Boolean.FALSE;
        }

        @Override
        public Object forIncrementExpression(IncrementExpression x0) {
            return this.forIncrementExpression(x0);
        }

        @Override
        public Object forSimpleAssignmentExpression(SimpleAssignmentExpression x0) {
            return this.forSimpleAssignmentExpression(x0);
        }

        @Override
        public Object forAssignmentExpression(AssignmentExpression x0) {
            return this.forAssignmentExpression(x0);
        }

        @Override
        public Object defaultCase(JExpressionIF x0) {
            return this.defaultCase(x0);
        }

        NoAssignmentAllowedInExpression(String x1, 1 x2) {
            this(x1);
        }
    }
}

