/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import java.io.File;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RMIInteractionsModel
extends InteractionsModel {
    protected final MainJVM _jvm;

    public RMIInteractionsModel(MainJVM jvm, ConsoleDocumentInterface adapter, File wd, int historySize, int writeDelay) {
        super(adapter, wd, historySize, writeDelay);
        this._jvm = jvm;
    }

    @Override
    protected void _interpret(String toEval) {
        this._jvm.interpret(toEval);
    }

    @Override
    public String getVariableToString(String var) {
        return this._jvm.getVariableToString(var);
    }

    @Override
    public String getVariableClassName(String var) {
        return this._jvm.getVariableClassName(var);
    }

    @Override
    public void addProjectClassPath(File f) {
        this._jvm.addProjectClassPath(f);
    }

    @Override
    public void addBuildDirectoryClassPath(File f) {
        this._jvm.addBuildDirectoryClassPath(f);
    }

    @Override
    public void addProjectFilesClassPath(File f) {
        this._jvm.addProjectFilesClassPath(f);
    }

    @Override
    public void addExternalFilesClassPath(File f) {
        this._jvm.addExternalFilesClassPath(f);
    }

    @Override
    public void addExtraClassPath(File f) {
        this._jvm.addExtraClassPath(f);
    }

    @Override
    protected void _resetInterpreter(File wd) {
        this._jvm.killInterpreter(wd);
    }

    public void addJavaInterpreter(String name) {
        this._jvm.addJavaInterpreter(name);
    }

    public void addDebugInterpreter(String name, String className) {
        this._jvm.addDebugInterpreter(name, className);
    }

    public void removeInterpreter(String name) {
        this._jvm.removeInterpreter(name);
    }

    public void setActiveInterpreter(String name, String prompt) {
        String currName = this._jvm.getCurrentInterpreterName();
        boolean inProgress = this._jvm.setActiveInterpreter(name);
        this._updateDocument(prompt, inProgress, !currName.equals(name));
        this._notifyInterpreterChanged(inProgress);
    }

    public void setToDefaultInterpreter() {
        String currName = this._jvm.getCurrentInterpreterName();
        boolean printPrompt = !"DEFAULT".equals(currName);
        boolean inProgress = this._jvm.setToDefaultInterpreter();
        this._updateDocument("> ", inProgress, printPrompt);
        this._notifyInterpreterChanged(inProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateDocument(String prompt, boolean inProgress, boolean updatePrompt) {
        if (updatePrompt) {
            this._document.acquireWriteLock();
            try {
                this._document.setPrompt(prompt);
                this._document.insertNewLine(this._document.getLength());
                this._document.insertPrompt();
            }
            finally {
                this._document.releaseWriteLock();
            }
        }
        this._document.setInProgress(inProgress);
    }

    protected abstract void _notifyInterpreterChanged(boolean var1);

    public void setPrivateAccessible(boolean allow) {
        this._jvm.setPrivateAccessible(allow);
    }

    public Iterable<File> getClassPath() {
        return this._jvm.getClassPath();
    }

    public void enableRestart() {
        this._jvm.enableRestart();
    }
}

