/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.DynamicJavaAdapter;
import edu.rice.cs.drjava.model.repl.IdentityVisitor;
import edu.rice.cs.drjava.model.repl.newjvm.ClassPathManager;
import edu.rice.cs.util.UnexpectedException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import koala.dynamicjava.interpreter.AbstractTypeChecker;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.interpreter.TypeChecker14;
import koala.dynamicjava.interpreter.TypeChecker15;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.MethodCall;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.ThisExpression;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDebugInterpreter
extends DynamicJavaAdapter {
    protected final String _name;
    protected String _thisClassName;
    protected String _thisPackageName;
    protected IdentityVisitor _translationVisitor;

    public JavaDebugInterpreter(String name, String className) {
        super(new ClassPathManager());
        this._name = name;
        this.setClassName(className);
        this._translationVisitor = this.makeTranslationVisitor();
    }

    @Override
    public Node processTree(Node node) {
        return node.acceptVisitor(this._translationVisitor);
    }

    @Override
    public GlobalContext makeGlobalContext(TreeInterpreter i) {
        return new GlobalContext(i){

            public boolean exists(String name) {
                return super.exists(name) || JavaDebugInterpreter.this._getObjectFieldAccessForField(name, this) != null || JavaDebugInterpreter.this._getStaticFieldAccessForField(name, this) != null || JavaDebugInterpreter.this._getReferenceTypeForField(name, this) != null;
            }
        };
    }

    private boolean hasAnonymous(String className) {
        StringTokenizer st = new StringTokenizer(className, "$");
        while (st.hasMoreElements()) {
            String currToken = st.nextToken();
            try {
                Integer.valueOf(currToken);
                return true;
            }
            catch (NumberFormatException nfe) {
            }
        }
        return false;
    }

    private String _getFullyQualifiedClassNameForThis() {
        String cName = this._thisClassName;
        if (!this._thisPackageName.equals("")) {
            cName = new StringBuffer().append(this._thisPackageName).append(".").append(cName).toString();
        }
        return cName;
    }

    private Class<?> _loadClassForThis(Context context) {
        try {
            return context.lookupClass(this._getFullyQualifiedClassNameForThis());
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(e);
        }
    }

    protected ObjectFieldAccess _getObjectFieldAccessForField(String field, Context context) {
        AbstractTypeChecker tc = this.makeTypeChecker(context);
        int numDollars = this._getNumDollars(this._thisClassName);
        if (this.hasAnonymous(this._thisClassName)) {
            Class<?> c = this._loadClassForThis(context);
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith("this$")) continue;
                String fieldName = fields[i].getName();
                int lastIndex = fieldName.lastIndexOf("$");
                numDollars = Integer.valueOf(fieldName.substring(lastIndex + 1, fieldName.length())) + 1;
                break;
            }
        }
        for (int i = 0; i <= numDollars; ++i) {
            Expression expr = this._buildObjectFieldAccess(i, numDollars);
            ObjectFieldAccess newExpr = new ObjectFieldAccess(expr, field);
            try {
                tc.visit(newExpr);
                return newExpr;
            }
            catch (ExecutionError e) {
                newExpr = new ObjectFieldAccess(expr, new StringBuffer().append("val$").append(field).toString());
                try {
                    tc.visit(newExpr);
                    return newExpr;
                }
                catch (ExecutionError e2) {
                    continue;
                }
            }
        }
        return null;
    }

    protected ObjectMethodCall _getObjectMethodCallForFunction(MethodCall method, Context context) {
        AbstractTypeChecker tc = this.makeTypeChecker(context);
        int numDollars = this._getNumDollars(this._thisClassName);
        String methodName = method.getMethodName();
        List<Expression> args = method.getArguments();
        if (this.hasAnonymous(this._thisClassName)) {
            Class<?> c = this._loadClassForThis(context);
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith("this$")) continue;
                String fieldName = fields[i].getName();
                int lastIndex = fieldName.lastIndexOf("$");
                numDollars = Integer.valueOf(fieldName.substring(lastIndex + 1, fieldName.length())) + 1;
                break;
            }
        }
        for (int i = 0; i <= numDollars; ++i) {
            Expression expr = this._buildObjectFieldAccess(i, numDollars);
            expr = new ObjectMethodCall(expr, methodName, args, null, 0, 0, 0, 0);
            try {
                tc.visit((ObjectMethodCall)expr);
                return (ObjectMethodCall)expr;
            }
            catch (ExecutionError e2) {
                continue;
            }
        }
        return null;
    }

    protected StaticFieldAccess _getStaticFieldAccessForField(String field, Context context) {
        AbstractTypeChecker tc = this.makeTypeChecker(context);
        int numDollars = this._getNumDollars(this._thisClassName);
        String currClass = this._getFullyQualifiedClassNameForThis();
        int index = currClass.length();
        for (int i = 0; i <= numDollars; ++i) {
            currClass = currClass.substring(0, index);
            ReferenceType rt = new ReferenceType(currClass);
            StaticFieldAccess expr = new StaticFieldAccess(rt, field);
            try {
                tc.visit(expr);
                return expr;
            }
            catch (ExecutionError e2) {
                index = currClass.lastIndexOf("$");
                continue;
            }
        }
        return null;
    }

    protected StaticMethodCall _getStaticMethodCallForFunction(MethodCall method, Context context) {
        AbstractTypeChecker tc = this.makeTypeChecker(context);
        int numDollars = this._getNumDollars(this._thisClassName);
        String methodName = method.getMethodName();
        List<Expression> args = method.getArguments();
        String currClass = this._getFullyQualifiedClassNameForThis();
        int index = currClass.length();
        for (int i = 0; i <= numDollars; ++i) {
            currClass = currClass.substring(0, index);
            ReferenceType rt = new ReferenceType(currClass);
            StaticMethodCall expr = new StaticMethodCall(rt, methodName, args);
            try {
                tc.visit(expr);
                return expr;
            }
            catch (ExecutionError e2) {
                index = currClass.lastIndexOf("$");
                continue;
            }
        }
        return null;
    }

    protected ReferenceType _getReferenceTypeForField(String field, Context context) {
        AbstractTypeChecker tc = this.makeTypeChecker(context);
        int index = this._indexOfWithinBoundaries(this._getFullyQualifiedClassNameForThis(), field);
        if (index != -1) {
            int lastDollar = field.lastIndexOf("$");
            int lastDot = field.lastIndexOf(".");
            if (lastDollar != -1) {
                field = field.substring(lastDollar + 1, field.length());
            } else if (lastDot != -1) {
                field = field.substring(lastDot + 1, field.length());
            }
            LinkedList<IdentifierToken> list = new LinkedList<IdentifierToken>();
            StringTokenizer st = new StringTokenizer(this._getFullyQualifiedClassNameForThis(), "$.");
            String currString = st.nextToken();
            while (!currString.equals(field)) {
                list.add(new Identifier(currString));
                currString = st.nextToken();
            }
            list.add(new Identifier(field));
            ReferenceType rt = new ReferenceType(list);
            try {
                tc.visit(rt);
                return rt;
            }
            catch (ExecutionError e) {
                return null;
            }
        }
        return null;
    }

    protected void setClassName(String className) {
        int indexLastDot = className.lastIndexOf(".");
        this._thisPackageName = indexLastDot == -1 ? "" : className.substring(0, indexLastDot);
        this._thisClassName = className.substring(indexLastDot + 1);
    }

    protected QualifiedName _convertThisToName(ThisExpression node) {
        LinkedList<IdentifierToken> ids = new LinkedList<IdentifierToken>();
        ids.add(new Identifier("this", node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn()));
        return new QualifiedName(ids, node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
    }

    protected Expression _convertThisToObjectFieldAccess(ThisExpression node) {
        String className = node.getClassName();
        int numToWalk = this.verifyClassName(className);
        int numDollars = this._getNumDollars(this._thisClassName);
        if (numToWalk == -1) {
            throw new ExecutionError("malformed.expression", node);
        }
        return this._buildObjectFieldAccess(numToWalk, numDollars);
    }

    protected ThisExpression buildUnqualifiedThis() {
        LinkedList<IdentifierToken> ids = new LinkedList<IdentifierToken>();
        return new ThisExpression(ids, "", 0, 0, 0, 0);
    }

    private Expression _buildObjectFieldAccess(int numToWalk, int numDollars) {
        if (numToWalk == 0) {
            return this._convertThisToName(this.buildUnqualifiedThis());
        }
        return new ObjectFieldAccess(this._buildObjectFieldAccess(numToWalk - 1, numDollars), new StringBuffer().append("this$").append(numDollars - numToWalk).toString());
    }

    private int _indexOfWithinBoundaries(String string, String subString) {
        int index = string.indexOf(subString);
        if (index == -1) {
            return index;
        }
        if (!(string.length() != subString.length() + index && string.charAt(subString.length() + index) != '$' || index != 0 && string.charAt(index - 1) != '$' && string.charAt(index - 1) != '.')) {
            return index;
        }
        return -1;
    }

    private int _getNumDollars(String className) {
        int numDollars = 0;
        int index = className.indexOf("$");
        while (index != -1) {
            ++numDollars;
            index = className.indexOf("$", index + 1);
        }
        return numDollars;
    }

    protected int verifyClassName(String className) {
        int index;
        boolean hasPackage = false;
        if (!this._thisPackageName.equals("") && (index = className.indexOf(this._thisPackageName)) == 0) {
            hasPackage = true;
            index = this._thisPackageName.length() + 1;
            if (index >= className.length()) {
                return -1;
            }
            className = className.substring(index, className.length());
        }
        className = className.replace('.', '$');
        int indexWithBoundaries = this._indexOfWithinBoundaries(this._thisClassName, className);
        if (hasPackage && indexWithBoundaries != 0 || indexWithBoundaries == -1) {
            return -1;
        }
        return this._getNumDollars(this._thisClassName.substring(indexWithBoundaries + className.length()));
    }

    protected Expression visitThis(ThisExpression node) {
        if (node.getClassName().equals("")) {
            return this._convertThisToName(node);
        }
        return this._convertThisToObjectFieldAccess(node);
    }

    public IdentityVisitor makeTranslationVisitor() {
        return new IdentityVisitor(){

            public Node visit(ThisExpression node) {
                Expression e = JavaDebugInterpreter.this.visitThis(node);
                if (e instanceof QualifiedName) {
                    return this.visit((QualifiedName)e);
                }
                if (e instanceof ObjectFieldAccess) {
                    return this.visit((ObjectFieldAccess)e);
                }
                throw new UnexpectedException(new IllegalArgumentException("Illegal type of Expression"));
            }

            public Object visit(ThisExpression x0) {
                return this.visit(x0);
            }
        };
    }

    @Override
    public NameVisitor makeNameVisitor(final Context nameContext) {
        return new NameVisitor(nameContext){

            public Node visit(QualifiedName node) {
                try {
                    return super.visit(node);
                }
                catch (ExecutionError e) {
                    List<IdentifierToken> ids = node.getIdentifiers();
                    Iterator<IdentifierToken> iter = ids.iterator();
                    StringBuffer fieldBuf = new StringBuffer(iter.next().image());
                    while (iter.hasNext()) {
                        IdentifierToken t = iter.next();
                        fieldBuf.append('$').append(t.image());
                    }
                    String field = fieldBuf.toString();
                    if (nameContext.isDefined("this")) {
                        ObjectFieldAccess ofa = JavaDebugInterpreter.this._getObjectFieldAccessForField(field, nameContext);
                        if (ofa != null) {
                            return ofa;
                        }
                    } else {
                        StaticFieldAccess sfa = JavaDebugInterpreter.this._getStaticFieldAccessForField(field, nameContext);
                        if (sfa != null) {
                            return sfa;
                        }
                        ReferenceType rt = JavaDebugInterpreter.this._getReferenceTypeForField(field, nameContext);
                        if (rt != null) {
                            return rt;
                        }
                    }
                    throw e;
                }
            }

            public Node visit(ObjectMethodCall node) {
                MethodCall method = (MethodCall)super.visit(node);
                if (method != null) {
                    if (method instanceof StaticMethodCall) {
                        return method;
                    }
                    if (nameContext.isDefined("this")) {
                        ObjectMethodCall omc = JavaDebugInterpreter.this._getObjectMethodCallForFunction(method, nameContext);
                        if (omc != null) {
                            return omc;
                        }
                        return method;
                    }
                    StaticMethodCall smc = JavaDebugInterpreter.this._getStaticMethodCallForFunction(method, nameContext);
                    if (smc != null) {
                        return smc;
                    }
                    return method;
                }
                return null;
            }

            public Object visit(ObjectMethodCall x0) {
                return this.visit(x0);
            }

            public Object visit(QualifiedName x0) {
                return this.visit(x0);
            }
        };
    }

    public AbstractTypeChecker makeTypeChecker(Context context) {
        if ((double)Float.valueOf(System.getProperty("java.specification.version")).floatValue() < 1.5) {
            return new TypeChecker14(context){

                @Override
                public Class<?> visit(QualifiedName node) {
                    String var = node.getRepresentation();
                    if ("this".equals(var)) {
                        Class c = JavaDebugInterpreter.access$000(JavaDebugInterpreter.this, this.context);
                        node.setProperty("type", c);
                        node.setProperty("modifier", this.context.getModifier(node));
                        return c;
                    }
                    return super.visit(node);
                }

                @Override
                public Object visit(QualifiedName x0) {
                    return this.visit(x0);
                }
            };
        }
        return new TypeChecker15(context){

            @Override
            public Class<?> visit(QualifiedName node) {
                String var = node.getRepresentation();
                if ("this".equals(var)) {
                    Class c = JavaDebugInterpreter.access$000(JavaDebugInterpreter.this, this.context);
                    node.setProperty("type", c);
                    node.setProperty("modifier", this.context.getModifier(node));
                    return c;
                }
                return super.visit(node);
            }

            @Override
            public Object visit(QualifiedName x0) {
                return this.visit(x0);
            }
        };
    }

    static Class access$000(JavaDebugInterpreter x0, Context x1) {
        return x0._loadClassForThis(x1);
    }
}

