/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.model.repl.History;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.EditDocumentException;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsDocument
extends ConsoleDocument {
    public static final String DEFAULT_PROMPT = "> ";
    public static final String ERROR_STYLE = "error";
    public static final String DEBUGGER_STYLE = "debugger";
    public static final String OBJECT_RETURN_STYLE = "object.return.style";
    public static final String STRING_RETURN_STYLE = "string.return.style";
    public static final String CHARACTER_RETURN_STYLE = "character.return.style";
    public static final String NUMBER_RETURN_STYLE = "number.return.style";
    private final History _history;

    public InteractionsDocument(ConsoleDocumentInterface document, String banner) {
        this(document, new History(), banner);
    }

    public InteractionsDocument(ConsoleDocumentInterface document, int maxHistorySize, String banner) {
        this(document, new History(maxHistorySize), banner);
    }

    public InteractionsDocument(ConsoleDocumentInterface document, History history, String banner) {
        super(document);
        this._history = history;
        this._document.setHasPrompt(true);
        this._prompt = DEFAULT_PROMPT;
        this.reset(banner);
    }

    public void setInProgress(boolean inProgress) {
        this._document.setHasPrompt(!inProgress);
    }

    public boolean inProgress() {
        return !this._document.hasPrompt();
    }

    @Override
    public void reset(String banner) {
        this.acquireWriteLock();
        try {
            this.setHasPrompt(false);
            this.setPromptPos(0);
            this.removeText(0, this._document.getLength());
            this.insertText(0, banner, OBJECT_RETURN_STYLE);
            this.insertPrompt();
            this._history.moveEnd();
            this.setInProgress(false);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void _replaceCurrentLineFromHistory() {
        try {
            this._clearCurrentInputText();
            this.append(this._history.getCurrent(), "default");
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public OptionListener<Integer> getHistoryOptionListener() {
        return this._history.getHistoryOptionListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(String text) {
        this.acquireWriteLock();
        try {
            this._history.add(text);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeLastFromHistory() {
        this.acquireWriteLock();
        try {
            String string = this._history.removeLast();
            return string;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHistory(FileSaveSelector selector) throws IOException {
        this.acquireReadLock();
        try {
            this._history.writeToFile(selector);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        this.acquireReadLock();
        try {
            History.writeToFile(selector, editedVersion);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsStringWithSemicolons() {
        this.acquireReadLock();
        try {
            String string = this._history.getHistoryAsStringWithSemicolons();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsString() {
        this.acquireReadLock();
        try {
            String string = this._history.getHistoryAsString();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        this.acquireWriteLock();
        try {
            this._history.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastEntry() {
        this.acquireReadLock();
        try {
            String string = this._history.lastEntry();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHistoryPrevious(String entry) {
        this.acquireWriteLock();
        try {
            this._history.movePrevious(entry);
            this._replaceCurrentLineFromHistory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHistoryNext(String entry) {
        this.acquireWriteLock();
        try {
            this._history.moveNext(entry);
            this._replaceCurrentLineFromHistory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private boolean hasHistoryPrevious() {
        return this._history.hasPrevious();
    }

    public boolean hasHistoryNext() {
        return this._history.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseHistorySearch(String searchString) {
        this.acquireWriteLock();
        try {
            this._history.reverseSearch(searchString);
            this._replaceCurrentLineFromHistory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardHistorySearch(String searchString) {
        this.acquireWriteLock();
        try {
            this._history.forwardSearch(searchString);
            this._replaceCurrentLineFromHistory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean recallPreviousInteractionInHistory() {
        if (this.hasHistoryPrevious()) {
            this.moveHistoryPrevious(this.getCurrentInteraction());
            return true;
        }
        this._beep.run();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recallNextInteractionInHistory() {
        this.acquireWriteLock();
        try {
            if (this.hasHistoryNext()) {
                this.moveHistoryNext(this.getCurrentInteraction());
                boolean bl = true;
                return bl;
            }
            this._beep.run();
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseSearchInteractionsInHistory() {
        this.acquireWriteLock();
        try {
            if (this.hasHistoryPrevious()) {
                this.reverseHistorySearch(this.getCurrentInteraction());
            } else {
                this._beep.run();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardSearchInteractionsInHistory() {
        this.acquireWriteLock();
        try {
            if (this.hasHistoryNext()) {
                this.forwardHistorySearch(this.getCurrentInteraction());
            } else {
                this._beep.run();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void appendExceptionResult(String exceptionClass, String message, String stackTrace, String styleName) {
        block14: {
            String c;
            if (message != null && message.equals("Connection refused to host: 127.0.0.1; nested exception is: \n\tjava.net.ConnectException: Connection refused: connect")) {
                return;
            }
            if (null == message || "null".equals(message)) {
                message = "";
            }
            if ("koala.dynamicjava.interpreter.error.ExecutionError".equals(exceptionClass) || "edu.rice.cs.drjava.model.repl.InteractionsException".equals(exceptionClass)) {
                exceptionClass = "Error";
            }
            if ((c = exceptionClass).indexOf(46) != -1) {
                c = c.substring(c.lastIndexOf(46) + 1, c.length());
            }
            this.acquireWriteLock();
            try {
                String line;
                this.append(new StringBuffer().append(c).append(": ").append(message).append("\n").toString(), styleName);
                if (stackTrace.trim().equals("")) break block14;
                BufferedReader reader = new BufferedReader(new StringReader(stackTrace));
                while ((line = reader.readLine()) != null) {
                    int colonLoc;
                    int closeLoc;
                    int openLoc = line.indexOf(40);
                    if (openLoc != -1 && (closeLoc = line.indexOf(41, openLoc + 1)) != -1 && (colonLoc = line.indexOf(58, openLoc + 1)) > openLoc && colonLoc < closeLoc) {
                        String lineNumStr = line.substring(colonLoc + 1, closeLoc);
                        try {
                            int lineNumber = Integer.parseInt(lineNumStr);
                            String fileName = line.substring(openLoc + 1, colonLoc);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    this.append(line, styleName);
                    this.append("\n", styleName);
                }
            }
            catch (IOException ioe) {
                throw new UnexpectedException(ioe);
            }
            catch (EditDocumentException ble) {
                throw new UnexpectedException(ble);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    public void appendSyntaxErrorResult(String message, String interaction, int startRow, int startCol, int endRow, int endCol, String styleName) {
        try {
            int i;
            if (null == message || "null".equals(message)) {
                message = "";
            }
            if (message.indexOf("Lexical error") != -1 && (i = message.lastIndexOf(58)) != -1) {
                message = new StringBuffer().append("Syntax Error:").append(message.substring(i + 2, message.length())).toString();
            }
            if (message.indexOf("Error") == -1) {
                message = new StringBuffer().append("Error: ").append(message).toString();
            }
            this.append(new StringBuffer().append(message).append("\n").toString(), styleName);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCurrentInteraction() {
        this.acquireWriteLock();
        try {
            super.clearCurrentInput();
            this._history.moveEnd();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String getCurrentInteraction() {
        return this.getCurrentInput();
    }

    @Override
    public String getDefaultStyle() {
        return "default";
    }

    @Override
    public void preparePrintJob() {
        this._book = new DrJavaBook(this.getDocText(0, this.getLength()), "Interactions", new PageFormat());
    }

    protected History getHistory() {
        return this._history;
    }
}

