/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class QuestionCurrLineStartsWithSkipComments
extends IndentRuleQuestion {
    private String _prefix;

    public QuestionCurrLineStartsWithSkipComments(String prefix, IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
        this._prefix = prefix;
    }

    boolean applyRule(AbstractDJDocument doc, Indenter.IndentReason reason) {
        try {
            int currentPos = doc.getCurrentLocation();
            int startPos = doc.getLineFirstCharPos(currentPos);
            int endPos = doc.getLineEndPos(currentPos);
            int lineLength = endPos - startPos;
            int previousChar = 0;
            String text = doc.getText(startPos, lineLength);
            for (int i = 0; i < lineLength; ++i) {
                doc.move(startPos - currentPos + i);
                ReducedModelState state = doc.getStateAtCurrent();
                doc.move(-startPos + currentPos - i);
                char currentChar = text.charAt(i);
                if (state.equals(ReducedModelState.INSIDE_LINE_COMMENT)) {
                    return false;
                }
                if (state.equals(ReducedModelState.INSIDE_BLOCK_COMMENT)) {
                    previousChar = 0;
                    continue;
                }
                if (state.equals(ReducedModelState.FREE)) {
                    if (this._prefix.length() > lineLength - i) {
                        return false;
                    }
                    if (text.substring(i, i + this._prefix.length()).equals(this._prefix) && previousChar != 47) {
                        return true;
                    }
                    if (currentChar == '/' ? previousChar == 47 : currentChar != ' ' && currentChar != '\t' && (currentChar != '*' || previousChar != 47)) {
                        return false;
                    }
                }
                if (previousChar == 47 && currentChar != '*') {
                    return false;
                }
                previousChar = currentChar;
            }
            return false;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(new RuntimeException("Bug in QuestionCurrLineStartsWithSkipComments"));
        }
    }
}

