/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SingletonIterable;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.reflect.PreemptingClassLoader;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarJDKToolsLibrary
extends JDKToolsLibrary {
    private static final String[] TOOLS_PACKAGES = new String[]{"com.sun.javadoc", "com.sun.jdi", "com.sun.tools", "sun.applet", "sun.rmi.rmic", "sun.tools", "com.sun.jarsigner", "com.sun.mirror", "sun.jvmstat", "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng"};
    private final File _location;
    private static final /* synthetic */ Class class$java$util$List;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$GlobalModel;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$JarJDKToolsLibrary;

    private JarJDKToolsLibrary(File location, JavaVersion.FullVersion version, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc) {
        super(version, compiler, debugger, javadoc);
        this._location = location;
    }

    public File location() {
        return this._location;
    }

    @Override
    public String toString() {
        return new StringBuffer().append(super.toString()).append(" at ").append(this._location).toString();
    }

    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model) {
        JavaVersion.FullVersion version = JarJDKToolsLibrary.guessVersion(f);
        CompilerInterface compiler = NoCompilerAvailable.ONLY;
        Debugger debugger = NoDebuggerAvailable.ONLY;
        JavadocModel javadoc = new NoJavadocAvailable(model);
        if (JavaVersion.CURRENT.supports(version.majorVersion())) {
            ShadowingClassLoader loader = new ShadowingClassLoader((class$edu$rice$cs$drjava$model$JarJDKToolsLibrary == null ? (class$edu$rice$cs$drjava$model$JarJDKToolsLibrary = JarJDKToolsLibrary.class$("edu.rice.cs.drjava.model.JarJDKToolsLibrary")) : class$edu$rice$cs$drjava$model$JarJDKToolsLibrary).getClassLoader(), TOOLS_PACKAGES);
            SingletonIterable<File> path = IterUtil.singleton(IOUtil.attemptAbsoluteFile(f));
            String compilerAdapter = JarJDKToolsLibrary.adapterForCompiler(version.majorVersion());
            if (compilerAdapter != null) {
                List<File> bootClassPath = null;
                if (f.getName().equals("classes.jar")) {
                    bootClassPath = Arrays.asList(f);
                } else if (f.getName().equals("tools.jar")) {
                    File rtJar = new File(f.getParentFile(), "../jre/lib/rt.jar");
                    if (!rtJar.exists()) {
                        rtJar = new File(f.getParentFile(), "rt.jar");
                    }
                    if (rtJar.exists()) {
                        rtJar = IOUtil.attemptCanonicalFile(rtJar);
                        bootClassPath = Arrays.asList(rtJar);
                    }
                }
                try {
                    Class[] sig = new Class[]{class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion == null ? (class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion = JarJDKToolsLibrary.class$("edu.rice.cs.plt.reflect.JavaVersion$FullVersion")) : class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion, class$java$lang$String == null ? (class$java$lang$String = JarJDKToolsLibrary.class$("java.lang.String")) : class$java$lang$String, class$java$util$List == null ? (class$java$util$List = JarJDKToolsLibrary.class$("java.util.List")) : class$java$util$List};
                    Object[] args = new Object[]{version, f.toString(), bootClassPath};
                    CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadLibraryAdapter((ClassLoader)loader, path, compilerAdapter, sig, args);
                    if (attempt.isAvailable()) {
                        compiler = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            String debuggerAdapter = JarJDKToolsLibrary.adapterForDebugger(version.majorVersion());
            String debuggerPackage = "edu.rice.cs.drjava.model.debug.jpda";
            if (debuggerAdapter != null) {
                try {
                    Class[] sig = new Class[]{class$edu$rice$cs$drjava$model$GlobalModel == null ? (class$edu$rice$cs$drjava$model$GlobalModel = JarJDKToolsLibrary.class$("edu.rice.cs.drjava.model.GlobalModel")) : class$edu$rice$cs$drjava$model$GlobalModel};
                    PreemptingClassLoader debugLoader = new PreemptingClassLoader((ClassLoader)new PathClassLoader((ClassLoader)loader, (Iterable_)((Object)path)), debuggerPackage);
                    Debugger attempt = (Debugger)ReflectUtil.loadObject((ClassLoader)debugLoader, debuggerAdapter, sig, new Object[]{model});
                    if (attempt.isAvailable()) {
                        debugger = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            try {
                new PathClassLoader((ClassLoader)loader, (Iterable_)((Object)path)).loadClass("com.sun.tools.javadoc.Main");
                File bin = new File(f.getParentFile(), "../bin");
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(f.getParentFile(), "../Home/bin");
                }
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(System.getProperty("java.home", f.getParent()));
                }
                javadoc = new DefaultJavadocModel(model, bin, (Iterable_)((Object)path));
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        return new JarJDKToolsLibrary(f, version, compiler, debugger, javadoc);
    }

    private static JavaVersion.FullVersion guessVersion(File f) {
        JavaVersion.FullVersion result = null;
        File current = IOUtil.attemptCanonicalFile(f);
        do {
            String name;
            if ((name = current.getName()).startsWith("jdk")) {
                result = JavaVersion.parseFullVersion(name.substring(3));
                continue;
            }
            if (name.startsWith("j2sdk")) {
                result = JavaVersion.parseFullVersion(name.substring(5));
                continue;
            }
            if (!name.matches("\\d+\\.\\d+\\.\\d+")) continue;
            result = JavaVersion.parseFullVersion(name);
        } while ((current = current.getParentFile()) != null && result == null);
        if (result == null || result.majorVersion().equals(JavaVersion.UNRECOGNIZED)) {
            result = JavaVersion.CURRENT_FULL;
        }
        return result;
    }

    public static Iterable<JarJDKToolsLibrary> search(GlobalModel model) {
        String javaHome = System.getProperty("java.home");
        String envJavaHome = null;
        String programFiles = null;
        String systemDrive = null;
        if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
            envJavaHome = System.getenv("JAVA_HOME");
            programFiles = System.getenv("ProgramFiles");
            systemDrive = System.getenv("SystemDrive");
        }
        LinkedHashSet roots = new LinkedHashSet();
        if (javaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(javaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../.."), roots);
        }
        if (envJavaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, "../.."), roots);
        }
        if (programFiles != null) {
            JarJDKToolsLibrary.addIfDir(new File(programFiles, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(programFiles), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files"), roots);
        if (systemDrive != null) {
            JarJDKToolsLibrary.addIfDir(new File(systemDrive, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(systemDrive), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/System/Library/Frameworks/JavaVM.framework/Versions"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local"), roots);
        LinkedHashSet jars = new LinkedHashSet();
        Predicate<File> subdirFilter = LambdaUtil.or(IOUtil.regexpCanonicalCaseFilePredicate("j2sdk.*"), IOUtil.regexpCanonicalCaseFilePredicate("jdk.*"), IOUtil.regexpCanonicalCaseFilePredicate("\\d+\\.\\d+\\.\\d+"));
        for (File root : roots) {
            Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)root, subdirFilter));
            while (i$.hasNext()) {
                File subdir = (File)i$.next();
                JarJDKToolsLibrary.addIfFile(new File(subdir, "lib/tools.jar"), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Classes/classes.jar"), jars);
            }
        }
        TreeMap<JavaVersion.FullVersion, AbstractIterable> results = new TreeMap<JavaVersion.FullVersion, AbstractIterable>();
        for (File jar : jars) {
            JarJDKToolsLibrary lib = JarJDKToolsLibrary.makeFromFile(jar, model);
            if (!lib.isValid()) continue;
            JavaVersion.FullVersion v = lib.version();
            if (results.containsKey(v)) {
                results.put(v, IterUtil.compose(lib, (Iterable_)results.get(v)));
                continue;
            }
            results.put(v, IterUtil.singleton(lib));
        }
        return IterUtil.reverse((Iterable_)((Object)IterUtil.collapse(results.values())));
    }

    private static void addIfDir(File f, Set<? super File> set) {
        if (IOUtil.attemptIsDirectory(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
        }
    }

    private static void addIfFile(File f, Set<? super File> set) {
        if (IOUtil.attemptIsFile(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

