/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.RemoteControlServer;
import edu.rice.cs.drjava.config.OptionConstants;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class RemoteControlClient {
    protected static boolean _serverRunning = false;
    protected static String _serverUser = null;
    public static int REMOTE_CONTROL_TIMEOUT = 250;

    public static boolean isServerRunning() {
        return _serverRunning;
    }

    public static String getServerUser() {
        return _serverUser;
    }

    public static boolean openFile(File f) throws IOException {
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(REMOTE_CONTROL_TIMEOUT);
            String dString = "DrJava Remote Control?";
            if (f != null) {
                dString = dString + " " + f.getAbsolutePath();
            }
            byte[] buf = dString.getBytes();
            InetAddress address = InetAddress.getByName("127.0.0.1");
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_PORT));
            socket.send(packet);
            buf = new byte[512];
            packet = new DatagramPacket(buf, buf.length);
            socket.receive(packet);
            String received = new String(packet.getData(), 0, packet.getLength());
            _serverRunning = received.startsWith("DrJava Remote Control ");
            if (_serverRunning) {
                int pos = received.indexOf(33);
                _serverUser = received.substring("DrJava Remote Control ".length(), pos);
            } else {
                _serverUser = null;
            }
            socket.close();
            return received.equals(RemoteControlServer.RESPONSE_PREFIX_WITH_USER);
        }
        catch (SocketTimeoutException e) {
            _serverRunning = false;
            return false;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                boolean ret = RemoteControlClient.openFile(new File(args[i]));
                System.out.println("openFile returned " + ret);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

