/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Map
implements ActionListener {
    public JFrame frame = new JFrame("J*Man!!!");
    private JManPanel board;
    private JButton bUp = new JButton("Up");
    private JButton bDown = new JButton("Down");
    private JButton bLeft = new JButton("Left");
    private JButton bRight = new JButton("Right");
    private JButton bnewGame = new JButton("New Game");
    private Box buttonBox = new Box(0);
    Box instructBox = new Box(1);
    private int height = 20;
    private int width = 20;
    private int tileWidth = 16;
    private int tileHeight = 16;
    private Piece[][] grid;
    private JMan jMan;

    public static void main(String[] pars) {
        Map m = new Map();
    }

    public Map() {
        this(20, 20, 20, 10, 10);
    }

    public Map(int h, int w, int bl, int wa, int pi) {
        this.height = h;
        this.width = w;
        Dimension buttondim = new Dimension(this.width * this.tileWidth / 4, 27);
        this.bUp.setPreferredSize(buttondim);
        this.bDown.setPreferredSize(buttondim);
        this.bLeft.setPreferredSize(buttondim);
        this.bRight.setPreferredSize(buttondim);
        this.bnewGame.setPreferredSize(new Dimension(this.width * this.tileWidth / 2, 27));
        this.buttonBox.add(this.bUp);
        this.buttonBox.add(this.bDown);
        this.buttonBox.add(this.bLeft);
        this.buttonBox.add(this.bRight);
        this.buttonBox.setAlignmentX(0.0f);
        this.bUp.addActionListener(this);
        this.bDown.addActionListener(this);
        this.bLeft.addActionListener(this);
        this.bRight.addActionListener(this);
        this.bnewGame.addActionListener(this);
        this.board = new JManPanel(this);
        this.instructBox.setAlignmentX(0.0f);
        this.instructBox.add(this.buttonBox);
        this.addInstructions(this.instructBox);
        this.grid = new Piece[this.width][this.height];
        this.putNew(1, 0, 0);
        this.putOnMap(bl, wa, pi);
        this.frame.getContentPane().add((Component)this.bnewGame, "North");
        this.frame.getContentPane().add((Component)this.board, "Center");
        this.frame.getContentPane().add((Component)this.instructBox, "South");
        this.frame.pack();
        this.frame.setLocation(5, 30);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private void addInstructions(Box instructBox) {
        instructBox.add(new JLabel(" Use the four buttons to direct J*Man (the star-", 2));
        instructBox.add(new JLabel(" like piece) to capture the other colored pieces.", 2));
        instructBox.add(new JLabel(" J*Man can capture: ", 2));
        instructBox.add(new JLabel("    a green piece if he is yellow,", 2));
        instructBox.add(new JLabel("    a yellow piece if he is red, ", 2));
        instructBox.add(new JLabel("    a red piece if he is green.", 2));
        instructBox.add(new JLabel(" Walkers (circles) wander randomly about.", 2));
        instructBox.add(new JLabel(" Pillars (triangles) change color occasionally.", 2));
        instructBox.add(new JLabel(" Nothing can enter a block (white square).", 2));
        instructBox.add(new JLabel(" Be careful. With patience, you can always capture ", 2));
        instructBox.add(new JLabel(" a pillar, but capturing all walkers requires ", 2));
        instructBox.add(new JLabel(" thinking ahead. Good Luck!", 2));
    }

    private void putOnMap(int bl, int wa, int pi) {
        int yy;
        int xx;
        int k = 0;
        while (k < bl) {
            xx = Piece.rand(0, this.width - 1);
            if (!this.isEmpty(xx, yy = Piece.rand(0, this.height - 1))) continue;
            this.putNew(0, xx, yy);
            ++k;
        }
        k = 0;
        while (k < wa) {
            xx = Piece.rand(0, this.width - 1);
            if (!this.isEmpty(xx, yy = Piece.rand(0, this.height - 1))) continue;
            this.putNew(2, xx, yy);
            ++k;
        }
        k = 0;
        while (k < pi) {
            xx = Piece.rand(0, this.width - 1);
            if (!this.isEmpty(xx, yy = Piece.rand(0, this.height - 1))) continue;
            this.putNew(3, xx, yy);
            ++k;
        }
    }

    public void putNew(int typ, int x, int y) {
        if (this.isEmpty(x, y)) {
            if (typ == 0) {
                this.grid[x][y] = new Block(x, y, this);
            } else if (typ == 2) {
                this.grid[x][y] = new Walker(x, y, Piece.rand(0, 2), this);
            } else if (typ == 1) {
                this.jMan = new JMan(x, y, Piece.rand(0, 2), this);
                this.grid[x][y] = this.jMan;
            } else if (typ == 3) {
                this.grid[x][y] = new Pillar(x, y, Piece.rand(0, 2), this);
            }
        }
    }

    public boolean isInGrid(int x, int y) {
        return x > -1 && y > -1 && x < this.width && y < this.height;
    }

    public boolean isEmpty(int x, int y) {
        return this.isInGrid(x, y) && this.grid[x][y] == null;
    }

    public Piece pieceAt(int x, int y) {
        if (this.isInGrid(x, y)) {
            return this.grid[x][y];
        }
        return null;
    }

    public void move(int fromX, int fromY, int toX, int toY) {
        this.grid[toX][toY] = this.grid[fromX][fromY];
        this.grid[fromX][fromY] = null;
    }

    public void act() {
        int j;
        int i;
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                if (this.isEmpty(i, j)) continue;
                Piece p = this.grid[i][j];
                p.act();
                p.setActed(true);
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                if (this.isEmpty(i, j)) continue;
                this.grid[i][j].setActed(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bUp) {
            this.jMan.step(0);
            this.act();
        } else if (e.getSource() == this.bDown) {
            this.jMan.step(1);
            this.act();
        } else if (e.getSource() == this.bLeft) {
            this.jMan.step(2);
            this.act();
        } else if (e.getSource() == this.bRight) {
            this.jMan.step(3);
            this.act();
        } else if (e.getSource() == this.bnewGame && JOptionPane.showConfirmDialog(this.frame, "Start a new game of the standard size?", "New Game?", 2) == 0) {
            new Map();
        }
        this.board.repaint();
    }

    private class JManPanel
    extends JPanel {
        private Map m;

        public JManPanel(Map m) {
            this.m = m;
            this.setPreferredSize(new Dimension(Map.this.tileWidth * Map.this.width, Map.this.tileHeight * Map.this.height));
        }

        public void paint(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.m.width * this.m.tileWidth, this.m.height * this.m.tileHeight);
            for (int i = 0; i < this.m.width; ++i) {
                for (int j = 0; j < this.m.height; ++j) {
                    int h = i * this.m.tileWidth;
                    int h1 = (i + 1) * this.m.tileWidth;
                    int v = j * this.m.tileHeight;
                    int v1 = (j + 1) * this.m.tileHeight;
                    if (this.m.grid[i][j] != null && this.m.grid[i][j].getType() == 0) {
                        g.setColor(Color.WHITE);
                        g.fillRect(h + 1, v, this.m.tileWidth - 2, this.m.tileHeight - 2);
                        continue;
                    }
                    if (this.m.grid[i][j] != null && this.m.grid[i][j].getType() == 1) {
                        g.setColor(Map.this.jMan.getColor());
                        g.drawLine(h + 3, v + 2, h1 - 3, v1 - 2);
                        g.drawLine(h + 3, v1 - 2, h1 - 3, v + 2);
                        g.drawLine(h + 1, v + this.m.tileHeight / 2, h1 - 1, v + this.m.tileHeight / 2);
                        g.drawLine(h + this.m.tileWidth / 2, v + 1, h + this.m.tileWidth / 2, v1 - 1);
                        continue;
                    }
                    if (this.m.grid[i][j] != null && this.m.grid[i][j].getType() == 2) {
                        g.setColor(this.m.grid[i][j].getColor());
                        g.fillOval(h + 1, v, this.m.tileWidth - 2, this.m.tileHeight - 2);
                        continue;
                    }
                    if (this.m.grid[i][j] == null || this.m.grid[i][j].getType() != 3) continue;
                    g.setColor(this.m.grid[i][j].getColor());
                    g.fillPolygon(new int[]{h + 1, h1 - 1, h + this.m.tileWidth / 2}, new int[]{v1 - 2, v1 - 2, v}, 3);
                }
            }
        }
    }
}

