/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.ContinueTarget;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForSlashEachStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachStatement
extends ForSlashEachStatement
implements ContinueTarget {
    public static final String PARAMETER = "parameter";
    public static final String COLLECTION = "collection";
    public static final String BODY = "body";
    private FormalParameter parameter;
    private Expression collection;
    private Node body;
    private List<String> labels;
    private List<String> vars;

    public ForEachStatement(FormalParameter para, Expression collection, Node body) {
        this(para, collection, body, null, 0, 0, 0, 0);
    }

    public ForEachStatement(FormalParameter para, Expression coll, Node body, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.parameter = para;
        this.collection = coll;
        this.body = body;
        this.labels = new LinkedList<String>();
        this.vars = new LinkedList<String>();
    }

    public void addVar(String s) {
        this.vars.add(s);
    }

    public List<String> getVars() {
        return this.vars;
    }

    public FormalParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(FormalParameter l) {
        this.parameter = l;
        this.firePropertyChange(PARAMETER, this.parameter, this.parameter);
    }

    public Expression getCollection() {
        return this.collection;
    }

    public void setCollection(Expression e) {
        this.collection = e;
        this.firePropertyChange(COLLECTION, this.collection, this.collection);
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.body = node;
        this.firePropertyChange(BODY, this.body, this.body);
    }

    @Override
    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        this.labels.add(label);
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.getParameter()).append(" ").append(this.getCollection()).append(" ").append(this.getBody()).append(")").toString();
    }
}

