/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.util.LocalizedMessageReader;

public class ExecutionError
extends Error {
    protected Throwable thrown;
    private static final String BUNDLE = "koala.dynamicjava.interpreter.resources.messages";
    public static final String SHOW_CAUSE_PROPERTY = "koala.dynamicjava.interpreter.showCause";
    public static final String SHOW_TRACE_PROPERTY = "koala.dynamicjava.interpreter.showTrace";
    private static final LocalizedMessageReader reader = new LocalizedMessageReader("koala.dynamicjava.interpreter.resources.messages");
    private Node node;
    private String rawMessage;

    public ExecutionError() {
        this("");
    }

    public ExecutionError(String s) {
        this(s, (Node)null);
    }

    public ExecutionError(String s, Node n) {
        this.rawMessage = s;
        this.node = n;
    }

    public ExecutionError(Throwable thrown) {
        this.thrown = thrown;
    }

    public Node getNode() {
        return this.node;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s, true));
    }

    public void printStackTrace(PrintWriter w) {
        String trace = System.getProperty(SHOW_TRACE_PROPERTY);
        if (trace != null && !new Boolean(trace).booleanValue()) {
            w.println(this);
        } else {
            super.printStackTrace(w);
            String cause = System.getProperty(SHOW_CAUSE_PROPERTY);
            if ((cause == null || new Boolean(cause).booleanValue()) && this.thrown != null) {
                w.println("Caused by: ");
                this.thrown.printStackTrace(w);
            }
        }
    }

    public String getMessage() {
        return reader.getMessage(this.rawMessage, this.node != null && this.node.hasProperty("errorStrings") ? (String[])this.node.getProperty("errorStrings") : null);
    }
}

