/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class CodeAttribute
extends AttributeInfo {
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private List<ExceptionTableEntry> exceptionTable;
    private List attributes;

    public CodeAttribute(ConstantPool cp) {
        super(cp, "Code");
        this.length = 12;
        this.exceptionTable = new LinkedList<ExceptionTableEntry>();
        this.attributes = new LinkedList();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.nameIndex);
        out.writeInt(this.length);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.code.length);
        out.write(this.code);
        out.writeShort(this.exceptionTable.size());
        Iterator<ExceptionTableEntry> it = this.exceptionTable.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
        out.writeShort(this.attributes.size());
        it = this.attributes.iterator();
        while (it.hasNext()) {
            ((AttributeInfo)((Object)it.next())).write(out);
        }
    }

    public void setCode(byte[] code, short nl, short ms) {
        this.maxLocals = nl;
        this.maxStack = ms;
        this.code = code;
        this.length += code.length;
    }

    public void addExceptionTableEntry(short spc, short epc, short tpc, String ex) {
        String n = JVMUtilities.getName(ex);
        short s = this.constantPool.put(new ClassIdentifier(n));
        ExceptionTableEntry ee = new ExceptionTableEntry(spc, epc, tpc, s);
        this.exceptionTable.add(ee);
        this.length += ee.getLength();
    }

    class ExceptionTableEntry {
        private short startPc;
        private short endPc;
        private short handlerPc;
        private short catchType;

        public ExceptionTableEntry(short spc, short epc, short hpc, short ct) {
            this.startPc = spc;
            this.endPc = epc;
            this.handlerPc = hpc;
            this.catchType = ct;
        }

        public short getLength() {
            return 8;
        }

        public void write(OutputStream out) throws IOException {
            this.write(new DataOutputStream(out));
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeShort(this.startPc);
            out.writeShort(this.endPc);
            out.writeShort(this.handlerPc);
            out.writeShort(this.catchType);
        }
    }
}

