/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.DocumentEditCondition;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.EditDocumentInterface;
import java.awt.print.Pageable;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;

public class SwingDocument
extends DefaultStyledDocument
implements EditDocumentInterface,
AbstractDocumentInterface {
    protected final Hashtable<String, AttributeSet> _styles = new Hashtable();
    protected DocumentEditCondition _condition = new DocumentEditCondition();
    protected static final Object _wrappedPosListLock = new Object();

    public void setDocStyle(String name, AttributeSet s) {
        this._styles.put(name, s);
    }

    public AttributeSet getDocStyle(String name) {
        return this._styles.get(name);
    }

    public void addColoring(int start, int end, String style) {
    }

    public DocumentEditCondition getEditCondition() {
        return this._condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditCondition(DocumentEditCondition condition) {
        this.acquireWriteLock();
        try {
            this._condition = condition;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void clear() {
        this.acquireWriteLock();
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(int offs, String str, String style) {
        this.acquireWriteLock();
        try {
            this._insertText(offs, str, style);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void _insertText(int offs, String str, String style) {
        if (this._condition.canInsertText(offs)) {
            this._forceInsertText(offs, str, style);
        }
    }

    public void _forceInsertText(int offs, String str, String style) {
        int len = this.getLength();
        if (offs < 0 || offs > len) {
            String msg = "Offset " + offs + " passed to SwingDocument.forceInsertText is out of bounds [0, " + len + "]";
            throw new EditDocumentException(null, msg);
        }
        AttributeSet s = null;
        if (style != null) {
            s = this.getDocStyle(style);
        }
        try {
            super.insertString(offs, str, s);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInsertText(int offs, String str, String style) {
        this.acquireWriteLock();
        try {
            this._forceInsertText(offs, str, style);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offs, String str, AttributeSet set) throws BadLocationException {
        this.acquireWriteLock();
        try {
            if (this._condition.canInsertText(offs)) {
                super.insertString(offs, str, set);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeText(int offs, int len) {
        this.acquireWriteLock();
        try {
            this._removeText(offs, len);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void _removeText(int offs, int len) {
        if (this._condition.canRemoveText(offs)) {
            this.forceRemoveText(offs, len);
        }
    }

    public void forceRemoveText(int offs, int len) {
        try {
            super.remove(offs, len);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offs, int len) throws BadLocationException {
        this.acquireWriteLock();
        try {
            if (this._condition.canRemoveText(offs)) {
                super.remove(offs, len);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String getDocText(int offs, int len) {
        try {
            return this.getText(offs, len);
        }
        catch (BadLocationException e) {
            throw new EditDocumentException(e);
        }
    }

    public String getText() {
        this.acquireReadLock();
        try {
            String string = this.getText(0, this.getLength());
            return string;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void append(String str, AttributeSet set) {
        this.acquireWriteLock();
        try {
            this.insertString(this.getLength(), str, set);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void append(String str, String style) {
        this.append(str, style == null ? null : this.getDocStyle(style));
    }

    public String getDefaultStyle() {
        return null;
    }

    public void print() {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public Pageable getPageable() {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public void acquireReadLock() {
        this.readLock();
    }

    public void releaseReadLock() {
        this.readUnlock();
    }

    public void acquireWriteLock() {
        this.writeLock();
    }

    public void releaseWriteLock() {
        this.writeUnlock();
    }

    public Position createUnwrappedPosition(int offs) throws BadLocationException {
        return super.createPosition(offs);
    }
}

