/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreemptingClassLoader
extends ClassLoader {
    private Iterable<String> _prefixes;

    public PreemptingClassLoader(ClassLoader parent, String ... prefixes) {
        this(parent, (Iterable_)((Object)IterUtil.asIterable(prefixes)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public PreemptingClassLoader(ClassLoader parent, Iterable_ prefixes) {
        super(parent);
        this._prefixes = IterUtil.snapshot(prefixes);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            if (this.shouldPreempt(name)) {
                String filename = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
                BufferedInputStream in = IOUtil.asBuffered(this.getResourceAsStream(filename));
                if (in == null) {
                    throw new ClassNotFoundException(new StringBuffer().append("Resource not found: ").append(filename).toString());
                }
                try {
                    byte[] data = IOUtil.toByteArray(in);
                    result = this.defineClass(name, data, 0, data.length);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(new StringBuffer().append("Error in reading ").append(filename).toString(), e);
                }
                finally {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {}
                }
            }
            result = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private boolean shouldPreempt(String name) {
        Iterator i$ = IterableMethods.iterator(this._prefixes);
        while (i$.hasNext()) {
            String p = (String)i$.next();
            if (!name.startsWith(p) || !name.equals(p) && !name.startsWith(new StringBuffer().append(p).append(".").toString()) && !name.startsWith(new StringBuffer().append(p).append("$").toString())) continue;
            return true;
        }
        return false;
    }
}

