/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import java.io.Serializable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandingBuffer<T>
implements Serializable {
    protected static final int BUFFER_SIZE = 1024;
    private final LinkedList<T> _buffers = new LinkedList();
    private long _base = 0L;
    private long _nextBuffer = 0L;
    private long _first = 0L;
    private long _last = 0L;

    protected abstract T allocateBuffer(int var1);

    public synchronized long size() {
        return this._last - this._first;
    }

    public synchronized boolean isEmpty() {
        return this._first == this._last;
    }

    protected int allocate() {
        if (this._last == this._nextBuffer) {
            this._buffers.addLast(this.allocateBuffer(1024));
            this._nextBuffer += 1024L;
            return 1024;
        }
        return (int)(this._nextBuffer - this._last);
    }

    protected int elementsInFirstBuffer() {
        long secondBuffer = this._base + 1024L;
        return (int)((secondBuffer > this._last ? this._last : secondBuffer) - this._base);
    }

    protected boolean deallocate() {
        long secondBuffer = this._base + 1024L;
        if (this._first >= secondBuffer) {
            this._buffers.removeFirst();
            this._base = secondBuffer;
            return true;
        }
        return false;
    }

    protected T firstBuffer() {
        return this._buffers.getFirst();
    }

    protected int firstIndex() {
        return (int)(this._first - this._base);
    }

    protected T lastBuffer() {
        return this._buffers.getLast();
    }

    protected int lastIndex() {
        return (int)(this._last - (this._nextBuffer - 1024L));
    }

    protected void recordWrite(long written) {
        this._last += written;
    }

    protected void recordRead(long read) {
        this._first += read;
    }
}

