/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.collect.TotalMap;
import edu.rice.cs.plt.debug.AbstractLog;
import edu.rice.cs.plt.debug.Indenter;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextLog
extends AbstractLog {
    private static final String HANGING_INDENT = "    ";
    private static final Lambda<Thread, Indenter> MAKE_INDENTER = new Lambda<Thread, Indenter>(){

        @Override
        public Indenter value(Thread t) {
            return new Indenter();
        }

        @Override
        public Object value(Object x0) {
            return this.value((Thread)x0);
        }
    };
    private final TotalMap<Thread, Indenter> _indenters = new TotalMap<Thread, Indenter>(MAKE_INDENTER, true);

    protected TextLog() {
    }

    protected TextLog(Predicate2<? super Thread, ? super StackTraceElement> filter) {
        super(filter);
    }

    protected void writeText(BufferedWriter w, Date time, Thread thread, StackTraceElement location, SizedIterable<? extends String> messages) {
        try {
            Indenter indent = this._indenters.get(thread);
            w.write(indent.indentString());
            w.write(new StringBuffer().append("[").append(this.formatLocation(location)).append(" - ").append(this.formatThread(thread)).append(" - ").append(this.formatTime(time)).append("]").toString());
            w.newLine();
            for (String string : messages) {
                w.write(indent.indentString());
                w.write(HANGING_INDENT);
                w.write(string);
                w.newLine();
            }
            w.flush();
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    protected void push() {
        this._indenters.get(Thread.currentThread()).push();
    }

    @Override
    protected void pop() {
        this._indenters.get(Thread.currentThread()).pop();
    }
}

