/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.DelegatedSet;
import edu.rice.cs.plt.collect.ImmutableMapEntry;
import edu.rice.cs.plt.collect.OneToOneMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneHashMap<K, V>
extends AbstractMap<K, V>
implements OneToOneMap<K, V> {
    private final HashMap<K, V> _forward;
    private final HashMap<V, K> _backward;

    public OneToOneHashMap() {
        this._forward = new HashMap();
        this._backward = new HashMap();
    }

    private OneToOneHashMap(HashMap<K, V> forward, HashMap<V, K> backward) {
        this._forward = forward;
        this._backward = backward;
    }

    @Override
    public int size() {
        return this._forward.size();
    }

    @Override
    public boolean isEmpty() {
        return this._forward.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._backward.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this._forward.get(key);
    }

    @Override
    public V getValue(K key) {
        return this._forward.get(key);
    }

    @Override
    public K getKey(V value) {
        return this._backward.get(value);
    }

    @Override
    public V put(K key, V value) {
        V result = this._forward.get(key);
        if (this._forward.containsKey(key)) {
            this._backward.remove(result);
        }
        if (this._backward.containsKey(value)) {
            this._forward.remove(this._backward.get(value));
        }
        this._forward.put(key, value);
        this._backward.put(value, key);
        return result;
    }

    @Override
    public V remove(Object key) {
        if (this._forward.containsKey(key)) {
            V result = this._forward.remove(key);
            this._backward.remove(result);
            return result;
        }
        return null;
    }

    @Override
    public V removeKey(K key) {
        return this.remove(key);
    }

    @Override
    public K removeValue(V value) {
        if (this._backward.containsKey(value)) {
            K result = this._backward.remove(value);
            this._forward.remove(result);
            return result;
        }
        return null;
    }

    @Override
    public boolean remove(K key, V value) {
        if (this._forward.containsKey(key) && this._forward.get(key).equals(value)) {
            this._forward.remove(key);
            this._backward.remove(value);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._forward.clear();
        this._backward.clear();
    }

    @Override
    public Set<K> keySet() {
        return new DelegatedSet<K>(this._forward.keySet()){

            @Override
            public Iterator<K> iterator() {
                final Iterator forwardIter = this._delegate.iterator();
                return new Iterator<K>(){
                    private K _last = null;

                    @Override
                    public boolean hasNext() {
                        return forwardIter.hasNext();
                    }

                    @Override
                    public K next() {
                        this._last = forwardIter.next();
                        return this._last;
                    }

                    @Override
                    public void remove() {
                        Object val = OneToOneHashMap.access$000(OneToOneHashMap.this).get(this._last);
                        forwardIter.remove();
                        OneToOneHashMap.access$100(OneToOneHashMap.this).remove(val);
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (this._delegate.contains(o)) {
                    Object val = OneToOneHashMap.access$000(OneToOneHashMap.this).get(o);
                    OneToOneHashMap.access$000(OneToOneHashMap.this).remove(o);
                    OneToOneHashMap.access$100(OneToOneHashMap.this).remove(val);
                    return true;
                }
                return false;
            }

            @Override
            public boolean add(K o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.abstractSetRetainAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.abstractSetRemoveAll(c);
            }

            @Override
            public void clear() {
                OneToOneHashMap.this.clear();
            }
        };
    }

    @Override
    public Set<V> values() {
        return this.reverse().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new DelegatedSet<Map.Entry<K, V>>(this._forward.entrySet()){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator forwardIter = this._delegate.iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    private Map.Entry<K, V> _last = null;

                    @Override
                    public boolean hasNext() {
                        return forwardIter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this._last = new ImmutableMapEntry((Map.Entry)forwardIter.next());
                        return this._last;
                    }

                    @Override
                    public void remove() {
                        forwardIter.remove();
                        OneToOneHashMap.access$100(OneToOneHashMap.this).remove(this._last.getValue());
                    }

                    @Override
                    public Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (this._delegate.contains(o)) {
                    Map.Entry entry = (Map.Entry)o;
                    OneToOneHashMap.access$000(OneToOneHashMap.this).remove(entry.getKey());
                    OneToOneHashMap.access$100(OneToOneHashMap.this).remove(entry.getValue());
                    return true;
                }
                return false;
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.abstractSetRetainAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.abstractSetRemoveAll(c);
            }

            @Override
            public void clear() {
                OneToOneHashMap.this.clear();
            }

            @Override
            public boolean add(Object x0) {
                return this.add((Map.Entry)x0);
            }
        };
    }

    @Override
    public OneToOneMap<V, K> reverse() {
        return new OneToOneHashMap<V, K>(this._backward, this._forward);
    }

    @Override
    public Collection values() {
        return this.values();
    }

    static HashMap access$000(OneToOneHashMap x0) {
        return x0._forward;
    }

    static HashMap access$100(OneToOneHashMap x0) {
        return x0._backward;
    }
}

