/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.plt.collect.ConsList;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsVisitor<T, Ret>
implements Lambda<ConsList<? extends T>, Ret> {
    public static final ConsVisitor<Object, Boolean> IS_EMPTY = new ConsVisitor<Object, Boolean>(){

        @Override
        public Boolean forEmpty(ConsList.Empty<?> list) {
            return Autobox.valueOf(true);
        }

        @Override
        public Boolean forNonempty(ConsList.Nonempty<?> list) {
            return Autobox.valueOf(false);
        }

        @Override
        public Object forNonempty(ConsList.Nonempty x0) {
            return this.forNonempty(x0);
        }

        @Override
        public Object forEmpty(ConsList.Empty x0) {
            return this.forEmpty(x0);
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }
    };

    public abstract Ret forEmpty(ConsList.Empty<? extends T> var1);

    public abstract Ret forNonempty(ConsList.Nonempty<? extends T> var1);

    @Override
    public Ret value(ConsList<? extends T> list) {
        return list.apply(this);
    }

    public static <T> ConsVisitor<T, ConsList<? extends T>> reverse() {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReverseHelper
        extends ConsVisitor<T, ConsList<? extends T>> {
            private ConsList<? extends T> _toAppend;

            public ReverseHelper(ConsList<? extends T> toAppend) {
                this._toAppend = toAppend;
            }

            @Override
            public ConsList<? extends T> forEmpty(ConsList.Empty<? extends T> list) {
                return this._toAppend;
            }

            @Override
            public ConsList<? extends T> forNonempty(ConsList.Nonempty<? extends T> list) {
                return (ConsList)list.rest().apply(new ReverseHelper(ConsList.cons(list.first(), this._toAppend)));
            }

            @Override
            public Object forNonempty(ConsList.Nonempty x0) {
                return this.forNonempty(x0);
            }

            @Override
            public Object forEmpty(ConsList.Empty x0) {
                return this.forEmpty(x0);
            }

            @Override
            public Object value(Object x0) {
                return super.value((ConsList)x0);
            }
        }
        return new ReverseHelper(ConsList.empty());
    }

    public static <T> ConsVisitor<T, ConsList<? extends T>> append(final ConsList<? extends T> rest) {
        return new ConsVisitor<T, ConsList<? extends T>>(){

            @Override
            public ConsList<? extends T> forEmpty(ConsList.Empty<? extends T> list) {
                return rest;
            }

            @Override
            public ConsList<? extends T> forNonempty(ConsList.Nonempty<? extends T> list) {
                return ConsList.cons(list.first(), (ConsList)list.rest().apply(this));
            }

            @Override
            public Object forNonempty(ConsList.Nonempty x0) {
                return this.forNonempty(x0);
            }

            @Override
            public Object forEmpty(ConsList.Empty x0) {
                return this.forEmpty(x0);
            }

            @Override
            public Object value(Object x0) {
                return super.value((ConsList)x0);
            }
        };
    }

    public static <T> ConsVisitor<T, ConsList<? extends T>> filter(final Predicate<? super T> pred) {
        return new ConsVisitor<T, ConsList<? extends T>>(){

            @Override
            public ConsList<? extends T> forEmpty(ConsList.Empty<? extends T> list) {
                return list;
            }

            @Override
            public ConsList<? extends T> forNonempty(ConsList.Nonempty<? extends T> list) {
                if (pred.value(list.first()).booleanValue()) {
                    return ConsList.cons(list.first(), (ConsList)list.rest().apply(this));
                }
                return (ConsList)list.rest().apply(this);
            }

            @Override
            public Object forNonempty(ConsList.Nonempty x0) {
                return this.forNonempty(x0);
            }

            @Override
            public Object forEmpty(ConsList.Empty x0) {
                return this.forEmpty(x0);
            }

            @Override
            public Object value(Object x0) {
                return super.value((ConsList)x0);
            }
        };
    }

    public static <S, T> ConsVisitor<S, ConsList<? extends T>> map(final Lambda<? super S, ? extends T> lambda) {
        return new ConsVisitor<S, ConsList<? extends T>>(){

            @Override
            public ConsList<? extends T> forEmpty(ConsList.Empty<? extends S> list) {
                return ConsList.empty();
            }

            @Override
            public ConsList<? extends T> forNonempty(ConsList.Nonempty<? extends S> list) {
                return ConsList.cons(lambda.value(list.first()), (ConsList)list.rest().apply(this));
            }

            @Override
            public Object forNonempty(ConsList.Nonempty x0) {
                return this.forNonempty(x0);
            }

            @Override
            public Object forEmpty(ConsList.Empty x0) {
                return this.forEmpty(x0);
            }

            @Override
            public Object value(Object x0) {
                return super.value((ConsList)x0);
            }
        };
    }

    @Override
    public Object value(Object x0) {
        return this.value((ConsList)x0);
    }
}

