/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SuperReference;
import edu.rice.cs.javalanglevels.tree.ThisReference;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyAdvancedVisitor
extends AdvancedVisitor {
    private SymbolData _symbolData;

    public InterfaceBodyAdvancedVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public void forStatementDoFirst(Statement that) {
        InterfaceBodyAdvancedVisitor._addError("Statements cannot appear outside of method bodies", that);
    }

    @Override
    public void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        InterfaceBodyAdvancedVisitor._addError("You cannot have concrete methods definitions in interfaces", that);
    }

    @Override
    public void forInstanceInitializerDoFirst(InstanceInitializer that) {
        InterfaceBodyAdvancedVisitor._addError("This open brace must mark the beginning of an interface body", that);
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._symbolData);
        LinkedList<VariableData> vdsList = new LinkedList<VariableData>();
        for (int i = 0; i < vds.length; ++i) {
            if (that.getDeclarators()[i] instanceof UninitializedVariableDeclarator) {
                InterfaceBodyAdvancedVisitor._addAndIgnoreError("All fields in interfaces must be assigned a value when they are declared", that);
                continue;
            }
            vdsList.addLast(vds[i]);
        }
        if (!this._symbolData.addVars(vdsList.toArray(new VariableData[vdsList.size()]))) {
            InterfaceBodyAdvancedVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses or interfaces has a field by that name", that);
        }
    }

    @Override
    public void forThisReferenceDoFirst(ThisReference that) {
        InterfaceBodyAdvancedVisitor._addAndIgnoreError("The field 'this' does not exist in interfaces.  Only classes have a 'this' field.", that);
    }

    @Override
    public void forSuperReferenceDoFirst(SuperReference that) {
        InterfaceBodyAdvancedVisitor._addAndIgnoreError("The field 'super' does not exist in interfaces.  Only classes have a 'super' field", that);
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        if (md.hasModifier("private")) {
            InterfaceBodyAdvancedVisitor._addAndIgnoreError("Interface methods cannot be made private.  They must be public.", that.getMav());
        }
        if (md.hasModifier("protected")) {
            InterfaceBodyAdvancedVisitor._addAndIgnoreError("Interface methods cannot be made protected.  They must be public.", that.getMav());
        }
        md.addModifier("public");
        md.addModifier("abstract");
        String className = InterfaceBodyAdvancedVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            InterfaceBodyAdvancedVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors cannot appear in interfaces.", that);
        } else {
            this._symbolData.addMethod(md);
        }
    }

    @Override
    public void forInnerInterfaceDef(InnerInterfaceDef that) {
        this.handleInnerInterfaceDef(that, this._symbolData, new StringBuffer().append(this.getQualifiedClassName(this._symbolData.getName())).append("$").append(that.getName().getText()).toString());
    }

    @Override
    public void forInnerClassDef(InnerClassDef that) {
        this.handleInnerClassDef(that, this._symbolData, new StringBuffer().append(this.getQualifiedClassName(this._symbolData.getName())).append("$").append(that.getName().getText()).toString());
    }

    @Override
    public void forConstructorDefDoFirst(ConstructorDef that) {
        InterfaceBodyAdvancedVisitor._addAndIgnoreError("Constructor definitions cannot appear in interfaces", that);
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        System.out.println(new StringBuffer().append("Calling simpleAnonymousClassInstantiation Helper from InterfaceBody ").append(that.getSourceInfo()).toString());
        this.simpleAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    static SymbolData access$000(InterfaceBodyAdvancedVisitor x0) {
        return x0._symbolData;
    }

    static SymbolData access$002(InterfaceBodyAdvancedVisitor x0, SymbolData x1) {
        x0._symbolData = x1;
        return x0._symbolData;
    }
}

